/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.ec.ECKeyFactory;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AlgorithmId
implements Serializable,
DerEncoder {
    private static final long serialVersionUID = 7205873507486557157L;
    private static boolean initOidTable = false;
    private static Map<String, ObjectIdentifier> oidTable;
    private String provider;
    private ObjectIdentifier algid;
    private AlgorithmParameters algParams;
    protected DerValue params;
    private static Debug debug;
    private static String className;
    private static final int[] MD2_data;
    private static final int[] MD5_data;
    private static final int[] SHA1_OIW_data;
    private static final int[] SHA256_data;
    private static final int[] SHA384_data;
    private static final int[] SHA512_data;
    private static final int[] HmacSHA1_data;
    private static final int[] PasswordBasedMac_data;
    public static ObjectIdentifier MD2_oid;
    public static ObjectIdentifier MD5_oid;
    public static ObjectIdentifier SHA_oid;
    public static ObjectIdentifier SHA256_oid;
    public static ObjectIdentifier SHA384_oid;
    public static ObjectIdentifier SHA512_oid;
    public static ObjectIdentifier HmacSHA1_oid;
    public static ObjectIdentifier PasswordBasedMac_oid;
    private static final int[] DH_data;
    private static final int[] DH_PKIX_data;
    private static final int[] DSA_OIW_data;
    private static final int[] DSA_PKIX_data;
    private static final int[] RSA_data;
    private static final int[] RSAEncryption_data;
    public static ObjectIdentifier DH_oid;
    public static ObjectIdentifier DH_PKIX_oid;
    public static ObjectIdentifier DSA_OIW_oid;
    public static ObjectIdentifier DSA_oid;
    public static ObjectIdentifier RSA_oid;
    public static ObjectIdentifier RSAEncryption_oid;
    public static ObjectIdentifier EC_oid;
    private static final int[] md2WithRSAEncryption_data;
    private static final int[] md5WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_OIW_data;
    private static final int[] sha256WithRSAEncryption_data;
    private static final int[] sha384WithRSAEncryption_data;
    private static final int[] sha512WithRSAEncryption_data;
    private static final int[] shaWithDSA_OIW_data;
    private static final int[] sha1WithDSA_OIW_data;
    private static final int[] dsaWithSHA1_PKIX_data;
    private static final int[] DESCBC_data;
    private static final int[] tripleDESCBC_data;
    private static final int[] RC2CBC_data;
    private static final int[] AES128CBC_data;
    private static final int[] AES192CBC_data;
    private static final int[] AES256CBC_data;
    private static final int[] sha1WithECDSA_data;
    private static final int[] sha224WithECDSA_data;
    private static final int[] sha256WithECDSA_data;
    private static final int[] sha384WithECDSA_data;
    private static final int[] sha512WithECDSA_data;
    private static final int[] specifiedWithECDSA_data;
    private static final int[] ecoid_data;
    public static ObjectIdentifier md2WithRSAEncryption_oid;
    public static ObjectIdentifier md5WithRSAEncryption_oid;
    public static ObjectIdentifier sha1WithRSAEncryption_oid;
    public static ObjectIdentifier sha1WithRSAEncryption_OIW_oid;
    public static ObjectIdentifier sha256WithRSAEncryption_oid;
    public static ObjectIdentifier sha384WithRSAEncryption_oid;
    public static ObjectIdentifier sha512WithRSAEncryption_oid;
    public static ObjectIdentifier shaWithDSA_OIW_oid;
    public static ObjectIdentifier sha1WithDSA_OIW_oid;
    public static ObjectIdentifier sha1WithDSA_oid;
    public static ObjectIdentifier DESCBC_oid;
    public static ObjectIdentifier tripleDESCBC_oid;
    public static ObjectIdentifier RC2CBC_oid;
    public static ObjectIdentifier AES128CBC_oid;
    public static ObjectIdentifier AES192CBC_oid;
    public static ObjectIdentifier AES256CBC_oid;
    public static ObjectIdentifier sha1WithECDSA_oid;
    public static ObjectIdentifier sha224WithECDSA_oid;
    public static ObjectIdentifier sha256WithECDSA_oid;
    public static ObjectIdentifier sha384WithECDSA_oid;
    public static ObjectIdentifier sha512WithECDSA_oid;
    public static ObjectIdentifier specifiedWithECDSA_oid;

    public AlgorithmId(DerValue val) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AlgorithmId", val);
        }
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AlgorithmId", "algid parse error: not a sequence");
            }
            throw new IOException("algid parse error: not a sequence");
        }
        DerInputStream in = val.toDerInputStream();
        this.algid = in.getOID();
        if (in.available() == 0) {
            this.params = null;
        } else {
            this.params = in.getDerValue();
            if (this.params.getTag() == 5) {
                if (this.params.length() != 0) {
                    throw new IOException("invalid NULL");
                }
                this.params = null;
            }
            if (in.available() != 0) {
                throw new IOException("Invalid AlgorithmIdentifier: extra data");
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(DerValue val, String provider) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", val, provider);
        }
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AlgorithmId", "algid parse error: not a sequence");
            }
            throw new IOException("algid parse error: not a sequence");
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        DerInputStream in = val.toDerInputStream();
        this.algid = in.getOID();
        if (in.available() == 0) {
            this.params = null;
        } else {
            this.params = in.getDerValue();
            if (this.params.getTag() == 5) {
                if (this.params.length() != 0) {
                    throw new IOException("invalid NULL");
                }
                this.params = null;
            }
            if (in.available() != 0) {
                throw new IOException("Invalid AlgorithmIdentifier: extra data");
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier oid, byte[] params) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", oid, params);
        }
        this.algid = oid;
        if (params != null && params.length != 0) {
            this.params = new DerValue(params);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier oid, byte[] params, String provider) throws IOException {
        this.provider = null;
        if (debug != null) {
            Object[] parms = new Object[]{oid, params, provider};
            debug.entry(16384L, (Object)className, "AlgorithmId", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.algid = oid;
        if (params != null && params.length != 0) {
            this.params = new DerValue(params);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(String oid, byte[] params) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", oid, params);
        }
        try {
            this.algid = new ObjectIdentifier(oid);
        }
        catch (Exception e2) {
            this.algid = null;
        }
        if (params != null && params.length != 0) {
            this.params = new DerValue(params);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(String oid, byte[] params, String provider) throws IOException {
        this.provider = null;
        if (debug != null) {
            Object[] parms = new Object[]{oid, params, provider};
            debug.entry(16384L, (Object)className, "AlgorithmId", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        try {
            this.algid = new ObjectIdentifier(oid);
        }
        catch (Exception e2) {
            this.algid = null;
        }
        if (params != null && params.length != 0) {
            this.params = new DerValue(params);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier oid, AlgorithmParameters algparams) {
        block4: {
            this.provider = null;
            if (debug != null) {
                debug.entry(16384L, className, "AlgorithmId", oid, algparams);
            }
            this.algid = oid;
            this.algParams = algparams;
            try {
                this.params = this.algParams != null ? new DerValue(this.algParams.getEncoded()) : null;
            }
            catch (Exception e2) {
                this.params = null;
                if (debug == null) break block4;
                debug.exception(16384L, className, "AlgorithmId", e2);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public static AlgorithmId getAlgorithmId(String algname) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAlgorithmId", algname);
            debug.exit(16384L, (Object)className, "getAlgorithmId", AlgorithmId.get(algname));
        }
        return AlgorithmId.get(algname);
    }

    public AlgorithmParameters getAlgParameters() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgParameters");
            debug.exit(16384L, (Object)className, "getAlgParameters", this.algParams);
        }
        return this.algParams;
    }

    public byte[] getParameters() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getParameters");
        }
        if (this.params != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getParameters_1", this.params.toByteArray());
            }
            return this.params.toByteArray();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getParameters_2", null);
        }
        return null;
    }

    public static AlgorithmId get(AlgorithmParameters algparams) throws NoSuchAlgorithmException {
        ObjectIdentifier oid = null;
        String algname = algparams.getAlgorithm();
        oid = AlgorithmId.algOID(algname);
        if (oid == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + algname);
        }
        return new AlgorithmId(oid, algparams);
    }

    public static AlgorithmId get(String algname) throws NoSuchAlgorithmException {
        ObjectIdentifier oid;
        if (debug != null) {
            debug.entry(49152L, (Object)className, "get", algname);
        }
        if ((oid = AlgorithmId.algOID(algname)) == null) {
            if (debug != null) {
                debug.text(49152L, className, "get", "unrecognized algorithm name: " + algname);
            }
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + algname);
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "get", new AlgorithmId(oid));
        }
        return new AlgorithmId(oid);
    }

    public static AlgorithmId get(String algname, String provider) throws NoSuchAlgorithmException {
        ObjectIdentifier oid;
        if (debug != null) {
            debug.entry(49152L, className, "get", algname, provider);
        }
        if ((oid = AlgorithmId.algOID(algname)) == null) {
            if (debug != null) {
                debug.text(49152L, className, "get", "unrecognized algorithm name: " + algname);
            }
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + algname);
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "get", new AlgorithmId(oid, provider));
        }
        return new AlgorithmId(oid, provider);
    }

    public static AlgorithmId parse(DerValue val) throws IOException {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "parse", val);
            debug.exit(49152L, className, "parse");
        }
        return AlgorithmId.parse(val, null);
    }

    public static AlgorithmId parse(DerValue val, String provider) throws IOException {
        DerValue params;
        if (debug != null) {
            debug.entry(49152L, className, "parse", val, provider);
        }
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(49152L, className, "parse", "algid parse error, not a sequence");
            }
            throw new IOException("algid parse error, not a sequence");
        }
        DerInputStream in = val.toDerInputStream();
        ObjectIdentifier algid = in.getOID();
        if (in.available() == 0) {
            params = null;
        } else {
            params = in.getDerValue();
            if (params.getTag() == 5) {
                params = null;
            }
        }
        AlgorithmId alg = new AlgorithmId(algid, params, provider);
        if (params != null) {
            alg.decodeParams();
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "parse", alg);
        }
        return alg;
    }

    public AlgorithmId(ObjectIdentifier oid) {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AlgorithmId", oid);
        }
        this.algid = oid;
        this.algParams = null;
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier oid, String provider) {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", oid, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.algid = oid;
        this.algParams = null;
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    private AlgorithmId(ObjectIdentifier oid, DerValue params) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", oid, params);
        }
        this.algid = oid;
        this.params = params;
        if (this.params != null) {
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    private AlgorithmId(ObjectIdentifier oid, DerValue params, String provider) throws IOException {
        this.provider = null;
        if (debug != null) {
            Object[] parms = new Object[]{oid, params, provider};
            debug.entry(16384L, (Object)className, "AlgorithmId", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.algid = oid;
        this.params = params;
        if (this.params != null) {
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    protected void decodeParams() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "decodeParams");
        }
        if (this.params == null) {
            this.algParams = null;
            if (debug != null) {
                debug.exit(16384L, className, "decodeParams_1");
            }
            return;
        }
        try {
            this.algParams = this.provider != null ? AlgorithmParameters.getInstance(this.algid.toString(), this.provider) : AlgorithmParameters.getInstance(this.algid.toString());
        }
        catch (NoSuchAlgorithmException e2) {
            if (debug != null) {
                debug.text(16384L, className, "decodeParams_1", e2.toString());
            }
            try {
                this.algParams = this.provider != null ? AlgorithmParameters.getInstance(this.algName(), this.provider) : AlgorithmParameters.getInstance(this.algName());
            }
            catch (NoSuchAlgorithmException e22) {
                if (debug != null) {
                    debug.text(16384L, className, "decodeParams_2", e22.toString());
                    debug.exit(16384L, className, "decodeParams_2");
                }
                try {
                    if (debug != null) {
                        debug.text(16384L, className, "decodeParams_2", " try EC internal provider get algid" + this.algid.toString());
                    }
                    this.algParams = AlgorithmParameters.getInstance(this.algid.toString(), ECKeyFactory.ecInternalProvider);
                    if (debug != null) {
                        debug.text(16384L, className, "decodeParams_2", "get algParams = " + this.algParams);
                    }
                }
                catch (Exception ei) {
                    this.algParams = null;
                    return;
                }
            }
            catch (NoSuchProviderException nspe) {
                if (debug != null) {
                    debug.text(16384L, className, "decodeParams_3", nspe.toString());
                    debug.exit(16384L, className, "decodeParams_3");
                }
                this.algParams = null;
                return;
            }
        }
        catch (NoSuchProviderException nspe2) {
            if (debug != null) {
                debug.text(16384L, className, "decodeParams_4", nspe2.toString());
                debug.exit(16384L, className, "decodeParams_4");
            }
            this.algParams = null;
            return;
        }
        this.algParams.init(this.params.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "decodeParams_5");
        }
    }

    public final void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        this.derEncode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", out);
        }
        bytes.putOID(this.algid);
        if (this.params == null && this.algParams != null) {
            this.params = new DerValue(this.algParams.getEncoded());
        }
        if (this.params == null) {
            bytes.putNull();
        } else {
            bytes.putDerValue(this.params);
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public final byte[] encode() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "encode");
        }
        bytes.putOID(this.algid);
        if (this.params == null) {
            bytes.putNull();
        } else {
            bytes.putDerValue(this.params);
        }
        out.write((byte)48, bytes);
        byte[] retval = out.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encode", retval);
        }
        return retval;
    }

    private static ObjectIdentifier algOID(String name) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "algOID", name);
        }
        if (name.indexOf(46) != -1) {
            if (name.startsWith("OID.")) {
                ObjectIdentifier an_oid = null;
                try {
                    an_oid = new ObjectIdentifier(name.substring("OID.".length()));
                }
                catch (Exception e2) {
                    an_oid = null;
                }
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "algOID_1", an_oid);
                }
                return an_oid;
            }
            ObjectIdentifier an_oid = null;
            try {
                an_oid = new ObjectIdentifier(name);
            }
            catch (Exception e3) {
                an_oid = null;
            }
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_2", an_oid);
            }
            return an_oid;
        }
        if (name.equalsIgnoreCase("DES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_3", DESCBC_oid);
            }
            return DESCBC_oid;
        }
        if (name.equalsIgnoreCase("tripleDES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_4", tripleDESCBC_oid);
            }
            return tripleDESCBC_oid;
        }
        if (name.equalsIgnoreCase("3DES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_5", tripleDESCBC_oid);
            }
            return tripleDESCBC_oid;
        }
        if (name.equalsIgnoreCase("DESede")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_6", tripleDESCBC_oid);
            }
            return tripleDESCBC_oid;
        }
        if (name.equalsIgnoreCase("RC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_7", RC2CBC_oid);
            }
            return RC2CBC_oid;
        }
        if (name.equalsIgnoreCase("PBEWithMD2AndDES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_8", PKCSOID.PBEWITHMD2ANDDES_CBC_OID);
            }
            return PKCSOID.PBEWITHMD2ANDDES_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithMD2AndRC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_9", PKCSOID.PBEWITHMD2ANDRC2_CBC_OID);
            }
            return PKCSOID.PBEWITHMD2ANDRC2_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithMD5AndDES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_10", PKCSOID.PBEWITHMD5ANDDES_CBC_OID);
            }
            return PKCSOID.PBEWITHMD5ANDDES_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithMD5AndRC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_11", PKCSOID.PBEWITHMD5ANDRC2_CBC_OID);
            }
            return PKCSOID.PBEWITHMD5ANDRC2_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHA1AndDES") || name.equalsIgnoreCase("PBEWithSHAAndDES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_12", PKCSOID.PBEWITHSHA1ANDDES_CBC_OID);
            }
            return PKCSOID.PBEWITHSHA1ANDDES_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHA1AndRC2") || name.equalsIgnoreCase("PBEWithSHAAndRC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_13", PKCSOID.PBEWITHSHA1ANDRC2_CBC_OID);
            }
            return PKCSOID.PBEWITHSHA1ANDRC2_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd40BitRC4") || name.equalsIgnoreCase("PBEWithSHA1And40BitRC4") || name.equalsIgnoreCase("PBEWithSHA-1And40BitRC4")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_14", PKCSOID.PBEWITHSHAAND40BITRC4_OID);
            }
            return PKCSOID.PBEWITHSHAAND40BITRC4_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd128BitRC4") || name.equalsIgnoreCase("PBEWithSHA1And128BitRC4") || name.equalsIgnoreCase("PBEWithSHA-1And128BitRC4")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_15", PKCSOID.PBEWITHSHAAND128BITRC4_OID);
            }
            return PKCSOID.PBEWITHSHAAND128BITRC4_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd3KeyTripleDes") || name.equalsIgnoreCase("PBEWithSHA1And3KeyTripleDes") || name.equalsIgnoreCase("PBEWithSHA-1And3KeyTripleDes")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_16", PKCSOID.PBEWITHSHAAND3KEYTRIPLEDESCBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND3KEYTRIPLEDESCBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd2KeyTripleDes") || name.equalsIgnoreCase("PBEWithSHA1And2KeyTripleDes") || name.equalsIgnoreCase("PBEWithSHA-1And2KeyTripleDes")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_17", PKCSOID.PBEWITHSHAAND2KEYTRIPLEDESCBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND2KEYTRIPLEDESCBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd40BitRC2") || name.equalsIgnoreCase("PBEWithSHA1And40BitRC2") || name.equalsIgnoreCase("PBEWithSHA-1And40BitRC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_18", PKCSOID.PBEWITHSHAAND40BITRC2CBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND40BITRC2CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd128BitRC2") || name.equalsIgnoreCase("PBEWithSHA1And128BitRC2") || name.equalsIgnoreCase("PBEWithSHA-1And128BitRC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_19", PKCSOID.PBEWITHSHAAND128BITRC2CBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND128BITRC2CBC_OID;
        }
        if (name.equalsIgnoreCase("MD5")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_20", MD5_oid);
            }
            return MD5_oid;
        }
        if (name.equalsIgnoreCase("MD2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_21", MD2_oid);
            }
            return MD2_oid;
        }
        if (name.equalsIgnoreCase("SHA") || name.equalsIgnoreCase("SHA1") || name.equalsIgnoreCase("SHA-1")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_22", SHA_oid);
            }
            return SHA_oid;
        }
        if (name.equalsIgnoreCase("SHA-256") || name.equalsIgnoreCase("SHA256")) {
            return SHA256_oid;
        }
        if (name.equalsIgnoreCase("SHA-384") || name.equalsIgnoreCase("SHA384")) {
            return SHA384_oid;
        }
        if (name.equalsIgnoreCase("SHA-512") || name.equalsIgnoreCase("SHA512")) {
            return SHA512_oid;
        }
        if (name.equalsIgnoreCase("RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_23", RSAEncryption_oid);
            }
            return RSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("Diffie-Hellman") || name.equalsIgnoreCase("DH")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_24", DH_oid);
            }
            return DH_oid;
        }
        if (name.equalsIgnoreCase("DSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_25", DSA_oid);
            }
            return DSA_oid;
        }
        if (name.equalsIgnoreCase("EC")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_36", EC_oid);
            }
            return EC_oid;
        }
        if (name.equalsIgnoreCase("MD5withRSA") || name.equalsIgnoreCase("MD5/RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_26", md5WithRSAEncryption_oid);
            }
            return md5WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("MD2withRSA") || name.equalsIgnoreCase("MD2/RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_27", md2WithRSAEncryption_oid);
            }
            return md2WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHAwithDSA") || name.equalsIgnoreCase("SHA1withDSA") || name.equalsIgnoreCase("SHA/DSA") || name.equalsIgnoreCase("SHA1/DSA") || name.equalsIgnoreCase("DSAWithSHA1")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_28", sha1WithDSA_oid);
            }
            return sha1WithDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA1WithRSA") || name.equalsIgnoreCase("SHA1/RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_29", sha1WithRSAEncryption_oid);
            }
            return sha1WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHA256WithRSA") || name.equalsIgnoreCase("SHA256/RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_43", sha256WithRSAEncryption_oid);
            }
            return sha256WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHA384WithRSA") || name.equalsIgnoreCase("SHA384/RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_44", sha384WithRSAEncryption_oid);
            }
            return sha384WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHA512WithRSA") || name.equalsIgnoreCase("SHA512/RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_45", sha512WithRSAEncryption_oid);
            }
            return sha512WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHAWithRSA") || name.equalsIgnoreCase("SHA/RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_30", sha1WithRSAEncryption_oid);
            }
            return sha1WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHA1withECDSA") || name.equalsIgnoreCase("ECDSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_37", sha1WithECDSA_oid);
            }
            return sha1WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA224withECDSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_38", sha224WithECDSA_oid);
            }
            return sha224WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA256withECDSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_39", sha256WithECDSA_oid);
            }
            return sha256WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA384withECDSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_40", sha384WithECDSA_oid);
            }
            return sha384WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA512withECDSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_41", sha512WithECDSA_oid);
            }
            return sha512WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("DatawithECDSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_42", specifiedWithECDSA_oid);
            }
            return specifiedWithECDSA_oid;
        }
        if (name.equalsIgnoreCase("HmacSHA1") || name.equalsIgnoreCase("HmacSHA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_31", HmacSHA1_oid);
            }
            return HmacSHA1_oid;
        }
        if (name.equalsIgnoreCase("PBM") || name.equalsIgnoreCase("PasswordBasedMac")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_32", PasswordBasedMac_oid);
            }
            return PasswordBasedMac_oid;
        }
        if (name.equalsIgnoreCase("AES128")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_33", AES128CBC_oid);
            }
            return AES128CBC_oid;
        }
        if (name.equalsIgnoreCase("AES192")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_34", AES192CBC_oid);
            }
            return AES192CBC_oid;
        }
        if (name.equalsIgnoreCase("AES256")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_35", AES256CBC_oid);
            }
            return AES256CBC_oid;
        }
        if (!initOidTable) {
            Provider[] provs = Security.getProviders();
            block6: for (int i2 = 0; i2 < provs.length; ++i2) {
                Enumeration<Object> enumCount = provs[i2].keys();
                while (enumCount.hasMoreElements()) {
                    int index;
                    String alias = (String)enumCount.nextElement();
                    if (!alias.toUpperCase(Locale.US).startsWith("ALG.ALIAS") || (index = alias.toUpperCase(Locale.US).indexOf("OID.", 0)) == -1) continue;
                    if ((index += "OID.".length()) == alias.length()) continue block6;
                    if (oidTable == null) {
                        oidTable = new HashMap<String, ObjectIdentifier>(11);
                    }
                    String oidString = alias.substring(index);
                    String stdAlgName = provs[i2].getProperty(alias).toUpperCase(Locale.US);
                    if (oidTable.get(stdAlgName) != null) continue;
                    try {
                        oidTable.put(stdAlgName, new ObjectIdentifier(oidString));
                    }
                    catch (Exception e4) {
                        oidTable.put(stdAlgName, null);
                    }
                }
            }
            initOidTable = true;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "algOID_33", oidTable.get(name.toUpperCase(Locale.US)));
        }
        return oidTable.get(name.toUpperCase(Locale.US));
    }

    private String algName() {
        if (debug != null) {
            debug.entry(8192L, className, "algName");
        }
        if (this.algid.equals(DESCBC_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_1", "DES");
            }
            return "DES";
        }
        if (this.algid.equals(tripleDESCBC_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_2", "DESede");
            }
            return "DESede";
        }
        if (this.algid.equals(RC2CBC_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_3", "RC2");
            }
            return "RC2";
        }
        if (this.algid.equals(MD5_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_4", "MD5");
            }
            return "MD5";
        }
        if (this.algid.equals(MD2_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_5", "MD2");
            }
            return "MD2";
        }
        if (this.algid.equals(SHA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_6", "SHA");
            }
            return "SHA";
        }
        if (this.algid.equals(SHA256_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_46", "SHA-256");
            }
            return "SHA-256";
        }
        if (this.algid.equals(SHA384_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_47", "SHA-384");
            }
            return "SHA-384";
        }
        if (this.algid.equals(SHA512_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_48", "SHA-512");
            }
            return "SHA-512";
        }
        if (this.algid.equals(RSAEncryption_oid) || this.algid.equals(RSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_7", "RSA");
            }
            return "RSA";
        }
        if (this.algid.equals(DH_oid) || this.algid.equals(DH_PKIX_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_8", "Diffie-Hellman");
            }
            return "Diffie-Hellman";
        }
        if (this.algid.equals(DSA_oid) || this.algid.equals(DSA_OIW_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_9", "DSA");
            }
            return "DSA";
        }
        if (this.algid.equals(EC_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_36", "EC");
            }
            return "EC";
        }
        if (this.algid.equals(md5WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_10", "MD5withRSA");
            }
            return "MD5withRSA";
        }
        if (this.algid.equals(md2WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_11", "MD2withRSA");
            }
            return "MD2withRSA";
        }
        if (this.algid.equals(sha1WithDSA_oid) || this.algid.equals(sha1WithDSA_OIW_oid) || this.algid.equals(shaWithDSA_OIW_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_12", "SHA1withDSA");
            }
            return "SHA1withDSA";
        }
        if (this.algid.equals(sha1WithRSAEncryption_oid) || this.algid.equals(sha1WithRSAEncryption_OIW_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_13", "SHA1withRSA");
            }
            return "SHA1withRSA";
        }
        if (this.algid.equals(sha256WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_43", "SHA256withRSA");
            }
            return "SHA256withRSA";
        }
        if (this.algid.equals(sha384WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_44", "SHA384withRSA");
            }
            return "SHA384withRSA";
        }
        if (this.algid.equals(sha512WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_45", "SHA512withRSA");
            }
            return "SHA512withRSA";
        }
        if (this.algid.equals(sha1WithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_37", "SHA1withECDSA");
            }
            return "SHA1withECDSA";
        }
        if (this.algid.equals(sha224WithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_38", "SHA224withECDSA");
            }
            return "SHA224withECDSA";
        }
        if (this.algid.equals(sha256WithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_39", "SHA256withECDSA");
            }
            return "SHA256withECDSA";
        }
        if (this.algid.equals(sha384WithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_40", "SHA384withECDSA");
            }
            return "SHA384withECDSA";
        }
        if (this.algid.equals(sha512WithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_41", "SHA512withECDSA");
            }
            return "SHA512withECDSA";
        }
        if (this.algid.equals(specifiedWithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_42", "SpecifiedwithECDSA");
            }
            return "DatawithECDSA";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD2ANDDES_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_14", "PBEWithMD2AndDES");
            }
            return "PBEWithMD2AndDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD2ANDRC2_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_15", "PBEWithMD2AndRC2");
            }
            return "PBEWithMD2AndRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD5ANDDES_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_16", "PBEWithMD5AndDES");
            }
            return "PBEWithMD5AndDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD5ANDRC2_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_17", "PBEWithMD5AndRC2");
            }
            return "PBEWithMD5AndRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAANDDES_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_18", "PBEWithSHAAndDES");
            }
            return "PBEWithSHAAndDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAANDRC2_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_19", "PBEWithSHAAndRC2");
            }
            return "PBEWithSHAAndRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND40BITRC4_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_20", "PBEWithSHAAnd40BitRC4");
            }
            return "PBEWithSHAAnd40BitRC4";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND128BITRC4_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_21", "PBEWithSHAAnd128BitRC4");
            }
            return "PBEWithSHAAnd128BitRC4";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND3KEYTRIPLEDESCBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_22", "PBEWithSHAAnd3KeyTripleDES");
            }
            return "PBEWithSHAAnd3KeyTripleDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND2KEYTRIPLEDESCBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_23", "PBEWithSHAAnd2KeyTripleDES");
            }
            return "PBEWithSHAAnd2KeyTripleDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND40BITRC2CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_24", "PBEWithSHAAnd40BitRC2");
            }
            return "PBEWithSHAAnd40BitRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND128BITRC2CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_25", "PBEWithSHAAnd128BitRC2");
            }
            return "PBEWithSHAAnd128BitRC2";
        }
        if (this.algid.equals(HmacSHA1_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_26", "HmacSHA1");
            }
            return "HmacSHA1";
        }
        if (this.algid.equals(PasswordBasedMac_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_27", "PasswordBasedMac");
            }
            return "PasswordBasedMac";
        }
        if (this.algid.equals(AES128CBC_oid) && debug != null) {
            debug.exit(8192L, (Object)className, "algName_28", "AES128");
        }
        if (this.algid.equals(AES192CBC_oid) && debug != null) {
            debug.exit(8192L, (Object)className, "algName_29", "AES192");
        }
        if (this.algid.equals(AES256CBC_oid) && debug != null) {
            debug.exit(8192L, (Object)className, "algName_30", "AES256");
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "algName_28", this.algid.toString());
        }
        return this.algid.toString();
    }

    public final ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.algid);
        }
        return this.algid;
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", this.algName());
        }
        return this.algName();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", this.algName() + this.paramsToString());
        }
        return this.algName() + this.paramsToString();
    }

    public byte[] getEncodedParams() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedParams");
        }
        if (this.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedParams_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncodedParams_2", this.params.toByteArray());
        }
        return this.params.toByteArray();
    }

    protected String paramsToString() {
        if (debug != null) {
            debug.entry(16384L, className, "paramsToString");
        }
        if (this.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "paramsToString_1", "");
            }
            return "";
        }
        if (this.algParams != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "paramsToString_2", this.algParams.toString());
            }
            return this.algParams.toString();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "paramsToString_3", ", params unparsed");
        }
        return ", params unparsed";
    }

    public boolean equals(AlgorithmId other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (!this.algid.equals(other.algid)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (this.params == null && other.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        if (this.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", this.params.equals(other.params));
        }
        return this.params.equals(other.params);
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other instanceof AlgorithmId) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((AlgorithmId)other));
            }
            return this.equals((AlgorithmId)other);
        }
        if (other instanceof ObjectIdentifier) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", this.equals((ObjectIdentifier)other));
            }
            return this.equals((ObjectIdentifier)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_3", false);
        }
        return false;
    }

    public final boolean equals(ObjectIdentifier id) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", id);
            debug.exit(16384L, (Object)className, "equals", this.algid.equals(id));
        }
        return this.algid.equals(id);
    }

    public int hashCode() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(this.algid.toString());
        sbuf.append(this.paramsToString());
        return sbuf.toString().hashCode();
    }

    static {
        debug = Debug.getInstance("ibmpkcs");
        className = "com.ibm.security.x509.AlgorithmId";
        MD2_data = new int[]{1, 2, 840, 113549, 2, 2};
        MD5_data = new int[]{1, 2, 840, 113549, 2, 5};
        SHA1_OIW_data = new int[]{1, 3, 14, 3, 2, 26};
        SHA256_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 1};
        SHA384_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 2};
        SHA512_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 3};
        HmacSHA1_data = new int[]{1, 3, 6, 1, 5, 5, 8, 1, 2};
        PasswordBasedMac_data = new int[]{1, 2, 840, 113533, 7, 66, 13};
        DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
        DH_PKIX_data = new int[]{1, 2, 840, 10046, 2, 1};
        DSA_OIW_data = new int[]{1, 3, 14, 3, 2, 12};
        DSA_PKIX_data = new int[]{1, 2, 840, 10040, 4, 1};
        RSA_data = new int[]{1, 2, 5, 8, 1, 1};
        RSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 1};
        md2WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 2};
        md5WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 4};
        sha1WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 5};
        sha1WithRSAEncryption_OIW_data = new int[]{1, 3, 14, 3, 2, 29};
        sha256WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 11};
        sha384WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 12};
        sha512WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 13};
        shaWithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 13};
        sha1WithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 27};
        dsaWithSHA1_PKIX_data = new int[]{1, 2, 840, 10040, 4, 3};
        DESCBC_data = new int[]{1, 3, 14, 3, 2, 7};
        tripleDESCBC_data = new int[]{1, 2, 840, 113549, 3, 7};
        RC2CBC_data = new int[]{1, 2, 840, 113549, 3, 2};
        AES128CBC_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 2};
        AES192CBC_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 22};
        AES256CBC_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 42};
        sha1WithECDSA_data = new int[]{1, 2, 840, 10045, 4, 1};
        sha224WithECDSA_data = new int[]{1, 2, 840, 10045, 4, 3, 1};
        sha256WithECDSA_data = new int[]{1, 2, 840, 10045, 4, 3, 2};
        sha384WithECDSA_data = new int[]{1, 2, 840, 10045, 4, 3, 3};
        sha512WithECDSA_data = new int[]{1, 2, 840, 10045, 4, 3, 4};
        specifiedWithECDSA_data = new int[]{1, 2, 840, 10045, 4, 3};
        ecoid_data = new int[]{1, 2, 840, 10045, 2, 1};
        try {
            MD2_oid = new ObjectIdentifier(MD2_data);
            MD5_oid = new ObjectIdentifier(MD5_data);
            SHA_oid = new ObjectIdentifier(SHA1_OIW_data);
            SHA256_oid = new ObjectIdentifier(SHA256_data);
            SHA384_oid = new ObjectIdentifier(SHA384_data);
            SHA512_oid = new ObjectIdentifier(SHA512_data);
            HmacSHA1_oid = new ObjectIdentifier(HmacSHA1_data);
            PasswordBasedMac_oid = new ObjectIdentifier(PasswordBasedMac_data);
            DH_oid = new ObjectIdentifier(DH_data);
            DH_PKIX_oid = new ObjectIdentifier(DH_PKIX_data);
            DSA_OIW_oid = new ObjectIdentifier(DSA_OIW_data);
            DSA_oid = new ObjectIdentifier(DSA_PKIX_data);
            RSA_oid = new ObjectIdentifier(RSA_data);
            RSAEncryption_oid = new ObjectIdentifier(RSAEncryption_data);
            md2WithRSAEncryption_oid = new ObjectIdentifier(md2WithRSAEncryption_data);
            md5WithRSAEncryption_oid = new ObjectIdentifier(md5WithRSAEncryption_data);
            sha1WithRSAEncryption_oid = new ObjectIdentifier(sha1WithRSAEncryption_data);
            sha1WithRSAEncryption_OIW_oid = new ObjectIdentifier(sha1WithRSAEncryption_OIW_data);
            sha256WithRSAEncryption_oid = new ObjectIdentifier(sha256WithRSAEncryption_data);
            sha384WithRSAEncryption_oid = new ObjectIdentifier(sha384WithRSAEncryption_data);
            sha512WithRSAEncryption_oid = new ObjectIdentifier(sha512WithRSAEncryption_data);
            shaWithDSA_OIW_oid = new ObjectIdentifier(shaWithDSA_OIW_data);
            sha1WithDSA_OIW_oid = new ObjectIdentifier(sha1WithDSA_OIW_data);
            sha1WithDSA_oid = new ObjectIdentifier(dsaWithSHA1_PKIX_data);
            DESCBC_oid = new ObjectIdentifier(DESCBC_data);
            tripleDESCBC_oid = new ObjectIdentifier(tripleDESCBC_data);
            RC2CBC_oid = new ObjectIdentifier(RC2CBC_data);
            AES128CBC_oid = new ObjectIdentifier(AES128CBC_data);
            AES192CBC_oid = new ObjectIdentifier(AES192CBC_data);
            AES256CBC_oid = new ObjectIdentifier(AES256CBC_data);
            sha1WithECDSA_oid = new ObjectIdentifier(sha1WithECDSA_data);
            sha224WithECDSA_oid = new ObjectIdentifier(sha224WithECDSA_data);
            sha256WithECDSA_oid = new ObjectIdentifier(sha256WithECDSA_data);
            sha384WithECDSA_oid = new ObjectIdentifier(sha384WithECDSA_data);
            sha512WithECDSA_oid = new ObjectIdentifier(sha512WithECDSA_data);
            specifiedWithECDSA_oid = new ObjectIdentifier(specifiedWithECDSA_data);
            EC_oid = new ObjectIdentifier(ecoid_data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

