/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CMP;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class OrigPKIMessageInfoValue
extends CMPDerObject
implements InfoValue,
Cloneable {
    private static final ObjectIdentifier oid = CMP.orig_pkimessage_oid;
    private PKIMessage value;
    private byte[] encodedValue;

    public OrigPKIMessageInfoValue(PKIMessage pKIMessage) throws IOException {
        if (pKIMessage == null) {
            throw new IllegalArgumentException("OrigPKIMessageInfoValue error, msg not specified");
        }
        this.value = (PKIMessage)pKIMessage.clone();
        this.setEncodedValue();
    }

    public OrigPKIMessageInfoValue(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            return new OrigPKIMessageInfoValue(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        try {
            this.value = new PKIMessage(derValue.toByteArray());
            this.setEncodedValue();
        }
        catch (Exception exception) {
            throw new IOException("OrigPKIMessageInfoValue decoding error, " + exception.toString());
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encodedValue);
    }

    public boolean equals(OrigPKIMessageInfoValue origPKIMessageInfoValue) {
        DerValue derValue;
        DerValue derValue2;
        if (origPKIMessageInfoValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            origPKIMessageInfoValue.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof OrigPKIMessageInfoValue) {
            return this.equals((OrigPKIMessageInfoValue)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return (byte[])this.encodedValue.clone();
    }

    public String getName() {
        return "OrigPKIMessage";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        try {
            return new PKIMessage(this.encodedValue);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void setEncodedValue() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.value.encode(derOutputStream);
        this.encodedValue = derOutputStream.toByteArray();
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "OrigPKIMessageInfoValue:";
        string = String.valueOf(string) + "\r\nobject identifier: " + oid;
        string = String.valueOf(string) + "\r\npki message:\r\n";
        string = String.valueOf(string) + this.value.toString();
        return string;
    }
}

