/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.beans;

import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkRepEvent;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.util.PkPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import javax.net.SocketFactory;

public class PkTcpClient
extends PkPipe {
    private final String host;
    private final int port;
    private final PkEventFormatter eventFormatter;
    private final SocketFactory socketFactory;
    private int numConns;
    private PkPool conns;
    private int numberOfConnectionsActuallyPushed;

    public PkTcpClient(String host, int port, PkEventFormatter eventFormatter, int numConns) throws PkException {
        this.host = host;
        this.port = port;
        this.eventFormatter = eventFormatter;
        this.numConns = numConns;
        this.numberOfConnectionsActuallyPushed = 0;
        if (this.numConns <= 0) {
            PkException myE = new PkException(PkNLSConstants.NUMBER_OF_CONNS_INVALID);
            throw myE;
        }
        this.socketFactory = SocketFactory.getDefault();
        this.conns = new PkPool();
        this.connect();
    }

    public PkTcpClient(String host, int port, PkEventFormatter eventFormatter, int numConns, SocketFactory socketFactory) throws PkException {
        this.host = host;
        this.port = port;
        this.eventFormatter = eventFormatter;
        this.numConns = numConns;
        this.numberOfConnectionsActuallyPushed = 0;
        if (this.numConns <= 0) {
            PkException myE = new PkException(PkNLSConstants.NUMBER_OF_CONNS_INVALID);
            throw myE;
        }
        this.socketFactory = socketFactory;
        this.conns = new PkPool();
        this.connect();
    }

    public void finalize() throws PkException {
        this.close();
    }

    public synchronized void close() throws PkException {
        while (this.numberOfConnectionsActuallyPushed > 0) {
            TcpConn c2 = (TcpConn)this.conns.pop();
            try {
                c2.out.close();
                c2.in.close();
                c2.socket.close();
            }
            catch (IOException e2) {
                throw new PkException(PkNLSConstants.TCPCLIENT_FAILED_CONNECTION_TO_HOST + this.host + ":" + this.port, e2);
            }
            finally {
                --this.numberOfConnectionsActuallyPushed;
            }
        }
    }

    @Override
    public synchronized PkRepEvent doReq(PkReqEvent req) throws PkException {
        TcpConn conn = (TcpConn)this.conns.pop();
        --this.numberOfConnectionsActuallyPushed;
        try {
            try {
                req.write(this.eventFormatter, conn.out);
                conn.out.flush();
            }
            catch (IOException e2) {
                this.connect();
                try {
                    req.write(this.eventFormatter, conn.out);
                    conn.out.flush();
                }
                catch (IOException e22) {
                    throw new PkException(PkNLSConstants.TCPCLIENT_ERROR_SENDING_REQUEST, e22);
                }
            }
            try {
                PkRepEvent myPkRepEvent;
                PkRepEvent pkRepEvent = myPkRepEvent = (PkRepEvent)this.eventFormatter.readEvent(this, conn.in, req);
                return pkRepEvent;
            }
            catch (IOException e3) {
                this.connect();
                throw new PkException(PkNLSConstants.TCPCLIENT_ERROR_RECEIVING_REPLY, e3);
            }
        }
        finally {
            this.conns.push(conn);
            ++this.numberOfConnectionsActuallyPushed;
        }
    }

    private synchronized void connect() throws PkException {
        long maxWait = new Date().getTime() + 60000L;
        boolean connectFail = true;
        if (this.numConns <= 0) {
            PkException myE = new PkException(PkNLSConstants.NUMBER_OF_CONNS_INVALID);
            throw myE;
        }
        for (int i2 = 0; i2 < this.numConns; ++i2) {
            while (connectFail) {
                try {
                    TcpConn c2 = new TcpConn();
                    c2.socket = this.socketFactory.createSocket(this.host, this.port);
                    c2.in = new BufferedInputStream(c2.socket.getInputStream());
                    c2.out = new BufferedOutputStream(c2.socket.getOutputStream());
                    this.conns.push(c2);
                    ++this.numberOfConnectionsActuallyPushed;
                    connectFail = false;
                }
                catch (IOException e2) {
                    if (new Date().getTime() < maxWait) {
                        try {
                            this.wait(2000L);
                        }
                        catch (InterruptedException ee) {}
                        continue;
                    }
                    throw new PkException(PkNLSConstants.TCPCLIENT_FAILED_CONNECTION_TO_HOST + this.host + ":" + this.port, e2);
                }
            }
        }
    }

    private final class TcpConn {
        private Socket socket;
        private InputStream in;
        private OutputStream out;

        private TcpConn() {
        }
    }
}

