/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPrivateKey;
import com.ibm.crypto.provider.RSAPublicKey;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;

public final class RSAKeyFactory
extends KeyFactorySpi {
    public static final int MIN_MODLEN = 512;
    public static final int MAX_MODLEN = 16384;
    public static final int MAX_MODLEN_RESTRICT_EXP = 3072;
    public static final int MAX_RESTRICTED_EXPLEN = 64;
    private static final boolean a;
    private static String[] z;

    public static void checkKeyLengths(int n2, BigInteger bigInteger, int n3, int n4) throws InvalidKeyException {
        if (n3 > 0 && n2 < n3) {
            throw new InvalidKeyException(z[10] + n3 + z[9]);
        }
        int n5 = Math.min(n4, 16384);
        if (n2 > n5) {
            throw new InvalidKeyException(z[13] + n5 + z[12]);
        }
        if (a && bigInteger != null && n2 > 3072 && bigInteger.bitLength() > 64) {
            throw new InvalidKeyException(z[11]);
        }
    }

    static void a(int n2, BigInteger bigInteger) throws InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n2 + 7 & 0xFFFFFFF8, bigInteger, 512, Integer.MAX_VALUE);
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException(z[1]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[8] + invalidKeyException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return new RSAPrivateCrtKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
                catch (InvalidKeyException invalidKeyException) {
                    return new RSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
            }
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                return new RSAPrivateCrtKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
                return new RSAPrivateKey(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
            }
            throw new InvalidKeySpecException(z[1]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[8] + invalidKeyException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                Class<?> clazz2 = Class.forName(z[6]);
                Class<?> clazz3 = Class.forName(z[4]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                    return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                Class<?> clazz4 = Class.forName(z[2]);
                Class<?> clazz5 = Class.forName(z[0]);
                if (clazz4.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
                    return new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                Class<?> clazz6 = Class.forName(z[7]);
                Class<?> clazz7 = Class.forName(z[0]);
                if (clazz6.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
                }
                if (clazz7.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            throw new InvalidKeySpecException(z[5]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(z[3] + classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                if (key instanceof RSAPublicKey) {
                    return key;
                }
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)this.engineGetKeySpec(key, RSAPublicKeySpec.class);
                return this.engineGeneratePublic(rSAPublicKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                if (key instanceof RSAPrivateCrtKey) {
                    return key;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, RSAPrivateCrtKeySpec.class);
                return this.engineGeneratePrivate(rSAPrivateKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                if (key instanceof RSAPrivateKey) {
                    return key;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, RSAPrivateKeySpec.class);
                return this.engineGeneratePrivate(rSAPrivateKeySpec);
            }
            throw new InvalidKeyException(z[14]);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(z[15] + invalidKeySpecException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block179: {
            int n2;
            int n3;
            block178: {
                char[] cArray2;
                Object var0;
                block177: {
                    int n4;
                    block176: {
                        char[] cArray3;
                        block175: {
                            int n5;
                            block174: {
                                char[] cArray4;
                                block173: {
                                    int n6;
                                    block172: {
                                        char[] cArray5;
                                        block171: {
                                            int n7;
                                            block170: {
                                                char[] cArray6;
                                                block169: {
                                                    int n8;
                                                    block168: {
                                                        char[] cArray7;
                                                        block167: {
                                                            int n9;
                                                            block166: {
                                                                char[] cArray8;
                                                                block165: {
                                                                    int n10;
                                                                    block164: {
                                                                        char[] cArray9;
                                                                        block163: {
                                                                            int n11;
                                                                            block162: {
                                                                                char[] cArray10;
                                                                                block161: {
                                                                                    int n12;
                                                                                    block160: {
                                                                                        char[] cArray11;
                                                                                        block159: {
                                                                                            int n13;
                                                                                            block158: {
                                                                                                char[] cArray12;
                                                                                                block157: {
                                                                                                    int n14;
                                                                                                    block156: {
                                                                                                        char[] cArray13;
                                                                                                        block155: {
                                                                                                            int n15;
                                                                                                            block154: {
                                                                                                                char[] cArray14;
                                                                                                                block153: {
                                                                                                                    int n16;
                                                                                                                    block152: {
                                                                                                                        char[] cArray15;
                                                                                                                        block151: {
                                                                                                                            int n17;
                                                                                                                            block150: {
                                                                                                                                char[] cArray16;
                                                                                                                                block149: {
                                                                                                                                    int n18;
                                                                                                                                    block148: {
                                                                                                                                        char[] cArray17;
                                                                                                                                        block147: {
                                                                                                                                            int n19;
                                                                                                                                            block146: {
                                                                                                                                                char[] cArray18;
                                                                                                                                                block145: {
                                                                                                                                                    int n20;
                                                                                                                                                    block144: {
                                                                                                                                                        stringArray = new String[18];
                                                                                                                                                        var0 = null;
                                                                                                                                                        char[] cArray19 = "K\u001b{\u00166R\u001fn\u0002jH\u000etYkQ\u001fnYHj9^O]O\u0019b\u0013}E1h\u000eKQ\u001fn".toCharArray();
                                                                                                                                                        cArray18 = cArray19;
                                                                                                                                                        n20 = cArray19.length;
                                                                                                                                                        n3 = 0;
                                                                                                                                                        if (!true) break block144;
                                                                                                                                                        n20 = n20;
                                                                                                                                                        if (n20 <= n3) break block145;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        int n21;
                                                                                                                                                        cArray18 = cArray18;
                                                                                                                                                        int n22 = n3;
                                                                                                                                                        char c2 = cArray18[n22];
                                                                                                                                                        switch (n3 % 5) {
                                                                                                                                                            case 0: {
                                                                                                                                                                n21 = 33;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 1: {
                                                                                                                                                                n21 = 122;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 2: {
                                                                                                                                                                n21 = 13;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 3: {
                                                                                                                                                                n21 = 119;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            default: {
                                                                                                                                                                n21 = 24;
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                        cArray18[n22] = (char)(c2 ^ n21);
                                                                                                                                                        ++n3;
                                                                                                                                                        n20 = n20;
                                                                                                                                                    } while (n20 > n3);
                                                                                                                                                }
                                                                                                                                                stringArray[0] = new String(cArray18).intern();
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray20 = "h\u0014l\u0007hS\u0015}\u0005q@\u000ehWsD\u0003-\u0004hD\u0019d\u0011qB\u001by\u001ewO".toCharArray();
                                                                                                                                                cArray17 = cArray20;
                                                                                                                                                n19 = cArray20.length;
                                                                                                                                                n3 = 0;
                                                                                                                                                if (!true) break block146;
                                                                                                                                                n19 = n19;
                                                                                                                                                if (n19 <= n3) break block147;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                int n23;
                                                                                                                                                cArray17 = cArray17;
                                                                                                                                                int n24 = n3;
                                                                                                                                                char c3 = cArray17[n24];
                                                                                                                                                switch (n3 % 5) {
                                                                                                                                                    case 0: {
                                                                                                                                                        n23 = 33;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 1: {
                                                                                                                                                        n23 = 122;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 2: {
                                                                                                                                                        n23 = 13;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 3: {
                                                                                                                                                        n23 = 119;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    default: {
                                                                                                                                                        n23 = 24;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                cArray17[n24] = (char)(c3 ^ n23);
                                                                                                                                                ++n3;
                                                                                                                                                n19 = n19;
                                                                                                                                            } while (n19 > n3);
                                                                                                                                        }
                                                                                                                                        stringArray[1] = new String(cArray17).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray21 = "K\u001b{\u00166R\u001fn\u0002jH\u000etYkQ\u001fnYJr;]\u0005qW\u001by\u0012[S\u000eF\u0012ar\nh\u0014".toCharArray();
                                                                                                                                        cArray16 = cArray21;
                                                                                                                                        n18 = cArray21.length;
                                                                                                                                        n3 = 0;
                                                                                                                                        if (!true) break block148;
                                                                                                                                        n18 = n18;
                                                                                                                                        if (n18 <= n3) break block149;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        int n25;
                                                                                                                                        cArray16 = cArray16;
                                                                                                                                        int n26 = n3;
                                                                                                                                        char c4 = cArray16[n26];
                                                                                                                                        switch (n3 % 5) {
                                                                                                                                            case 0: {
                                                                                                                                                n25 = 33;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 1: {
                                                                                                                                                n25 = 122;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 2: {
                                                                                                                                                n25 = 13;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 3: {
                                                                                                                                                n25 = 119;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            default: {
                                                                                                                                                n25 = 24;
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                        cArray16[n26] = (char)(c4 ^ n25);
                                                                                                                                        ++n3;
                                                                                                                                        n18 = n18;
                                                                                                                                    } while (n18 > n3);
                                                                                                                                }
                                                                                                                                stringArray[2] = new String(cArray16).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray22 = "t\u0014~\u0002hQ\u0015\u007f\u0003}EZf\u0012a\u0001\t}\u0012{H\u001cd\u0014yU\u0013b\u0019\"\u0001".toCharArray();
                                                                                                                                cArray15 = cArray22;
                                                                                                                                n17 = cArray22.length;
                                                                                                                                n3 = 0;
                                                                                                                                if (!true) break block150;
                                                                                                                                n17 = n17;
                                                                                                                                if (n17 <= n3) break block151;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                int n27;
                                                                                                                                cArray15 = cArray15;
                                                                                                                                int n28 = n3;
                                                                                                                                char c5 = cArray15[n28];
                                                                                                                                switch (n3 % 5) {
                                                                                                                                    case 0: {
                                                                                                                                        n27 = 33;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 1: {
                                                                                                                                        n27 = 122;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 2: {
                                                                                                                                        n27 = 13;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 3: {
                                                                                                                                        n27 = 119;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    default: {
                                                                                                                                        n27 = 24;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                cArray15[n28] = (char)(c5 ^ n27);
                                                                                                                                ++n3;
                                                                                                                                n17 = n17;
                                                                                                                            } while (n17 > n3);
                                                                                                                        }
                                                                                                                        stringArray[3] = new String(cArray15).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray23 = "K\u001b{\u00166R\u001fn\u0002jH\u000etYkQ\u001fnY@\u0014J42vB\u0015i\u0012|j\u001ft$hD\u0019".toCharArray();
                                                                                                                        cArray14 = cArray23;
                                                                                                                        n16 = cArray23.length;
                                                                                                                        n3 = 0;
                                                                                                                        if (!true) break block152;
                                                                                                                        n16 = n16;
                                                                                                                        if (n16 <= n3) break block153;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        int n29;
                                                                                                                        cArray14 = cArray14;
                                                                                                                        int n30 = n3;
                                                                                                                        char c6 = cArray14[n30];
                                                                                                                        switch (n3 % 5) {
                                                                                                                            case 0: {
                                                                                                                                n29 = 33;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 1: {
                                                                                                                                n29 = 122;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 2: {
                                                                                                                                n29 = 13;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 3: {
                                                                                                                                n29 = 119;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            default: {
                                                                                                                                n29 = 24;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        cArray14[n30] = (char)(c6 ^ n29);
                                                                                                                        ++n3;
                                                                                                                        n16 = n16;
                                                                                                                    } while (n16 > n3);
                                                                                                                }
                                                                                                                stringArray[4] = new String(cArray14).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray24 = "h\u0014l\u0007hS\u0015}\u0005q@\u000ehWsD\u0003-\u0003aQ\u001f".toCharArray();
                                                                                                                cArray13 = cArray24;
                                                                                                                n15 = cArray24.length;
                                                                                                                n3 = 0;
                                                                                                                if (!true) break block154;
                                                                                                                n15 = n15;
                                                                                                                if (n15 <= n3) break block155;
                                                                                                            }
                                                                                                            do {
                                                                                                                int n31;
                                                                                                                cArray13 = cArray13;
                                                                                                                int n32 = n3;
                                                                                                                char c7 = cArray13[n32];
                                                                                                                switch (n3 % 5) {
                                                                                                                    case 0: {
                                                                                                                        n31 = 33;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 1: {
                                                                                                                        n31 = 122;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 2: {
                                                                                                                        n31 = 13;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 3: {
                                                                                                                        n31 = 119;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    default: {
                                                                                                                        n31 = 24;
                                                                                                                    }
                                                                                                                }
                                                                                                                cArray13[n32] = (char)(c7 ^ n31);
                                                                                                                ++n3;
                                                                                                                n15 = n15;
                                                                                                            } while (n15 > n3);
                                                                                                        }
                                                                                                        stringArray[5] = new String(cArray13).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray25 = "K\u001b{\u00166R\u001fn\u0002jH\u000etYkQ\u001fnYJr;]\u0002zM\u0013n<}X)}\u0012{".toCharArray();
                                                                                                        cArray12 = cArray25;
                                                                                                        n14 = cArray25.length;
                                                                                                        n3 = 0;
                                                                                                        if (!true) break block156;
                                                                                                        n14 = n14;
                                                                                                        if (n14 <= n3) break block157;
                                                                                                    }
                                                                                                    do {
                                                                                                        int n33;
                                                                                                        cArray12 = cArray12;
                                                                                                        int n34 = n3;
                                                                                                        char c8 = cArray12[n34];
                                                                                                        switch (n3 % 5) {
                                                                                                            case 0: {
                                                                                                                n33 = 33;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 1: {
                                                                                                                n33 = 122;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 2: {
                                                                                                                n33 = 13;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 3: {
                                                                                                                n33 = 119;
                                                                                                                break;
                                                                                                            }
                                                                                                            default: {
                                                                                                                n33 = 24;
                                                                                                            }
                                                                                                        }
                                                                                                        cArray12[n34] = (char)(c8 ^ n33);
                                                                                                        ++n3;
                                                                                                        n14 = n14;
                                                                                                    } while (n14 > n3);
                                                                                                }
                                                                                                stringArray[6] = new String(cArray12).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray26 = "K\u001b{\u00166R\u001fn\u0002jH\u000etYkQ\u001fnYJr;]\u0005qW\u001by\u0012SD\u0003^\u0007}B".toCharArray();
                                                                                                cArray11 = cArray26;
                                                                                                n13 = cArray26.length;
                                                                                                n3 = 0;
                                                                                                if (!true) break block158;
                                                                                                n13 = n13;
                                                                                                if (n13 <= n3) break block159;
                                                                                            }
                                                                                            do {
                                                                                                int n35;
                                                                                                cArray11 = cArray11;
                                                                                                int n36 = n3;
                                                                                                char c9 = cArray11[n36];
                                                                                                switch (n3 % 5) {
                                                                                                    case 0: {
                                                                                                        n35 = 33;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 1: {
                                                                                                        n35 = 122;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 2: {
                                                                                                        n35 = 13;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 3: {
                                                                                                        n35 = 119;
                                                                                                        break;
                                                                                                    }
                                                                                                    default: {
                                                                                                        n35 = 24;
                                                                                                    }
                                                                                                }
                                                                                                cArray11[n36] = (char)(c9 ^ n35);
                                                                                                ++n3;
                                                                                                n13 = n13;
                                                                                            } while (n13 > n3);
                                                                                        }
                                                                                        stringArray[7] = new String(cArray11).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray27 = "h\u0014l\u0007hS\u0015}\u0005q@\u000ehWsD\u0003-\u0004hD\u0019d\u0011qB\u001by\u001ewO@-".toCharArray();
                                                                                        cArray10 = cArray27;
                                                                                        n12 = cArray27.length;
                                                                                        n3 = 0;
                                                                                        if (!true) break block160;
                                                                                        n12 = n12;
                                                                                        if (n12 <= n3) break block161;
                                                                                    }
                                                                                    do {
                                                                                        int n37;
                                                                                        cArray10 = cArray10;
                                                                                        int n38 = n3;
                                                                                        char c10 = cArray10[n38];
                                                                                        switch (n3 % 5) {
                                                                                            case 0: {
                                                                                                n37 = 33;
                                                                                                break;
                                                                                            }
                                                                                            case 1: {
                                                                                                n37 = 122;
                                                                                                break;
                                                                                            }
                                                                                            case 2: {
                                                                                                n37 = 13;
                                                                                                break;
                                                                                            }
                                                                                            case 3: {
                                                                                                n37 = 119;
                                                                                                break;
                                                                                            }
                                                                                            default: {
                                                                                                n37 = 24;
                                                                                            }
                                                                                        }
                                                                                        cArray10[n38] = (char)(c10 ^ n37);
                                                                                        ++n3;
                                                                                        n12 = n12;
                                                                                    } while (n12 > n3);
                                                                                }
                                                                                stringArray[8] = new String(cArray10).intern();
                                                                                var0 = null;
                                                                                char[] cArray28 = "\u0001\u0018d\u0003k\u0001\u0016b\u0019\u007f".toCharArray();
                                                                                cArray9 = cArray28;
                                                                                n11 = cArray28.length;
                                                                                n3 = 0;
                                                                                if (!true) break block162;
                                                                                n11 = n11;
                                                                                if (n11 <= n3) break block163;
                                                                            }
                                                                            do {
                                                                                int n39;
                                                                                cArray9 = cArray9;
                                                                                int n40 = n3;
                                                                                char c11 = cArray9[n40];
                                                                                switch (n3 % 5) {
                                                                                    case 0: {
                                                                                        n39 = 33;
                                                                                        break;
                                                                                    }
                                                                                    case 1: {
                                                                                        n39 = 122;
                                                                                        break;
                                                                                    }
                                                                                    case 2: {
                                                                                        n39 = 13;
                                                                                        break;
                                                                                    }
                                                                                    case 3: {
                                                                                        n39 = 119;
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        n39 = 24;
                                                                                    }
                                                                                }
                                                                                cArray9[n40] = (char)(c11 ^ n39);
                                                                                ++n3;
                                                                                n11 = n11;
                                                                            } while (n11 > n3);
                                                                        }
                                                                        stringArray[9] = new String(cArray9).intern();
                                                                        var0 = null;
                                                                        char[] cArray29 = "s)LWsD\u0003~WuT\tyWzDZl\u00038M\u001fl\u0004l\u0001".toCharArray();
                                                                        cArray8 = cArray29;
                                                                        n10 = cArray29.length;
                                                                        n3 = 0;
                                                                        if (!true) break block164;
                                                                        n10 = n10;
                                                                        if (n10 <= n3) break block165;
                                                                    }
                                                                    do {
                                                                        int n41;
                                                                        cArray8 = cArray8;
                                                                        int n42 = n3;
                                                                        char c12 = cArray8[n42];
                                                                        switch (n3 % 5) {
                                                                            case 0: {
                                                                                n41 = 33;
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                n41 = 122;
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                n41 = 13;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                n41 = 119;
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                n41 = 24;
                                                                            }
                                                                        }
                                                                        cArray8[n42] = (char)(c12 ^ n41);
                                                                        ++n3;
                                                                        n10 = n10;
                                                                    } while (n10 > n3);
                                                                }
                                                                stringArray[10] = new String(cArray8).intern();
                                                                var0 = null;
                                                                char[] cArray30 = "s)LW}Y\nb\u0019}O\u000e~W{@\u0014-\u0015}\u0001\u0014bWtN\u0014j\u0012j\u0001\u000ee\u0016v\u0001L9WzH\u000e~W8H\u001c-\u001awE\u000fa\u0002k\u0001\u0013~W\u007fS\u001fl\u0003}SZy\u001fyOZ>G/\u0013Zo\u001elR".toCharArray();
                                                                cArray7 = cArray30;
                                                                n9 = cArray30.length;
                                                                n3 = 0;
                                                                if (!true) break block166;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block167;
                                                            }
                                                            do {
                                                                int n43;
                                                                cArray7 = cArray7;
                                                                int n44 = n3;
                                                                char c13 = cArray7[n44];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n43 = 33;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n43 = 122;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n43 = 13;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n43 = 119;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n43 = 24;
                                                                    }
                                                                }
                                                                cArray7[n44] = (char)(c13 ^ n43);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[11] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray31 = "\u0001\u0018d\u0003k".toCharArray();
                                                        cArray6 = cArray31;
                                                        n8 = cArray31.length;
                                                        n3 = 0;
                                                        if (!true) break block168;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block169;
                                                    }
                                                    do {
                                                        int n45;
                                                        cArray6 = cArray6;
                                                        int n46 = n3;
                                                        char c14 = cArray6[n46];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n45 = 33;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n45 = 122;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n45 = 13;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n45 = 119;
                                                                break;
                                                            }
                                                            default: {
                                                                n45 = 24;
                                                            }
                                                        }
                                                        cArray6[n46] = (char)(c14 ^ n45);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[12] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray32 = "s)LWsD\u0003~WuT\tyWzDZc\u00188M\u0015c\u0010}SZy\u001fyOZ".toCharArray();
                                                cArray5 = cArray32;
                                                n7 = cArray32.length;
                                                n3 = 0;
                                                if (!true) break block170;
                                                n7 = n7;
                                                if (n7 <= n3) break block171;
                                            }
                                            do {
                                                int n47;
                                                cArray5 = cArray5;
                                                int n48 = n3;
                                                char c15 = cArray5[n48];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n47 = 33;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n47 = 122;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n47 = 13;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n47 = 119;
                                                        break;
                                                    }
                                                    default: {
                                                        n47 = 24;
                                                    }
                                                }
                                                cArray5[n48] = (char)(c15 ^ n47);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[13] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray33 = "v\bb\u0019\u007f\u0001\u001ba\u0010wS\u0013y\u001fu\u0001\u000et\u0007}".toCharArray();
                                        cArray4 = cArray33;
                                        n6 = cArray33.length;
                                        n3 = 0;
                                        if (!true) break block172;
                                        n6 = n6;
                                        if (n6 <= n3) break block173;
                                    }
                                    do {
                                        int n49;
                                        cArray4 = cArray4;
                                        int n50 = n3;
                                        char c16 = cArray4[n50];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n49 = 33;
                                                break;
                                            }
                                            case 1: {
                                                n49 = 122;
                                                break;
                                            }
                                            case 2: {
                                                n49 = 13;
                                                break;
                                            }
                                            case 3: {
                                                n49 = 119;
                                                break;
                                            }
                                            default: {
                                                n49 = 24;
                                            }
                                        }
                                        cArray4[n50] = (char)(c16 ^ n49);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[14] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray34 = "b\u001bc\u0019wUZy\u0005yO\ta\u0016lDZf\u0012a\u001bZ".toCharArray();
                                cArray3 = cArray34;
                                n5 = cArray34.length;
                                n3 = 0;
                                if (!true) break block174;
                                n5 = n5;
                                if (n5 <= n3) break block175;
                            }
                            do {
                                int n51;
                                cArray3 = cArray3;
                                int n52 = n3;
                                char c17 = cArray3[n52];
                                switch (n3 % 5) {
                                    case 0: {
                                        n51 = 33;
                                        break;
                                    }
                                    case 1: {
                                        n51 = 122;
                                        break;
                                    }
                                    case 2: {
                                        n51 = 13;
                                        break;
                                    }
                                    case 3: {
                                        n51 = 119;
                                        break;
                                    }
                                    default: {
                                        n51 = 24;
                                    }
                                }
                                cArray3[n52] = (char)(c17 ^ n51);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[15] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray35 = "B\u0015`YqC\u0017#\u0014jX\ny\u00186Q\bb\u0001qE\u001f\u007fYjD\ty\u0005qB\u000e_$Yd\u0002}\u0018vD\u0014y".toCharArray();
                        cArray2 = cArray35;
                        n4 = cArray35.length;
                        n3 = 0;
                        if (!true) break block176;
                        n4 = n4;
                        if (n4 <= n3) break block177;
                    }
                    do {
                        int n53;
                        cArray2 = cArray2;
                        int n54 = n3;
                        char c18 = cArray2[n54];
                        switch (n3 % 5) {
                            case 0: {
                                n53 = 33;
                                break;
                            }
                            case 1: {
                                n53 = 122;
                                break;
                            }
                            case 2: {
                                n53 = 13;
                                break;
                            }
                            case 3: {
                                n53 = 119;
                                break;
                            }
                            default: {
                                n53 = 24;
                            }
                        }
                        cArray2[n54] = (char)(c18 ^ n53);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[16] = new String(cArray2).intern();
                var0 = null;
                char[] cArray36 = "U\bx\u0012".toCharArray();
                cArray = cArray36;
                n2 = cArray36.length;
                n3 = 0;
                if (!true) break block178;
                n2 = n2;
                if (n2 <= n3) break block179;
            }
            do {
                int n55;
                cArray = cArray;
                int n56 = n3;
                char c19 = cArray[n56];
                switch (n3 % 5) {
                    case 0: {
                        n55 = 33;
                        break;
                    }
                    case 1: {
                        n55 = 122;
                        break;
                    }
                    case 2: {
                        n55 = 13;
                        break;
                    }
                    case 3: {
                        n55 = 119;
                        break;
                    }
                    default: {
                        n55 = 24;
                    }
                }
                cArray[n56] = (char)(c19 ^ n55);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[17] = new String(cArray).intern();
        z = stringArray;
        a = z[17].equalsIgnoreCase(AccessController.doPrivileged(new GetPropertyAction(z[16], z[17])));
    }
}

