/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.Constants;
import com.ibm.ws.ssl.SSLPropertyUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Properties;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class LibertySSLServerSocketFactoryWrapper
extends SSLServerSocketFactory {
    private static final TraceComponent tc = Tr.register(LibertySSLServerSocketFactoryWrapper.class, (String)"SSL", (String)"com.ibm.ws.ssl");
    private SSLServerSocketFactory delegate = null;
    private final Properties props;

    public LibertySSLServerSocketFactoryWrapper(SSLServerSocketFactory sslSocketFactory) {
        this.delegate = sslSocketFactory;
        this.props = SSLPropertyUtils.lookupProperties();
    }

    public LibertySSLServerSocketFactoryWrapper(SSLServerSocketFactory sslSocketFactory, String alias) {
        this.delegate = sslSocketFactory;
        this.props = SSLPropertyUtils.lookupProperties(alias);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        String securityLevel = this.props.getProperty("com.ibm.ssl.securityLevel");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("securityLevel from properties is " + securityLevel));
        }
        if (securityLevel == null) {
            securityLevel = "HIGH";
        }
        return Constants.adjustSupportedCiphersToSecurityLevel(this.delegate.getSupportedCipherSuites(), securityLevel);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.delegate.createServerSocket(port);
        SSLPropertyUtils.setSSLPropertiesOnServerSocket(this.props, socket);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.delegate.createServerSocket(port, backlog);
        SSLPropertyUtils.setSSLPropertiesOnServerSocket(this.props, socket);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.delegate.createServerSocket(port, backlog, ifAddress);
        SSLPropertyUtils.setSSLPropertiesOnServerSocket(this.props, socket);
        return socket;
    }
}

