/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.LibertySSLSocketFactoryWrapper;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class LibertySSLContextSpi
extends SSLContextSpi {
    private static final TraceComponent tc = Tr.register(LibertySSLContextSpi.class, (String)"SSL", (String)"com.ibm.ws.ssl");
    private final SSLContext delegate;
    private String alias;

    public LibertySSLContextSpi(SSLContext sslContext) {
        this.delegate = sslContext;
    }

    public LibertySSLContextSpi(SSLContext sslContext, String alias) {
        this.delegate = sslContext;
        this.alias = alias;
    }

    @Override
    protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
        this.delegate.init(km, tm, sr);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return new LibertySSLSocketFactoryWrapper(this.delegate.getSocketFactory(), this.alias);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return this.delegate.getServerSocketFactory();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        return this.delegate.createSSLEngine();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String host, int port) {
        return this.delegate.createSSLEngine(host, port);
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.delegate.getServerSessionContext();
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.delegate.getClientSessionContext();
    }
}

