/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMUtils {
    public static final DocumentBuilderFactory DOM_FACTORY = DocumentBuilderFactory.newInstance();

    public static void save(Document document, File file) throws TransformerException {
        DOMUtils.save(document, new StreamResult(file));
    }

    public static void save(Document document, OutputStream out) throws TransformerException {
        DOMUtils.save(document, new StreamResult(out));
    }

    public static void save(Document document, Result result) throws TransformerException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        Properties oprops = new Properties();
        oprops.put("method", "xml");
        oprops.put("omit-xml-declaration", "yes");
        oprops.put("version", "1.0");
        oprops.put("indent", "yes");
        serializer.setOutputProperties(oprops);
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        serializer.transform(new DOMSource(document), result);
    }

    public static String toString(Document document) throws TransformerException {
        StringWriter writer = new StringWriter();
        DOMUtils.save(document, new StreamResult(writer));
        return writer.toString();
    }

    public static Document load(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DOM_FACTORY.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(xml)));
    }

    public static Document load(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DOM_FACTORY.newDocumentBuilder();
        return builder.parse(file);
    }

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilder builder = DOM_FACTORY.newDocumentBuilder();
        return builder.newDocument();
    }
}

