/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.actions.BaseAction;
import com.ibm.ws.bluemix.utility.api.BluemixClient;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceInstance;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceKey;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.Option;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import java.util.List;
import java.util.Map;

public class ShowServiceAction
extends BaseAction {
    private static final Option SHOW_CREDENTIALS_OPT = new Option("showCredentials", false);

    public ShowServiceAction() {
        this.registerOption(SHOW_CREDENTIALS_OPT);
        this.registerArguments("serviceName");
    }

    @Override
    public String getActionName() {
        return "showService";
    }

    @Override
    public ReturnCode handleAction(Arguments arguments) throws Exception {
        boolean showKeys = arguments.hasOption(SHOW_CREDENTIALS_OPT);
        String serviceName = arguments.getPositionalArguments().get(0);
        BluemixClient client = BluemixClient.getBluemixClient();
        CloudFoundryServiceInstance service = client.getService(serviceName);
        this.printServiceInfo(client, service, showKeys);
        return ReturnCode.OK;
    }

    private void printServiceInfo(BluemixClient client, CloudFoundryServiceInstance service, boolean showKeys) throws Exception {
        String documentationUrl;
        String description;
        this.stdout.println(NLS.getOption("showService.name", service.getName()));
        this.stdout.println(NLS.getOption("showService.label", service.getService().getLabel()));
        String plan = service.getPlan().getName();
        if (plan != null) {
            this.stdout.println(NLS.getOption("showService.plan", plan));
        }
        if ((description = service.getService().getDescription()) != null) {
            this.stdout.println(NLS.getOption("showService.description", description));
        }
        if ((documentationUrl = service.getService().getDocumentationUrl()) != null) {
            this.stdout.println(NLS.getOption("showService.documentationUrl", documentationUrl));
        }
        this.stdout.println(NLS.getOption("showService.service.keys", new Object[0]));
        this.printServiceKeys(client, service, showKeys, "  ");
    }

    private void printServiceKeys(BluemixClient client, CloudFoundryServiceInstance service, boolean showKeys, String tab) {
        List<CloudFoundryServiceKey> serviceKeys = service.getServiceKeys();
        if (serviceKeys != null) {
            for (CloudFoundryServiceKey serviceKey : serviceKeys) {
                this.stdout.println(tab + serviceKey.getName());
                if (!showKeys) continue;
                this.printServiceCredentials(serviceKey, tab + tab);
            }
        }
    }

    private void printServiceCredentials(CloudFoundryServiceKey key, String tab) {
        Map<String, Object> map = key.getCredentials();
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.stdout.println(tab + entry.getKey() + ": " + entry.getValue());
        }
    }
}

