/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.actions.BaseLoginAction;
import com.ibm.ws.bluemix.utility.api.ServiceConfigurationRegistry;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.File;
import java.util.Map;
import java.util.Set;

public class ShowImportAction
extends BaseLoginAction {
    public ShowImportAction() {
        this.registerArguments("serviceName");
    }

    @Override
    public String getActionName() {
        return "showImport";
    }

    @Override
    public ReturnCode handleAction(Arguments args) throws Exception {
        String serviceName = args.getPositionalArguments().get(0);
        ServiceConfigurationRegistry registry = new ServiceConfigurationRegistry(Utils.getUserDir());
        Map<String, String> variables = registry.getServiceVariables(serviceName);
        File importLocation = registry.getServiceImportDirectory(serviceName);
        this.stdout.println(NLS.getOption("showImport.location", importLocation));
        if (variables.isEmpty()) {
            this.stdout.println(NLS.getOption("showImport.variables.none", new Object[0]));
        } else {
            this.stdout.println(NLS.getOption("showImport.variables", new Object[0]));
            for (Map.Entry<String, String> variable : variables.entrySet()) {
                this.stdout.println(NLS.getOption("showImport.variable.name", variable.getKey()));
                this.stdout.println(NLS.getOption("showImport.variable.value", variable.getValue()));
                this.stdout.println();
            }
        }
        Set<String> boundServers = registry.getServersBound(serviceName);
        if (boundServers.isEmpty()) {
            this.stdout.println(NLS.getOption("showImport.bound.servers.none", new Object[0]));
        } else {
            this.stdout.println(NLS.getOption("showImport.bound.servers", new Object[0]));
            for (String serverName : boundServers) {
                this.stdout.println(NLS.getOption("showImport.bound.servers.name", serverName));
            }
        }
        return ReturnCode.OK;
    }
}

