/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.client.rest.internal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class ObjectIdentityCache {
    private final Map<ObjectReference, Integer> identityMap = new HashMap<ObjectReference, Integer>();
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private int nextIdentity = -2147483647;

    int getObjectIdentity(Object o) {
        ObjectReference clearedRef = (ObjectReference)this.referenceQueue.poll();
        while (clearedRef != null) {
            this.identityMap.remove(clearedRef);
            clearedRef = (ObjectReference)this.referenceQueue.poll();
        }
        if (o == null) {
            return Integer.MIN_VALUE;
        }
        ObjectReference ref = new ObjectReference(o, this.referenceQueue);
        if (this.identityMap.containsKey(ref)) {
            return this.identityMap.get(ref);
        }
        if (this.nextIdentity == Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int identity = this.nextIdentity++;
        this.identityMap.put(ref, identity);
        return identity;
    }

    private static class ObjectReference
    extends WeakReference<Object> {
        private final int hashCode;

        ObjectReference(Object referent, ReferenceQueue<Object> queue) {
            super(referent, queue);
            this.hashCode = referent.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ObjectReference) {
                ObjectReference other = (ObjectReference)o;
                return other.get() == this.get();
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

