/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.channelfw.base;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.OutboundConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;

public abstract class OutboundConnectorLink
implements OutboundConnectionLink {
    private static final TraceComponent tc = Tr.register(OutboundConnectorLink.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private ConnectionLink linkOnDeviceSide = null;
    private ConnectionReadyCallback linkOnApplicationSide = null;
    protected VirtualConnection vc = null;

    @Override
    public VirtualConnection getVirtualConnection() {
        return this.vc;
    }

    @Override
    public void setDeviceLink(ConnectionLink next) {
        this.linkOnDeviceSide = next;
    }

    @Override
    public void setApplicationCallback(ConnectionReadyCallback next) {
        this.linkOnApplicationSide = next;
    }

    @Override
    public ConnectionLink getDeviceLink() {
        return this.linkOnDeviceSide;
    }

    @Override
    public ConnectionReadyCallback getApplicationCallback() {
        return this.linkOnApplicationSide;
    }

    protected void destroy() {
        this.vc = null;
        this.linkOnApplicationSide = null;
        this.linkOnDeviceSide = null;
    }

    public void init(VirtualConnection connection) {
        this.vc = connection;
    }

    @Override
    public void close(VirtualConnection conn, Exception e) {
        if (e != null) {
            this.logClosedException(e);
        }
        this.destroy(e);
        conn.destroy();
    }

    @Override
    public void destroy(Exception e) {
        ConnectionReadyCallback appside = this.getApplicationCallback();
        if (appside != null) {
            appside.destroy(e);
        }
        this.destroy();
    }

    public void logClosedException(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Connection closed with exception: " + e.getMessage()), (Object[])new Object[0]);
        }
    }
}

