/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.routing.member.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={HttpSessionPublishListener.class, EventHandler.class}, immediate=true, property={"service.vendor=IBM", "event.topics=com/ibm/wsspi/collective/repository/publish/mbean"})
public class HttpSessionPublishListener
implements EventHandler {
    private static final TraceComponent tc = Tr.register(HttpSessionPublishListener.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
    private boolean httpSessionOptionsPublished = false;
    private ApplicationRoutingInfoPublisher applicationRoutingInfoPublisher;
    BundleContext bundleContext = null;
    static final long serialVersionUID = -6473226545826993347L;

    @Activate
    protected void activate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.bundleContext = null;
    }

    public void registerListener(ApplicationRoutingInfoPublisher applicationRoutingInfoPublisher) {
        this.applicationRoutingInfoPublisher = applicationRoutingInfoPublisher;
        if (this.httpSessionOptionsPublished) {
            applicationRoutingInfoPublisher.httpSessionOptionsPublished();
        }
    }

    public void unregisterListener() {
        this.applicationRoutingInfoPublisher = null;
    }

    public boolean httpSessionPublished() {
        return this.httpSessionOptionsPublished;
    }

    public boolean isHttpSessionOptionsPublished() {
        return this.httpSessionOptionsPublished;
    }

    public synchronized void handleEvent(@Sensitive Event publishEvent) {
        if (this.httpSessionOptionsPublished) {
            return;
        }
        if (FrameworkState.isStopping()) {
            return;
        }
        if (publishEvent == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"handleEvent: Unable to complete handleEvent, Event is null.", (Object[])new Object[0]);
            }
            return;
        }
        String MBEAN_OBJECT_NAME = "mbeanObjectName";
        String MBEAN_ATTRIBUTE_NAME = "mbeanAttributeName";
        String objectName = (String)publishEvent.getProperty(MBEAN_OBJECT_NAME);
        String attributeName = (String)publishEvent.getProperty(MBEAN_ATTRIBUTE_NAME);
        Tr.debug((TraceComponent)tc, (String)("handleEvent: topic: " + publishEvent.getTopic() + ", objectName: " + objectName + ", attributeName: " + attributeName), (Object[])new Object[0]);
        if (objectName == null || attributeName == null) {
            return;
        }
        if (objectName.equals("WebSphere:name=com.ibm.ws.jmx.mbeans.sessionManagerMBean") && attributeName.equals("CloneID")) {
            this.httpSessionOptionsPublished = true;
            if (this.applicationRoutingInfoPublisher != null) {
                this.applicationRoutingInfoPublisher.httpSessionOptionsPublished();
            }
            boolean unregistered = this.bundleContext.ungetService(this.bundleContext.getServiceReference(EventHandler.class));
            Tr.debug((TraceComponent)tc, (String)("handleEvent: unregistered: " + unregistered), (Object[])new Object[0]);
        }
    }
}

