/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.tracker;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.aries.jndi.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CachingServiceTracker<S>
extends ServiceTracker<S, ServiceReference<S>> {
    private volatile Map<String, ServiceReference<S>> cache;
    private final Function<ServiceReference<S>, Iterable<String>> properties;

    public CachingServiceTracker(BundleContext context, Class<S> clazz) {
        this(context, clazz, ref -> Collections.emptyList());
    }

    public CachingServiceTracker(BundleContext context, Class<S> clazz, Function<ServiceReference<S>, Iterable<String>> properties) {
        super(context, clazz, null);
        this.properties = properties;
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference<S> find(String identifier) {
        if (this.cache == null) {
            CachingServiceTracker cachingServiceTracker = this;
            synchronized (cachingServiceTracker) {
                HashMap<String, ServiceReference<S>> c = new HashMap<String, ServiceReference<S>>();
                if (this.cache == null) {
                    for (ServiceReference<S> ref : this.getReferences()) {
                        for (String key : this.properties.apply(ref)) {
                            c.putIfAbsent(key, ref);
                        }
                    }
                    this.cache = c;
                }
            }
        }
        return this.cache.get(identifier);
    }

    public List<ServiceReference<S>> getReferences() {
        ServiceReference[] refs = Utils.doPrivileged(() -> ((CachingServiceTracker)this).getServiceReferences());
        if (refs != null) {
            Arrays.sort(refs, Comparator.reverseOrder());
            return Arrays.asList(refs);
        }
        return Collections.emptyList();
    }

    public synchronized ServiceReference<S> addingService(ServiceReference<S> reference) {
        this.cache = null;
        return reference;
    }

    public synchronized void removedService(ServiceReference<S> reference, ServiceReference<S> service) {
        this.cache = null;
    }

    public void modifiedService(ServiceReference<S> reference, ServiceReference<S> service) {
        this.cache = null;
    }
}

