/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.writer.HPELRepositoryExporter;
import com.ibm.websphere.logging.hpel.writer.RepositoryExporter;
import com.ibm.ws.logging.hpel.LogRecordSerializer;
import com.ibm.ws.logging.hpel.LogRepositoryWriter;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBaseImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryManagerImpl;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractHPELRepositoryExporter
implements RepositoryExporter {
    private static final String BUNDLE_NAME = "com.ibm.ws.logging.hpel.resources.HpelMessages";
    private static final String className = HPELRepositoryExporter.class.getName();
    private static final Logger logger = Logger.getLogger(className, "com.ibm.ws.logging.hpel.resources.HpelMessages");
    private static final String UNKNOWN_LABEL = "unknown";
    private LogRecordSerializer lrs = LogRepositoryManagerImpl.KNOWN_FORMATTERS[0];
    private LogRepositoryWriter logWriter = null;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
    private boolean isClosed = false;
    private String parentId = null;

    @Override
    public void storeHeader(Properties header) {
        this.storeHeader(header, null);
    }

    @Override
    public void storeHeader(Properties header, String subProcess) {
        String pid;
        if (header == null) {
            throw new IllegalArgumentException("Argument 'header' cannot be null.");
        }
        if (this.isClosed) {
            throw new IllegalStateException("This instance of the exporter is already closed");
        }
        if (subProcess != null && this.parentId == null) {
            throw new IllegalStateException("This instance of the exporter does not have parent header information yet");
        }
        if (this.logWriter != null) {
            this.logWriter.stop();
        }
        if (subProcess == null) {
            String label;
            pid = header.getProperty("ProcessId");
            int index = pid.indexOf("/");
            if (index > -1) {
                pid = pid.substring(0, index);
            }
            if (pid == null) {
                logger.logp(Level.SEVERE, className, "storeHeader", "HPEL_HeaderWithoutProcessId", "ProcessId");
                this.logWriter = null;
                return;
            }
            if ("Y".equalsIgnoreCase(header.getProperty("isZOS"))) {
                label = header.getProperty("jobName", UNKNOWN_LABEL);
                String jobId = header.getProperty("jobId");
                if (jobId != null) {
                    label = label + '_' + jobId;
                }
            } else {
                int begIndex;
                String fullServerName = header.getProperty("ServerName");
                label = fullServerName != null ? ((begIndex = fullServerName.lastIndexOf("\\")) > -1 && begIndex + 1 < fullServerName.length() ? fullServerName.substring(begIndex + 1) : fullServerName) : UNKNOWN_LABEL;
            }
            this.logWriter = this.createWriter(pid, label);
            this.parentId = pid;
        } else {
            pid = LogRepositoryBaseImpl.parseProcessID(subProcess);
            String label = LogRepositoryBaseImpl.parseLabel(subProcess);
            this.logWriter = this.createSubWriter(pid, label, this.parentId);
        }
        this.buffer.reset();
        try {
            DataOutputStream dataStream = new DataOutputStream(this.buffer);
            this.lrs.serializeFileHeader(header, dataStream);
            dataStream.flush();
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, className, "storeHeader", "HPEL_ErrorWhileSerializingHeader", e);
            this.buffer.reset();
        }
        this.logWriter.setHeader(this.buffer.toByteArray());
    }

    @Override
    public void storeRecord(RepositoryLogRecord record) {
        if (this.isClosed) {
            throw new IllegalStateException("This instance of the exporter is already closed");
        }
        if (this.parentId == null) {
            throw new IllegalStateException("This instance of the exporter does not have header information yet");
        }
        if (record == null) {
            throw new IllegalArgumentException("Argument 'record' cannot be null.");
        }
        if (this.logWriter == null) {
            logger.logp(Level.SEVERE, className, "storeRecord", "HPEL_LogHeaderWasNotSet");
            return;
        }
        this.buffer.reset();
        try {
            DataOutputStream dataStream = new DataOutputStream(this.buffer);
            this.lrs.serialize(record, dataStream);
            dataStream.flush();
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, className, "storeRecord", "HPEL_ErrorWhileSerializingRecord", e);
            this.buffer.reset();
        }
        this.logWriter.logRecord(record.getMillis(), this.buffer.toByteArray());
    }

    @Override
    public void close() {
        if (this.logWriter != null) {
            this.logWriter.stop();
            this.logWriter = null;
        }
        this.isClosed = true;
    }

    protected abstract LogRepositoryWriter createWriter(String var1, String var2);

    protected abstract LogRepositoryWriter createSubWriter(String var1, String var2, String var3);
}

