/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Components;

public class ComponentsValidator
extends TypeValidator<Components> {
    private static final TraceComponent tc = Tr.register(ComponentsValidator.class);
    private static final ComponentsValidator INSTANCE = new ComponentsValidator();

    public static ComponentsValidator getInstance() {
        return INSTANCE;
    }

    private ComponentsValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Components t) {
        if (t != null) {
            HashMap<String, Map> components = new HashMap<String, Map>();
            if (t.getCallbacks() != null && !t.getCallbacks().isEmpty()) {
                components.put("callbacks", t.getCallbacks());
            }
            if (t.getExamples() != null && !t.getExamples().isEmpty()) {
                components.put("examples", t.getExamples());
            }
            if (t.getHeaders() != null && !t.getHeaders().isEmpty()) {
                components.put("headers", t.getHeaders());
            }
            if (t.getLinks() != null && !t.getLinks().isEmpty()) {
                components.put("links", t.getLinks());
            }
            if (t.getParameters() != null && !t.getParameters().isEmpty()) {
                components.put("parameters", t.getParameters());
            }
            if (t.getRequestBodies() != null && !t.getRequestBodies().isEmpty()) {
                components.put("requestBodies", t.getRequestBodies());
            }
            if (t.getResponses() != null && !t.getResponses().isEmpty()) {
                components.put("responses", t.getResponses());
            }
            if (t.getSchemas() != null && !t.getSchemas().isEmpty()) {
                components.put("schemas", t.getSchemas());
            }
            if (t.getSecuritySchemes() != null && !t.getSecuritySchemes().isEmpty()) {
                components.put("securitySchemes", t.getSecuritySchemes());
            }
            if (!components.isEmpty()) {
                for (String mapName : components.keySet()) {
                    Map component = (Map)components.get(mapName);
                    boolean mapContainsInvalidKey = false;
                    for (String k : component.keySet()) {
                        if (k != null) {
                            String message;
                            if (!k.matches("^[a-zA-Z0-9\\.\\-_]+$")) {
                                message = Tr.formatMessage((TraceComponent)tc, (String)"keyNotARegex", (Object[])new Object[]{k});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(mapName), message));
                            }
                            if (component.get(k) != null) continue;
                            message = Tr.formatMessage((TraceComponent)tc, (String)"nullValueInMap", (Object[])new Object[]{k});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(mapName), message));
                            continue;
                        }
                        mapContainsInvalidKey = true;
                    }
                    if (!mapContainsInvalidKey) continue;
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"nullOrEmptyKeyInMap", (Object[])new Object[0]);
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(mapName), message));
                }
            }
        }
    }
}

