/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.cache.internal;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory;
import com.ibm.ws.annocache.targets.internal.TargetsTableAnnotationsImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesMultiImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableTimeStampImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap;
import com.ibm.ws.annocache.util.internal.UtilImpl_Utils;
import com.ibm.ws.annocache.util.internal.UtilImpl_WriteBuffer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.targets.cache.TargetCache_BinaryConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetCacheImpl_WriterBinary
implements TargetCache_BinaryConstants {
    private static final String CLASS_NAME = TargetCacheImpl_WriterBinary.class.getSimpleName();
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    private static final int WRITE_BUFFER_SIZE = 65536;
    protected final TargetCacheImpl_Factory factory;
    protected final UtilImpl_WriteBuffer bufOutput;
    private final Map<String, Integer> strings;
    public static final int BEGIN_SIZE = 4;
    public static final int END_SIZE = 4;
    public static final int STAMP_PREFIX_SIZE = 241;
    public static final int STAMP_NAME_SIZE = 515;
    public static final int STAMP_SUFFIX_SIZE = 60;
    public static final int STAMP_SIZE = 820;
    static final long serialVersionUID = 4596322827369424407L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getTimeStamp() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "getTimeStamp", new Object[0]);
        }
        String string = UtilImpl_Utils.getDateAndTime();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "getTimeStamp", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_WriterBinary(TargetCacheImpl_Factory factory, String path, OutputStream output, String encoding) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "<init>", new Object[]{factory, path, output, encoding});
        }
        this.factory = factory;
        this.bufOutput = new UtilImpl_WriteBuffer(path, output, 65536, encoding);
        this.strings = new LinkedHashMap<String, Integer>();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "<init>", this);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Factory getFactory() {
        return this.factory;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPath() {
        return this.bufOutput.getPath();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getEncoding() {
        return this.bufOutput.getEncoding();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_WriteBuffer getBuffer() {
        return this.bufOutput;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "close", new Object[0]);
        }
        String methodName = "close";
        try {
            this.bufOutput.close();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", (String)"97", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_CACHE_EXCEPTION", e.getMessage());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int map(String value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "map", new Object[]{value});
        }
        Integer priorOffset = this.strings.get(value);
        if (priorOffset != null) {
            int n = priorOffset;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                n = n;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "map", n);
            }
            return n;
        }
        int numValues = this.strings.size();
        this.strings.put(value, numValues);
        int n = numValues;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "map", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeCompact(byte fieldByte, String value) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeCompact", new Object[]{fieldByte, value});
        }
        this.bufOutput.writeLargeInt(fieldByte, this.map(value));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeCompact");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeStrings() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeStrings", new Object[0]);
        }
        int tableOffset = this.bufOutput.getTotalWritten();
        this.bufOutput.write((byte)3);
        this.bufOutput.writeLargeInt(this.strings.size());
        for (String value : this.strings.keySet()) {
            this.bufOutput.write(value);
        }
        this.bufOutput.write((byte)4);
        this.bufOutput.writeLargeInt(tableOffset);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeStrings");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeBegin() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeBegin", new Object[0]);
        }
        this.bufOutput.write(MAGIC_BEGIN_BYTES, 0, 4);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeBegin");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeEnd() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEnd", new Object[0]);
        }
        this.bufOutput.write(MAGIC_END_BYTES, 0, 4);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEnd");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeHeader(String tableTag, String tableVersion) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeHeader", new Object[]{tableTag, tableVersion});
        }
        this.bufOutput.write((byte)1);
        this.bufOutput.write((byte)17, this.getEncoding(), 60);
        this.bufOutput.write((byte)18, tableTag, 60);
        this.bufOutput.write((byte)19, tableVersion, 60);
        this.bufOutput.write((byte)20, TargetCacheImpl_WriterBinary.getTimeStamp(), 60);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeTrailer(int offset) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeTrailer", new Object[]{offset});
        }
        this.bufOutput.write((byte)4);
        this.bufOutput.writeLargeInt(offset);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeTrailer");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeEntire(TargetsTableTimeStampImpl stampTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire", new Object[]{stampTable});
        }
        this.writeBegin();
        this.writeFragment(stampTable);
        this.writeEnd();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeEntire(TargetsTableClassesImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire", new Object[]{classTable});
        }
        this.writeBegin();
        this.writeFragment(classTable);
        this.writeStrings();
        this.writeEnd();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeEntire(TargetsTableClassesImpl classTable, TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire", new Object[]{classTable, targetTable});
        }
        this.writeBegin();
        this.writeFragment(classTable);
        this.writeFragment(targetTable);
        this.writeStrings();
        this.writeEnd();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void rewrite(TargetsTableTimeStampImpl stampTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "rewrite", new Object[]{stampTable});
        }
        this.writeBegin();
        this.writeFragment(stampTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "rewrite");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeEntire(TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire", new Object[]{targetTable});
        }
        this.writeBegin();
        this.writeFragment(targetTable);
        this.writeStrings();
        this.writeEnd();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeFragment(TargetsTableTimeStampImpl stampTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeFragment", new Object[]{stampTable});
        }
        this.writeHeader("Stamp", "1.0");
        this.bufOutput.write((byte)21, stampTable.getName());
        this.bufOutput.write((byte)22, stampTable.getStamp(), 60);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeFragment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeFragment(TargetsTableClassesImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeFragment", new Object[]{classTable});
        }
        this.writeHeader("Classes", "1.0");
        this.bufOutput.write((byte)2);
        this.writePackages(classTable);
        this.writeClasses(classTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeFragment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeFragment(TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeFragment", new Object[]{targetTable});
        }
        this.writeHeader("Annotation Targets", "1.0");
        this.bufOutput.write((byte)2);
        this.writePackageTargets(targetTable);
        this.writeClassTargets(targetTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeFragment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writePackages(TargetsTableClassesImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writePackages", new Object[]{classTable});
        }
        Set<String> i_packageNames = classTable.i_getPackageNames();
        this.bufOutput.writeLargeInt(i_packageNames.size());
        for (String i_packageName : i_packageNames) {
            this.writeCompact((byte)49, i_packageName);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writePackages");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeClasses(TargetsTableClassesImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeClasses", new Object[]{classTable});
        }
        Set<String> i_classNames = classTable.i_getClassNames();
        this.bufOutput.writeLargeInt(i_classNames.size());
        for (String i_className : i_classNames) {
            String i_superClassName = classTable.i_getSuperclassName(i_className);
            String[] i_interfaces = classTable.i_getInterfaceNames(i_className);
            Integer modifiers = classTable.i_getModifiers(i_className);
            this.writeClass(i_className, i_superClassName, i_interfaces, modifiers);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeClass(String className, String superClassName, String[] interfaceNames, Integer modifiers) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeClass", new Object[]{className, superClassName, interfaceNames, modifiers});
        }
        this.writeCompact((byte)50, className);
        if (superClassName == null) {
            superClassName = "";
        }
        this.writeCompact((byte)65, superClassName);
        int numInterfaces = interfaceNames == null ? 0 : interfaceNames.length;
        this.bufOutput.writeSmallInt(numInterfaces);
        if (numInterfaces > 0) {
            for (String interfaceName : interfaceNames) {
                this.writeCompact((byte)66, interfaceName);
            }
        }
        int modifiersValue = modifiers == null ? 0 : modifiers;
        this.bufOutput.writeLargeInt((byte)66, modifiersValue);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writePackageTargets(TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writePackageTargets", new Object[]{targetTable});
        }
        UtilImpl_BidirectionalMap targetMap = targetTable.i_getPackageAnnotations();
        Set<String> i_packageNames = targetMap.getHolderSet();
        this.bufOutput.writeLargeInt(i_packageNames.size());
        for (String i_packageName : i_packageNames) {
            this.writeCompact((byte)49, i_packageName);
            Set<String> i_annotationClassNames = targetMap.selectHeldOf(i_packageName);
            int numAnnotations = i_annotationClassNames.size();
            this.bufOutput.writeSmallInt(numAnnotations);
            for (String i_annotationClassName : i_annotationClassNames) {
                this.writeCompact((byte)81, i_annotationClassName);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writePackageTargets");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeClassTargets(TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeClassTargets", new Object[]{targetTable});
        }
        IdentityHashMap<String, String> i_annotatedClassNames = new IdentityHashMap<String, String>();
        UtilImpl_BidirectionalMap classTargetMap = targetTable.i_getClassAnnotations();
        UtilImpl_BidirectionalMap fieldTargetMap = targetTable.i_getFieldAnnotations();
        UtilImpl_BidirectionalMap methodTargetMap = targetTable.i_getMethodAnnotations();
        for (String i_annotationClassName : classTargetMap.getHolderSet()) {
            i_annotatedClassNames.put(i_annotationClassName, i_annotationClassName);
        }
        for (String i_annotationClassName : fieldTargetMap.getHolderSet()) {
            i_annotatedClassNames.put(i_annotationClassName, i_annotationClassName);
        }
        for (String i_annotationClassName : methodTargetMap.getHolderSet()) {
            i_annotatedClassNames.put(i_annotationClassName, i_annotationClassName);
        }
        Set i_classNames = i_annotatedClassNames.keySet();
        this.bufOutput.writeLargeInt(i_classNames.size());
        for (String i_className : i_classNames) {
            this.writeCompact((byte)50, i_className);
            Set<String> i_classAnnotations = classTargetMap.selectHeldOf(i_className);
            Set<String> i_fieldAnnotations = fieldTargetMap.selectHeldOf(i_className);
            Set<String> i_methodAnnotations = methodTargetMap.selectHeldOf(i_className);
            this.bufOutput.writeSmallInt(i_classAnnotations.size() + i_fieldAnnotations.size() + i_methodAnnotations.size());
            for (String i_annotationClassName : i_classAnnotations) {
                this.writeCompact((byte)82, i_annotationClassName);
            }
            for (String i_annotationClassName : i_fieldAnnotations) {
                this.writeCompact((byte)83, i_annotationClassName);
            }
            for (String i_annotationClassName : i_methodAnnotations) {
                this.writeCompact((byte)84, i_annotationClassName);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeClassTargets");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeEntire(TargetsTableContainersImpl containerTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire", new Object[]{containerTable});
        }
        this.writeBegin();
        this.writeFragment(containerTable);
        this.writeStrings();
        this.writeEnd();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeFragment(TargetsTableContainersImpl containerTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeFragment", new Object[]{containerTable});
        }
        this.writeHeader("Container", "1.0");
        this.bufOutput.write((byte)2);
        List<String> containerNames = containerTable.getNames();
        this.bufOutput.writeLargeInt(containerNames.size());
        for (String name : containerNames) {
            ClassSource_Aggregate.ScanPolicy policy = containerTable.getPolicy(name);
            String writeName = name.equals("/") ? "root" : name;
            this.writeCompact((byte)21, writeName);
            this.writeCompact((byte)33, policy.toString());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeFragment");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeResolvedRefsEntire(Collection<String> resolvedClassNames) throws IOException {
        this.writeBegin();
        this.writeResolvedRefsFragment(resolvedClassNames);
        this.writeEnd();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeResolvedRefsFragment(Collection<String> resolvedClassNames) throws IOException {
        this.writeHeader("Resolved References", "1.0");
        this.bufOutput.write((byte)2);
        this.bufOutput.writeLargeInt(resolvedClassNames.size());
        for (String className : resolvedClassNames) {
            this.bufOutput.write((byte)50, className);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeUnresolvedRefsEntire(Collection<String> unresolvedClassNames) throws IOException {
        this.writeBegin();
        this.writeUnresolvedRefsFragment(unresolvedClassNames);
        this.writeEnd();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeUnresolvedRefsFragment(Collection<String> unresolvedClassNames) throws IOException {
        this.writeHeader("Unresolved References", "1.0");
        this.bufOutput.write((byte)2);
        this.bufOutput.writeLargeInt(unresolvedClassNames.size());
        for (String className : unresolvedClassNames) {
            this.bufOutput.write((byte)50, className);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeEntire(TargetsTableClassesMultiImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire", new Object[]{classTable});
        }
        this.writeBegin();
        this.writeFragment(classTable);
        this.writeStrings();
        this.writeEnd();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeFragment(TargetsTableClassesMultiImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeFragment", new Object[]{classTable});
        }
        this.writeHeader("Classes", "1.0");
        this.bufOutput.write((byte)2);
        this.writePackages(classTable);
        this.writeClasses(classTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeFragment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writePackages(TargetsTableClassesMultiImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writePackages", new Object[]{classTable});
        }
        Map<String, String> i_packageMap = classTable.i_getPackageNameClassSourceMap();
        this.bufOutput.writeLargeInt(i_packageMap.size());
        for (Map.Entry<String, String> i_packageEntry : i_packageMap.entrySet()) {
            String i_packageName = i_packageEntry.getKey();
            String classSourceName = i_packageEntry.getValue();
            this.writeCompact((byte)49, i_packageName);
            this.writeCompact((byte)51, classSourceName);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writePackages");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeClasses(TargetsTableClassesMultiImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeClasses", new Object[]{classTable});
        }
        Map<String, String> i_classMap = classTable.i_getClassNameClassSourceMap();
        this.bufOutput.writeLargeInt(i_classMap.size());
        for (Map.Entry<String, String> i_classEntry : i_classMap.entrySet()) {
            String i_className = i_classEntry.getKey();
            String classSourceName = i_classEntry.getValue();
            String i_superClassName = classTable.i_getSuperclassName(i_className);
            String[] i_interfaces = classTable.i_getInterfaceNames(i_className);
            Integer modifiers = classTable.i_getModifiers(i_className);
            this.writeClass(classSourceName, i_className, i_superClassName, i_interfaces, modifiers);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeClass(String classSourceName, String className, String superClassName, String[] interfaceNames, Integer modifiers) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeClass", new Object[]{classSourceName, className, superClassName, interfaceNames, modifiers});
        }
        this.writeCompact((byte)50, className);
        this.writeCompact((byte)51, classSourceName);
        if (superClassName == null) {
            superClassName = "";
        }
        this.writeCompact((byte)65, superClassName);
        int numInterfaceNames = interfaceNames == null ? 0 : interfaceNames.length;
        this.bufOutput.writeSmallInt(numInterfaceNames);
        if (numInterfaceNames > 0) {
            for (String interfaceName : interfaceNames) {
                this.writeCompact((byte)66, interfaceName);
            }
        }
        int modifiersValue = modifiers == null ? 0 : modifiers;
        this.bufOutput.writeLargeInt((byte)66, modifiersValue);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary", "writeClass");
        }
    }
}

