/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.values;

import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.genericbnf.KeyMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ContentEncodingValues
extends GenericKeys {
    private static final AtomicInteger NEXT_ORDINAL = new AtomicInteger(0);
    private static final List<ContentEncodingValues> allKeys = new ArrayList<ContentEncodingValues>();
    private static final KeyMatcher myMatcher = new KeyMatcher(false);
    public static final ContentEncodingValues UNDEF = new ContentEncodingValues("Undefined");
    public static final ContentEncodingValues NOTSET = new ContentEncodingValues("Not-Set");
    public static final ContentEncodingValues GZIP = new ContentEncodingValues("gzip");
    public static final ContentEncodingValues XGZIP = new ContentEncodingValues("x-gzip");
    public static final ContentEncodingValues IDENTITY = new ContentEncodingValues("identity");
    public static final ContentEncodingValues COMPRESS = new ContentEncodingValues("compress");
    public static final ContentEncodingValues XCOMPRESS = new ContentEncodingValues("x-compress");
    public static final ContentEncodingValues DEFLATE = new ContentEncodingValues("deflate");
    private boolean undefined = false;

    public ContentEncodingValues(String name) {
        super(name, NEXT_ORDINAL.getAndIncrement());
        allKeys.add(this);
        myMatcher.add(this);
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public static ContentEncodingValues getByOrdinal(int i) {
        return allKeys.get(i);
    }

    @Override
    public int compareTo(ContentEncodingValues val) {
        return null == val ? -1 : this.getOrdinal() - val.getOrdinal();
    }

    public static ContentEncodingValues match(String name, int offset, int length) {
        if (null == name) {
            return null;
        }
        return (ContentEncodingValues)myMatcher.match(name, offset, length);
    }

    public static ContentEncodingValues match(byte[] name, int offset, int length) {
        if (null == name) {
            return null;
        }
        return (ContentEncodingValues)myMatcher.match(name, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentEncodingValues find(byte[] name, int offset, int length) {
        ContentEncodingValues key = (ContentEncodingValues)myMatcher.match(name, offset, length);
        if (null != key) return key;
        Class<ContentEncodingValues> clazz = ContentEncodingValues.class;
        synchronized (ContentEncodingValues.class) {
            key = (ContentEncodingValues)myMatcher.match(name, offset, length);
            if (null != key) return key;
            key = new ContentEncodingValues(new String(name, offset, length));
            key.undefined = true;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentEncodingValues find(String name) {
        ContentEncodingValues key = (ContentEncodingValues)myMatcher.match(name, 0, name.length());
        if (null != key) return key;
        Class<ContentEncodingValues> clazz = ContentEncodingValues.class;
        synchronized (ContentEncodingValues.class) {
            key = (ContentEncodingValues)myMatcher.match(name, 0, name.length());
            if (null != key) return key;
            key = new ContentEncodingValues(name);
            key.undefined = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return key;
        }
    }

    public static ContentEncodingValues find(byte[] name) {
        return ContentEncodingValues.find(name, 0, name.length);
    }
}

