/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.dispatcher.internal.channel;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.http.channel.internal.HttpTrailerGeneratorImpl;
import com.ibm.ws.http.channel.internal.HttpTrailersImpl;
import com.ibm.ws.http.channel.internal.outbound.HttpOutputStreamImpl;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.HttpResponse;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpTrailerGenerator;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.http.ee7.HttpOutputStreamEE7;
import io.openliberty.http.ext.HttpResponseExt;
import java.util.ArrayList;
import java.util.List;

@Trivial
public class HttpResponseImpl
implements HttpResponse,
HttpResponseExt {
    private HttpInboundServiceContext isc = null;
    private HttpResponseMessage message = null;
    private HttpOutputStreamImpl body = null;
    private HttpDispatcherLink connlink = null;

    public HttpResponseImpl(HttpDispatcherLink link) {
        this.connlink = link;
    }

    public void init(HttpInboundServiceContext context) {
        this.isc = context;
        this.message = context.getResponse();
        this.body = null;
    }

    @Override
    public boolean isCommitted() {
        return this.message.isCommitted();
    }

    @Override
    public void addCookie(HttpCookie cookie) {
        this.message.setCookie(cookie, HttpHeaderKeys.HDR_SET_COOKIE);
    }

    @Override
    public HttpCookie getCookie(String name) {
        return this.message.getCookie(name);
    }

    @Override
    public List<HttpCookie> getCookies(String name) {
        return this.message.getAllCookies(name);
    }

    @Override
    public boolean isPersistent() {
        return this.isc.isPersistent();
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.message.getAllCookies();
    }

    @Override
    public void removeCookie(HttpCookie cookie) {
        this.message.removeCookie(cookie.getName(), HttpHeaderKeys.HDR_SET_COOKIE);
    }

    @Override
    public long getContentLength() {
        return this.message.getContentLength();
    }

    @Override
    public void setContentLength(long length) {
        this.message.setContentLength(length);
        if (this.body != null) {
            this.body.setContentLength(length);
        }
    }

    @Override
    public void setHeader(String name, String value) {
        this.message.setHeader(name, value);
    }

    @Override
    public void setHeader(HttpHeaderKeys key, String value) {
        this.message.setHeader((HeaderKeys)key, value);
    }

    @Override
    public String setHeaderIfAbsent(HttpHeaderKeys key, String value) {
        HeaderField oldValue = this.message.setHeaderIfAbsent(key, value);
        return oldValue == null ? null : oldValue.asString();
    }

    @Override
    public void removeHeader(String name) {
        this.message.removeHeader(name);
    }

    @Override
    public void removeHeader(HttpHeaderKeys key) {
        this.message.removeHeader(key);
    }

    @Override
    public void removeAllHeaders() {
        this.message.removeAllHeaders();
    }

    @Override
    public void addHeader(String name, String value) {
        this.message.appendHeader(name, value);
    }

    @Override
    public HttpOutputStreamImpl getBody() {
        if (null == this.body) {
            long messageContentLength;
            this.body = HttpDispatcher.useEE7Streams() ? new HttpOutputStreamEE7(this.isc) : new HttpOutputStreamImpl(this.isc);
            this.body.setVirtualConnection(this.connlink.getVirtualConnection());
            if (this.message != null && (messageContentLength = this.getContentLength()) != -1L) {
                this.body.setContentLength(this.getContentLength());
            }
        }
        return this.body;
    }

    @Override
    public String getHeader(String name) {
        return this.message.getHeader(name).asString();
    }

    @Override
    public String getHeader(HttpHeaderKeys key) {
        return this.message.getHeader(key).asString();
    }

    @Override
    public List<String> getHeaders(String name) {
        List<HeaderField> hdrs = this.message.getHeaders(name);
        ArrayList<String> values = new ArrayList<String>(hdrs.size());
        for (HeaderField header : hdrs) {
            values.add(header.asString());
        }
        return values;
    }

    @Override
    public List<String> getHeaders() {
        List<HeaderField> hdrs = this.message.getAllHeaders();
        ArrayList<String> values = new ArrayList<String>(hdrs.size());
        for (HeaderField header : hdrs) {
            values.add(header.getName());
        }
        return values;
    }

    @Override
    public List<String> getHeaderNames() {
        return this.message.getAllHeaderNames();
    }

    @Override
    public String getReason() {
        return this.message.getReasonPhrase();
    }

    @Override
    public int getStatus() {
        return this.message.getStatusCodeAsInt();
    }

    @Override
    public String getVersion() {
        return this.message.getVersion();
    }

    @Override
    public void setReason(String phrase) {
        this.message.setReasonPhrase(phrase);
    }

    @Override
    public void setStatus(int code) {
        this.message.setStatusCode(code);
    }

    @Override
    public void setVersion(String version) {
        try {
            this.message.setVersion(version);
        }
        catch (UnsupportedProtocolVersionException e) {
            this.message.setVersion(VersionValues.V11);
        }
    }

    @Override
    public void reset() {
        this.message.clear();
        this.body.clear();
    }

    @Override
    public void setTrailer(String name, String value) {
        HttpHeaderKeys key;
        HttpTrailersImpl trailers = this.message.createTrailers();
        if (trailers.containsDeferredTrailer(key = HttpHeaderKeys.find(name, false))) {
            trailers.removeDeferredTrailer(key);
        }
        HttpTrailerGeneratorImpl generator = new HttpTrailerGeneratorImpl(key, value);
        trailers.setDeferredTrailer(key, (HttpTrailerGenerator)generator);
    }

    @Override
    public void writeTrailers() {
        HttpTrailersImpl trailers = this.message.createTrailers();
        trailers.computeRemainingTrailers();
    }
}

