/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.values;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.channel.internal.values.CookieData;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;

public class CookieVersionData
extends CookieData {
    private static final TraceComponent tc = Tr.register(CookieVersionData.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");

    public CookieVersionData() {
        super("version");
    }

    @Override
    public boolean set(HttpCookie cookie, byte[] attribValue) {
        block4: {
            try {
                if (null != cookie && null != attribValue && 0 < attribValue.length) {
                    cookie.setVersion(GenericUtils.asIntValue(attribValue));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Cookie version set to " + cookie.getVersion()), (Object[])new Object[0]);
                    }
                    return true;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"set", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception setting version; " + e), (Object[])new Object[0]);
            }
        }
        return false;
    }

    @Override
    public boolean validForHeader(HeaderKeys hdr, boolean includesDollar) {
        if (HttpHeaderKeys.HDR_COOKIE.equals(hdr) || HttpHeaderKeys.HDR_COOKIE2.equals(hdr)) {
            return includesDollar;
        }
        if (HttpHeaderKeys.HDR_SET_COOKIE.equals(hdr) || HttpHeaderKeys.HDR_SET_COOKIE2.equals(hdr)) {
            return !includesDollar;
        }
        return false;
    }
}

