/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.command;

import com.ibm.websphere.command.CommandTarget;
import com.ibm.websphere.command.TargetPolicy;
import com.ibm.websphere.command.TargetableCommand;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.beans.Beans;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;

public class TargetPolicyDefault
implements TargetPolicy,
Serializable {
    private static final TraceComponent _tc = Tr.register(TargetPolicyDefault.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static final long serialVersionUID = 8533555590544760338L;
    protected Dictionary mapping = new Hashtable();
    protected Hashtable targetTable = new Hashtable();
    protected String defaultTargetName = "com.ibm.websphere.command.LocalTarget";
    protected transient CommandTarget defaultTarget = null;

    @Override
    public CommandTarget getCommandTarget(TargetableCommand command) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getCommandTarget", (Object[])new Object[]{command});
        }
        CommandTarget target = null;
        target = command.getCommandTarget();
        if (target != null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"getCommandTarget", (Object)target);
            }
            return target;
        }
        String targetName = command.getCommandTargetName();
        if (targetName == null) {
            String commandName = command.getClass().getName();
            targetName = (String)this.mapping.get(commandName);
        }
        if (targetName == null) {
            if (this.defaultTarget == null && this.defaultTargetName != null) {
                try {
                    this.defaultTarget = (CommandTarget)Beans.instantiate(SerializationUtility.getContextClassLoader(), this.defaultTargetName);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.websphere.command.TargetPolicyDefault.getCommandTarget", (String)"134", (Object)this);
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"executeCommand", (Object[])new Object[]{e});
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"executeCommand", (Object[])new Object[]{"Beans.instantiate() failed " + e.getMessage()});
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)_tc, (String)"getCommandTarget", (Object)this.defaultTarget);
                    }
                    return this.defaultTarget;
                }
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"getCommandTarget", (Object)this.defaultTarget);
            }
            return this.defaultTarget;
        }
        target = (CommandTarget)this.targetTable.get(targetName);
        if (target == null) {
            Object targetClass = null;
            try {
                Object targetObj = Beans.instantiate(SerializationUtility.getContextClassLoader(), targetName);
                target = (CommandTarget)targetObj;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.websphere.command.TargetPolicyDefault.getCommandTarget", (String)"157", (Object)this);
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"executeCommand", (Object[])new Object[]{e});
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"executeCommand", (Object[])new Object[]{"Beans.instantiate() failed " + e.getMessage()});
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)_tc, (String)"getCommandTarget", (Object)this.defaultTarget);
                }
                return this.defaultTarget;
            }
            this.targetTable.put(targetName, target);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getCommandTarget", (Object)target);
        }
        return target;
    }

    public Dictionary listMappings() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"listMappings", (Object[])new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"listMappings", (Object)this.mapping);
        }
        return this.mapping;
    }

    public void registerCommand(String commandBeanName, String targetBeanName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"registerCommand", (Object[])new Object[]{commandBeanName, targetBeanName});
        }
        this.mapping.put(commandBeanName, targetBeanName);
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"registerCommand");
        }
    }

    public void setDefaultTargetName(String defaultTargetName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"setDefaultTargetName", (Object[])new Object[]{defaultTargetName});
        }
        this.defaultTargetName = defaultTargetName;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setDefaultTargetName");
        }
    }

    public void unregisterCommand(String commandBeanName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"unregisterCommand", (Object[])new Object[]{commandBeanName});
        }
        this.mapping.remove(commandBeanName);
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"unregisterCommand");
        }
    }
}

