/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.ZipCachingProperties;
import com.ibm.ws.artifact.zip.cache.ZipFileHandle;
import com.ibm.ws.artifact.zip.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.zip.internal.FileUtils;
import com.ibm.ws.artifact.zip.internal.ZipFileArtifactNotifier;
import com.ibm.ws.artifact.zip.internal.ZipFileContainerUtils;
import com.ibm.ws.artifact.zip.internal.ZipFileEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.kernel.service.utils.ParserUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ZipFileContainer
implements ArtifactContainer {
    static final TraceComponent tc = Tr.register(ZipFileContainer.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
    public static final boolean USE_EXTRA_PATH_CACHE = ZipCachingProperties.ARTIFACT_ZIP_USE_EXTRA_PATH_CACHE;
    public static final boolean COLLECT_TIMINGS = ZipCachingProperties.ARTIFACT_ZIP_COLLECT_TIMINGS;
    private static final TimingsLock timingsLock = COLLECT_TIMINGS ? new TimingsLock() : null;
    private static int[] timingCounts = COLLECT_TIMINGS ? new int[Timings.values().length] : null;
    private static long[] timingTotals;
    private static final int MAP_LOOKUP_FREQUENCY = 100;
    private static final int ARRAY_LOOKUP_FREQUENCY = 100;
    private static final int EXTRACT_FREQUENCY = 10;
    private final String archiveName;
    private static final int CURRENT_JAVA_VERSION;
    public static final String JDK_DISABLE_MULTI_RELEASE_PROPERTY_NAME = "jdk.util.jar.enableMultiRelease";
    public static final String JDK_DISABLE_MULTI_RELEASE_DEFAULT_VALUE = "true";
    private static final boolean JDK_DISABLE_MULTI_RELEASE;
    private final MultiReleaseLock multiReleaseLock = new MultiReleaseLock();
    private volatile Boolean isMultiRelease = null;
    private final ContainerFactoryHolder containerFactoryHolder;
    private final File cacheDir;
    private final File nestedCacheDir;
    private final ArtifactContainer enclosingContainer;
    private final ArtifactEntry entryInEnclosingContainer;
    private final ArchiveFileLock archiveFileLock;
    private boolean archiveFileFailed;
    private File archiveFile;
    private String archiveFilePath;
    private URI archiveFileURI;
    private final ZipFileHandleLock zipFileHandleLock = new ZipFileHandleLock();
    private boolean zipFileHandleFailed;
    private ZipFileHandle zipFileHandle;
    private final FastModeLock fastModeLock = new FastModeLock();
    private int fastModeCount;
    private final ZipEntryDataLock zipEntryDataLock = new ZipEntryDataLock();
    private volatile ZipFileContainerUtils.ZipEntryData[] zipEntryData;
    private Map<String, ZipFileContainerUtils.ZipEntryData> zipEntryDataMap;
    private final IteratorDataLock iteratorDataLock = new IteratorDataLock();
    private volatile Map<String, ZipFileContainerUtils.IteratorData> iteratorData;
    private final NestedContainerEntriesLock nestedContainerEntriesLock = new NestedContainerEntriesLock();
    private Map<String, ZipFileEntry> nestedContainerEntries;
    public static final boolean IS_NORMALIZED = true;
    public static final boolean IS_NOT_NORMALIZED = false;
    private final ZipFileArtifactNotifier zipFileNotifier;
    private static final Map<String, CountDownLatch> extractionLocks;
    static final long serialVersionUID = -8831868836378045641L;

    @Trivial
    private static String toAbsMilliSec(long eventAt) {
        return ZipCachingProperties.toAbsMilliSec(eventAt);
    }

    @Trivial
    private static String dualTiming(long eventAt) {
        return ZipCachingProperties.dualTiming(eventAt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private static void record(Timings timing, long startTimeNs, long endTimeNs, String data, int frequency) {
        long newTotal;
        int newCount;
        int timingOrd = timing.ordinal();
        long durationNs = endTimeNs - startTimeNs;
        TimingsLock timingsLock = ZipFileContainer.timingsLock;
        synchronized (timingsLock) {
            int n = timingOrd;
            int n2 = timingCounts[n] + 1;
            timingCounts[n] = n2;
            newCount = n2;
            int n3 = timingOrd;
            long l = timingTotals[n3] + durationNs;
            timingTotals[n3] = l;
            newTotal = l;
        }
        if (data != null) {
            String startText = ZipFileContainer.dualTiming(startTimeNs);
            String durationText = ZipFileContainer.toAbsMilliSec(durationNs);
            System.out.println("ZFC [ " + data + " ] Timing [ " + (Object)((Object)timing) + " ] Count [ " + newCount + " ] at [ " + startText + " ] Duration [ " + durationText + "ms ]");
        }
        if (newCount % frequency == 0) {
            String totalText = ZipFileContainer.toAbsMilliSec(newTotal);
            System.out.println("ZFC Timing [ " + (Object)((Object)timing) + " ] Count [ " + newCount + " ] Total Duration [ " + totalText + "ms ]");
        }
    }

    @Trivial
    ZipFileContainer(File cacheDir, File archiveFile, ContainerFactoryHolder containerFactoryHolder) {
        String methodName = "<init>";
        this.containerFactoryHolder = containerFactoryHolder;
        this.cacheDir = cacheDir;
        this.nestedCacheDir = new File(cacheDir, ".cache");
        this.enclosingContainer = null;
        this.entryInEnclosingContainer = null;
        this.archiveFileLock = null;
        this.archiveFile = archiveFile;
        String useArchivePath = archiveFile.getAbsolutePath();
        this.archiveFileURI = ZipFileContainer.getURI(archiveFile);
        this.archiveFilePath = useArchivePath;
        this.archiveName = archiveFile.getName();
        this.zipFileNotifier = new ZipFileArtifactNotifier(this, useArchivePath);
        this.nestedContainerEntries = new HashMap<String, ZipFileEntry>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " ZipContainer (root-of-root)"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + " Archive file [ " + this.archiveFilePath + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + " Cache [ " + cacheDir.getAbsolutePath() + " ]"), (Object[])new Object[0]);
        }
        if (COLLECT_TIMINGS) {
            System.out.println("ZFC ZipContainer [ " + this.archiveFilePath + " ]");
        }
    }

    @Trivial
    ZipFileContainer(File cacheDir, ArtifactContainer enclosingContainer, ArtifactEntry entryInEnclosingContainer, File archiveFile, ContainerFactoryHolder containerFactoryHolder) {
        String methodName = "<init>";
        this.containerFactoryHolder = containerFactoryHolder;
        this.cacheDir = cacheDir;
        this.nestedCacheDir = new File(new File(cacheDir, ".cache"), entryInEnclosingContainer.getName());
        this.enclosingContainer = enclosingContainer;
        this.entryInEnclosingContainer = entryInEnclosingContainer;
        this.archiveFile = archiveFile;
        if (archiveFile != null) {
            String useArchivePath;
            this.archiveFileLock = null;
            this.archiveFilePath = useArchivePath = archiveFile.getAbsolutePath();
            this.archiveFileURI = ZipFileContainer.getURI(archiveFile);
            this.zipFileNotifier = new ZipFileArtifactNotifier(this, useArchivePath);
            this.archiveName = archiveFile.getName();
        } else {
            this.archiveFileLock = new ArchiveFileLock();
            this.zipFileNotifier = new ZipFileArtifactNotifier(this, entryInEnclosingContainer);
            this.archiveName = entryInEnclosingContainer.getName();
        }
        this.nestedContainerEntries = new HashMap<String, ZipFileEntry>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " ZipContainer (enclosed root)"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + " Enclosing container [ " + enclosingContainer.getPath() + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + " Enclosing entry [ " + entryInEnclosingContainer.getName() + " ]"), (Object[])new Object[0]);
            if (archiveFile != null) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Archive file [ " + this.archiveFilePath + " ]"), (Object[])new Object[0]);
            }
        }
        if (COLLECT_TIMINGS) {
            System.out.println("ZFC ZipContainer [ " + enclosingContainer.getPath() + " : " + entryInEnclosingContainer.getName() + " ]");
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.resetFastMode();
        }
        finally {
            super.finalize();
        }
    }

    @Trivial
    public boolean isRoot() {
        return true;
    }

    @Trivial
    public String getName() {
        return "/";
    }

    @Trivial
    public String getPath() {
        return "/";
    }

    @Trivial
    public String getAbsolutePath() {
        return "/";
    }

    @Trivial
    public String getRelativePath() {
        return "";
    }

    @Trivial
    public ZipFileContainer getRoot() {
        return this;
    }

    @Trivial
    public ContainerFactoryHolder getContainerFactoryHolder() {
        return this.containerFactoryHolder;
    }

    @Trivial
    private String getProtocol() {
        return this.containerFactoryHolder.useJarUrls() ? "jar" : "wsjar";
    }

    private ZipFileHandle getZipFileHandle(String path) throws IOException {
        return this.getContainerFactoryHolder().getZipCachingService().openZipFile(path);
    }

    @Trivial
    File getCacheDir() {
        return this.cacheDir;
    }

    @Trivial
    public File getNestedCacheDir() {
        return this.nestedCacheDir;
    }

    @Trivial
    protected File extract(ZipFileEntry entry) throws IOException {
        return this.extractEntry((ArtifactEntry)entry, this.getCacheDir());
    }

    protected File getCacheDir(ZipFileEntry entry) {
        File useNestedCacheDir = this.getNestedCacheDir();
        String a_entryPath = entry.getAbsolutePath();
        int slashLoc = a_entryPath.lastIndexOf(47);
        if (slashLoc > 0) {
            String r_entryParentPath = a_entryPath.substring(1, slashLoc);
            useNestedCacheDir = new File(useNestedCacheDir, r_entryParentPath);
        }
        return useNestedCacheDir;
    }

    @Trivial
    public ArtifactContainer getEnclosingContainer() {
        return this.enclosingContainer;
    }

    @Trivial
    public ArtifactEntry getEntryInEnclosingContainer() {
        return this.entryInEnclosingContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Trivial
    private File getArchiveFile() {
        String methodName = "getArchiveFile";
        if (this.archiveFileLock != null) {
            ArchiveFileLock archiveFileLock = this.archiveFileLock;
            synchronized (archiveFileLock) {
                if (this.archiveFile == null && !this.archiveFileFailed) {
                    try {
                        this.archiveFile = this.extractEntry(this.entryInEnclosingContainer, this.getCacheDir());
                        if (this.archiveFile != null) {
                            this.archiveFilePath = this.archiveFile.getAbsolutePath();
                            this.archiveFileURI = ZipFileContainer.getURI(this.archiveFile);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(methodName + " Archive file [ " + this.archiveFilePath + " ]"), (Object[])new Object[0]);
                            }
                        } else {
                            this.archiveFileFailed = true;
                            Tr.error((TraceComponent)tc, (String)"extract.cache.null", (Object[])new Object[]{this.entryInEnclosingContainer.getPath()});
                        }
                    }
                    catch (IOException iOException) {
                        void e;
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"646", (Object)this, (Object[])new Object[0]);
                        this.archiveFileFailed = true;
                        Tr.error((TraceComponent)tc, (String)"extract.cache.fail", (Object[])new Object[]{e.getMessage()});
                    }
                }
            }
        }
        return this.archiveFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getArchiveFilePath() {
        if (this.archiveFileLock == null) {
            return this.archiveFilePath;
        }
        ArchiveFileLock archiveFileLock = this.archiveFileLock;
        synchronized (archiveFileLock) {
            File useArchiveFile = this.getArchiveFile();
            return this.archiveFilePath;
        }
    }

    @Trivial
    @Deprecated
    public String getPhysicalPath() {
        return this.getArchiveFilePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    ZipFileHandle getZipFileHandle() throws IOException {
        ZipFileHandleLock zipFileHandleLock = this.zipFileHandleLock;
        synchronized (zipFileHandleLock) {
            if (this.zipFileHandleFailed) {
                return null;
            }
            if (this.zipFileHandle != null) {
                return this.zipFileHandle;
            }
            File useArchiveFile = this.getArchiveFile();
            if (useArchiveFile == null) {
                this.zipFileHandleFailed = true;
                throw new FileNotFoundException(this.entryInEnclosingContainer.getPath());
            }
            try {
                String useCanonicalPath = ZipFileContainer.getCanonicalPath(useArchiveFile);
                this.zipFileHandle = this.getZipFileHandle(useCanonicalPath);
            }
            catch (IOException useCanonicalPath) {
                void e;
                FFDCFilter.processException((Throwable)useCanonicalPath, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"773", (Object)this, (Object[])new Object[0]);
                this.zipFileHandleFailed = true;
                throw e;
            }
            return this.zipFileHandle;
        }
    }

    private ZipFile openZipFileHandle() {
        ZipFileHandle useZipFileHandle;
        try {
            useZipFileHandle = this.getZipFileHandle();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"785", (Object)this, (Object[])new Object[0]);
            useZipFileHandle = null;
            Tr.error((TraceComponent)tc, (String)"Failed to open", (Object[])new Object[]{this.getArchiveFilePath()});
        }
        if (useZipFileHandle == null) {
            return null;
        }
        try {
            return useZipFileHandle.open();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"795", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"Failed to open", (Object[])new Object[]{this.getArchiveFilePath()});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeZipFileHandle() {
        ZipFileHandleLock zipFileHandleLock = this.zipFileHandleLock;
        synchronized (zipFileHandleLock) {
            if (this.zipFileHandle != null) {
                this.zipFileHandle.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useFastMode() {
        FastModeLock fastModeLock = this.fastModeLock;
        synchronized (fastModeLock) {
            ++this.fastModeCount;
            ZipFile zipFile = this.openZipFileHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopUsingFastMode() {
        FastModeLock fastModeLock = this.fastModeLock;
        synchronized (fastModeLock) {
            if (this.fastModeCount <= 0) {
                return;
            }
            --this.fastModeCount;
            this.closeZipFileHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetFastMode() {
        FastModeLock fastModeLock = this.fastModeLock;
        synchronized (fastModeLock) {
            while (this.fastModeCount > 0) {
                --this.fastModeCount;
                this.closeZipFileHandle();
            }
        }
    }

    private String getTimingName() {
        if (this.archiveFileLock == null) {
            return this.archiveFilePath;
        }
        return this.enclosingContainer.getPath() + " : " + this.entryInEnclosingContainer.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private void setZipEntryData() {
        if (this.zipEntryData == null) {
            ZipEntryDataLock zipEntryDataLock = this.zipEntryDataLock;
            synchronized (zipEntryDataLock) {
                if (this.zipEntryData == null) {
                    String timingName = COLLECT_TIMINGS ? this.getTimingName() : null;
                    long dataStart = COLLECT_TIMINGS ? System.nanoTime() : -1L;
                    ZipFileContainerUtils.ZipEntryData[] useZipEntryData = this.createZipEntryData();
                    if (COLLECT_TIMINGS) {
                        ZipFileContainer.record(Timings.ARRAY_CREATE_TIME, dataStart, System.nanoTime(), timingName, 1);
                    }
                    if (USE_EXTRA_PATH_CACHE) {
                        long mapStart = COLLECT_TIMINGS ? System.nanoTime() : -1L;
                        this.zipEntryDataMap = ZipFileContainerUtils.setLocations(useZipEntryData);
                        if (COLLECT_TIMINGS) {
                            ZipFileContainer.record(Timings.MAP_CREATE_TIME, mapStart, System.nanoTime(), timingName, 1);
                        }
                    }
                    this.zipEntryData = useZipEntryData;
                }
            }
        }
    }

    @Trivial
    protected ZipFileContainerUtils.ZipEntryData[] getZipEntryData() {
        this.setZipEntryData();
        return this.zipEntryData;
    }

    @Trivial
    private ZipFileContainerUtils.ZipEntryData fastGetZipEntryData(String r_path) {
        this.setZipEntryData();
        return this.zipEntryDataMap.get(r_path);
    }

    @Trivial
    public int locatePath(String r_path) {
        int mrLocation;
        if (this.isMultiRelease != null && this.isMultiRelease.booleanValue() && (mrLocation = this.locateMultiReleasePath(r_path)) >= 0) {
            return mrLocation;
        }
        return this.locateDirectPath(r_path);
    }

    @Trivial
    private int locateDirectPath(String r_path) {
        if (USE_EXTRA_PATH_CACHE) {
            long mapLookupStart = COLLECT_TIMINGS ? System.nanoTime() : -1L;
            ZipFileContainerUtils.ZipEntryData entryData = this.fastGetZipEntryData(r_path);
            if (COLLECT_TIMINGS) {
                ZipFileContainer.record(Timings.MAP_LOOKUP_TIME, mapLookupStart, System.nanoTime(), null, 100);
            }
            if (entryData != null) {
                return entryData.getOffset();
            }
        }
        long lookupStart = COLLECT_TIMINGS ? System.nanoTime() : -1L;
        int location = ZipFileContainerUtils.locatePath(this.getZipEntryData(), r_path);
        if (COLLECT_TIMINGS) {
            ZipFileContainer.record(Timings.ARRAY_LOOKUP_TIME, lookupStart, System.nanoTime(), null, 100);
        }
        return location;
    }

    @Trivial
    private int locateMultiReleasePath(String path) {
        if (path == null || path.startsWith("META-INF") || path.startsWith("java/")) {
            return -1;
        }
        for (int currentVersion = CURRENT_JAVA_VERSION; currentVersion >= 9; --currentVersion) {
            int versionPath = this.locateDirectPath("META-INF/versions/" + currentVersion + "/" + path);
            if (versionPath < 0) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found MR path: META-INF/versions/" + currentVersion + "/" + path), (Object[])new Object[0]);
            }
            return versionPath;
        }
        return -1;
    }

    @Trivial
    public boolean isChildOf(String parentPath, String childPath) {
        int parentPathLen = parentPath.length();
        int childPathLen = childPath.length();
        if (childPathLen <= parentPathLen) {
            return false;
        }
        if (childPath.charAt(parentPathLen) != '/') {
            return false;
        }
        return childPath.startsWith(parentPath);
    }

    @Trivial
    private ZipFileContainerUtils.ZipEntryData[] createZipEntryData() {
        ZipFile useZipFile = this.openZipFileHandle();
        if (useZipFile == null) {
            return new ZipFileContainerUtils.ZipEntryData[0];
        }
        try {
            ZipFileContainerUtils.ZipEntryData[] zipEntryDataArray = ZipFileContainerUtils.collectZipEntries(useZipFile);
            return zipEntryDataArray;
        }
        finally {
            this.closeZipFileHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initializeMultiRelease() {
        if (this.isMultiRelease != null) {
            return this.isMultiRelease;
        }
        if (CURRENT_JAVA_VERSION < 9) {
            this.isMultiRelease = Boolean.FALSE;
            return this.isMultiRelease;
        }
        if (JDK_DISABLE_MULTI_RELEASE) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JDK system property set to globally disable multi-release jars", (Object[])new Object[0]);
            }
            this.isMultiRelease = Boolean.FALSE;
            return this.isMultiRelease;
        }
        if (!this.archiveName.endsWith(".jar")) {
            this.isMultiRelease = Boolean.FALSE;
            return this.isMultiRelease;
        }
        MultiReleaseLock multiReleaseLock = this.multiReleaseLock;
        synchronized (multiReleaseLock) {
            Boolean isMR;
            block17: {
                if (this.isMultiRelease != null) {
                    return this.isMultiRelease;
                }
                ZipFileEntry mfEntry = this.getEntry("META-INF/MANIFEST.MF");
                if (mfEntry == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No MANIFEST.MF found in container. Assuming not multi-release", (Object[])new Object[0]);
                    }
                    this.isMultiRelease = Boolean.FALSE;
                    return this.isMultiRelease;
                }
                try {
                    InputStream mfStream = mfEntry.getInputStream();
                    try {
                        Manifest mf = new Manifest(mfStream);
                        String isMultiReleaseAttr = mf.getMainAttributes().getValue("Multi-Release");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Raw value for 'Multi-Release' attribute: " + isMultiReleaseAttr), (Object[])new Object[0]);
                        }
                        isMR = isMultiReleaseAttr != null ? Boolean.valueOf(isMultiReleaseAttr.trim()) : Boolean.FALSE;
                        if (mfStream == null) break block17;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"1092", (Object)this, (Object[])new Object[0]);
                        if (mfStream == null) throw throwable;
                        try {
                            mfStream.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"1092", (Object)this, (Object[])new Object[0]);
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    mfStream.close();
                }
                catch (IOException mfStream) {
                    FFDCFilter.processException((Throwable)mfStream, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"1103", (Object)this, (Object[])new Object[0]);
                    isMR = Boolean.FALSE;
                }
            }
            this.isMultiRelease = isMR;
            return this.isMultiRelease;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected Map<String, ZipFileContainerUtils.IteratorData> getIteratorData() {
        String methodName = "getIteratorData";
        if (this.iteratorData == null) {
            IteratorDataLock iteratorDataLock = this.iteratorDataLock;
            synchronized (iteratorDataLock) {
                if (this.iteratorData == null) {
                    ZipFileContainerUtils.ZipEntryData[] useZipEntryData = this.getZipEntryData();
                    this.iteratorData = useZipEntryData.length == 0 ? Collections.emptyMap() : ZipFileContainerUtils.collectIteratorData(useZipEntryData);
                    Tr.debug((TraceComponent)tc, (String)(methodName + " [ " + Integer.valueOf(useZipEntryData.length) + " ] entries"), (Object[])new Object[0]);
                }
            }
        }
        return this.iteratorData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected ZipFileEntry createEntry(ArtifactContainer nestedContainer, String entryName, String a_entryPath, ZipFileContainerUtils.ZipEntryData useZipEntryData) {
        if (useZipEntryData != null && !useZipEntryData.isDirectory()) {
            return new ZipFileEntry(this, nestedContainer, useZipEntryData, entryName, a_entryPath);
        }
        NestedContainerEntriesLock nestedContainerEntriesLock = this.nestedContainerEntriesLock;
        synchronized (nestedContainerEntriesLock) {
            ZipFileEntry nestedContainerEntry = this.nestedContainerEntries.get(a_entryPath);
            if (nestedContainerEntry == null) {
                nestedContainerEntry = new ZipFileEntry(this, nestedContainer, useZipEntryData, entryName, a_entryPath);
                this.nestedContainerEntries.put(a_entryPath, nestedContainerEntry);
            }
            return nestedContainerEntry;
        }
    }

    @Trivial
    protected ZipFileEntry createEntry(String entryName, String a_entryPath, String r_entryPath) {
        ZipFileContainerUtils.ZipEntryData entryData;
        ZipFileContainerUtils.ZipEntryData[] useZipEntries = this.getZipEntryData();
        if (useZipEntries.length == 0) {
            return null;
        }
        int location = this.locatePath(r_entryPath);
        if (location < 0) {
            location = (location + 1) * -1;
            entryData = null;
        } else {
            entryData = useZipEntries[location];
        }
        return this.createEntry(null, entryName, a_entryPath, entryData);
    }

    @Trivial
    public Iterator<ArtifactEntry> iterator() {
        ZipFileContainerUtils.ZipEntryData[] useEntryData = this.getZipEntryData();
        if (useEntryData.length == 0) {
            return Collections.emptyIterator();
        }
        Map<String, ZipFileContainerUtils.IteratorData> allIteratorData = this.getIteratorData();
        ZipFileContainerUtils.IteratorData thisIteratorData = allIteratorData.get("");
        return new ZipFileContainerUtils.ZipFileEntryIterator(this, this, useEntryData, thisIteratorData);
    }

    @Trivial
    public ZipFileEntry getEntry(String path) {
        return this.getEntry(path, false);
    }

    public ZipFileEntry getEntry(String entryPath, boolean normalized) {
        ZipFileContainerUtils.ZipEntryData useZipEntryData;
        int location;
        String r_entryPath;
        String a_entryPath;
        ZipFileContainerUtils.ZipEntryData[] useEntryData = this.getZipEntryData();
        if (useEntryData.length == 0) {
            return null;
        }
        int pathLen = entryPath.length();
        if (pathLen == 0 || pathLen == 1 && entryPath.charAt(0) == '/') {
            return null;
        }
        if (entryPath.charAt(pathLen - 1) == '/') {
            entryPath = entryPath.substring(0, pathLen - 1);
            --pathLen;
        }
        if (entryPath.charAt(0) == '/') {
            a_entryPath = entryPath;
            r_entryPath = entryPath.substring(1);
        } else {
            a_entryPath = null;
            r_entryPath = entryPath;
        }
        if (this.isMultiRelease == null && !entryPath.startsWith("META-INF")) {
            this.initializeMultiRelease();
        }
        if ((location = this.locatePath(r_entryPath)) < 0 && !normalized) {
            pathLen = (entryPath = PathUtils.normalizeUnixStylePath((String)entryPath)).length();
            if (pathLen == 0 || pathLen == 1 && entryPath.charAt(0) == '/') {
                return null;
            }
            if (!PathUtils.isNormalizedPathAbsolute((String)entryPath)) {
                return null;
            }
            if (entryPath.charAt(0) == '/') {
                a_entryPath = entryPath;
                r_entryPath = entryPath.substring(1);
            } else {
                a_entryPath = null;
                r_entryPath = entryPath;
            }
            location = this.locatePath(r_entryPath);
        }
        if (location < 0) {
            if ((location = (location + 1) * -1) == useEntryData.length) {
                return null;
            }
            ZipFileContainerUtils.ZipEntryData nextEntryData = useEntryData[location];
            if (!this.isChildOf(r_entryPath, nextEntryData.r_getPath())) {
                return null;
            }
            useZipEntryData = null;
        } else {
            useZipEntryData = useEntryData[location];
        }
        String entryName = PathUtils.getName((String)entryPath);
        if (a_entryPath == null) {
            StringBuilder sb = new StringBuilder(entryPath.length() + 1);
            a_entryPath = sb.append('/').append(entryPath).toString();
        }
        return this.createEntry(null, entryName, a_entryPath, useZipEntryData);
    }

    public Collection<URL> getURLs() {
        File useArchiveFile = this.getArchiveFile();
        if (useArchiveFile == null) {
            return Collections.emptySet();
        }
        try {
            return Collections.singleton(this.archiveFileURI.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"1347", (Object)this, (Object[])new Object[0]);
            return Collections.emptySet();
        }
    }

    @Trivial
    protected URI createEntryUri(String r_entryPath) {
        File useArchiveFile = this.getArchiveFile();
        if (useArchiveFile == null) {
            return null;
        }
        return this.createEntryUri(r_entryPath, this.archiveFileURI);
    }

    URI createEntryUri(String r_entryPath, URI archiveUri) {
        if (archiveUri == null) {
            return null;
        }
        if (r_entryPath.isEmpty()) {
            return null;
        }
        String protocol = this.getProtocol();
        String archiveUriString = archiveUri.toString();
        String encodedEntryPath = ParserUtils.encode((String)r_entryPath);
        StringBuilder encodedUriBuilder = new StringBuilder(protocol.length() + archiveUriString.length() + encodedEntryPath.length() + 3);
        String encodedUriText = encodedUriBuilder.append(protocol).append(':').append(archiveUriString).append("!/").append(encodedEntryPath).toString();
        try {
            return new URI(encodedUriText);
        }
        catch (URISyntaxException uRISyntaxException) {
            FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"1411", (Object)this, (Object[])new Object[]{r_entryPath, archiveUri});
            return null;
        }
    }

    public ArtifactNotifier getArtifactNotifier() {
        return this.zipFileNotifier;
    }

    @Trivial
    private static URI getURI(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<URI>(){
            static final long serialVersionUID = -2791165519014855675L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public URI run() {
                return file.toURI();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$1", 1.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        });
    }

    @Trivial
    @FFDCIgnore(value={PrivilegedActionException.class})
    private static String getCanonicalPath(final File file) throws IOException {
        if (System.getSecurityManager() == null) {
            return file.getCanonicalPath();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                static final long serialVersionUID = 1854508427188805390L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() throws IOException {
                    return file.getCanonicalPath();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$2", 2.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtractionGuard placeExtractionGuard(String path) {
        boolean isPrimary;
        CountDownLatch completionLatch;
        Map<String, CountDownLatch> map = extractionLocks;
        synchronized (map) {
            completionLatch = extractionLocks.get(path);
            if (completionLatch != null) {
                isPrimary = false;
            } else {
                isPrimary = true;
                completionLatch = new CountDownLatch(1);
                extractionLocks.put(path, completionLatch);
            }
        }
        return new ExtractionGuard(path, isPrimary, completionLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseExtractionGuard(ExtractionGuard extractionLatch) {
        Map<String, CountDownLatch> map = extractionLocks;
        synchronized (map) {
            extractionLocks.remove(extractionLatch.path);
        }
        extractionLatch.completionLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractEntry(ArtifactEntry inputEntry, File outputDir) throws IOException {
        if (!FileUtils.ensureDirExists(outputDir)) {
            throw new IOException("Extraction directory could not be created [ " + outputDir.getAbsolutePath() + " ]");
        }
        File outputFile = new File(outputDir, inputEntry.getName());
        String outputPath = ZipFileContainer.getCanonicalPath(outputFile);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Extraction: [ " + outputPath + " ]"), (Object[])new Object[0]);
        }
        ExtractionGuard extractionGuard = this.placeExtractionGuard(outputPath);
        if (!extractionGuard.isPrimary) {
            if (!extractionGuard.waitForCompletion()) {
                Tr.warning((TraceComponent)tc, (String)"extract.secondary.timeout", (Object[])new Object[]{outputPath});
                throw new IOException("Secondary extraction timeout [ " + outputPath + " ]");
            }
            if (!FileUtils.fileExists(outputFile)) {
                Tr.warning((TraceComponent)tc, (String)"extract.secondary.failed", (Object[])new Object[]{outputPath});
                throw new IOException("Failed secondary extraction [ " + outputPath + " ]");
            }
            if (!FileUtils.fileIsFile(outputFile)) {
                Tr.warning((TraceComponent)tc, (String)"extract.secondary.notfile", (Object[])new Object[]{outputPath});
                throw new IOException("Secondary extraction did not create a simple file [ " + outputPath + " ]");
            }
            if (this.isModified(inputEntry, outputFile)) {
                Tr.warning((TraceComponent)tc, (String)"extract.secondary.inconsistent", (Object[])new Object[]{outputPath});
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Secondary extraction: [ " + outputPath + " ]"), (Object[])new Object[0]);
            }
            return outputFile;
        }
        try {
            long extractStart;
            String extractCase;
            boolean doExtract;
            boolean doRemove;
            if (FileUtils.fileExists(outputFile)) {
                if (FileUtils.fileIsFile(outputFile)) {
                    if (!this.isModified(inputEntry, outputFile)) {
                        doRemove = false;
                        doExtract = false;
                        extractCase = "Normal: Prior extraction is up to date";
                    } else {
                        doRemove = true;
                        doExtract = true;
                        extractCase = "Normal: Prior extraction is out of date";
                    }
                } else if (FileUtils.fileIsDirectory(outputFile)) {
                    doRemove = true;
                    doExtract = true;
                    extractCase = "Abnormal: Prior extraction is a directory";
                    Tr.warning((TraceComponent)tc, (String)"extract.primary.directory", (Object[])new Object[]{outputPath});
                } else {
                    doRemove = true;
                    doExtract = true;
                    extractCase = "Abnormal: Prior extraction is untyped";
                    Tr.warning((TraceComponent)tc, (String)"extract.primary.untyped", (Object[])new Object[]{outputPath});
                }
            } else {
                doRemove = false;
                doExtract = true;
                extractCase = "Normal: No prior extraction";
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Primary extraction: [ " + outputPath + " ] (" + extractCase + ")"), (Object[])new Object[0]);
            }
            long l = extractStart = COLLECT_TIMINGS ? System.nanoTime() : -1L;
            if (doRemove) {
                this.deleteAll(outputFile);
            }
            if (doExtract) {
                this.transfer(inputEntry, outputFile);
                this.setLastModified(inputEntry, outputFile, outputPath);
            }
            if (COLLECT_TIMINGS) {
                ZipFileContainer.record(Timings.EXTRACT_TIME, extractStart, System.nanoTime(), null, 10);
            }
            File file = outputFile;
            return file;
        }
        finally {
            this.releaseExtractionGuard(extractionGuard);
        }
    }

    private boolean isModified(ArtifactEntry entry, File file) {
        long entryLastModified;
        long fileLastModified = FileUtils.fileLastModified(file);
        return Math.abs(fileLastModified - (entryLastModified = entry.getLastModified())) >= 1010L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(ArtifactEntry inputEntry, File outputFile) throws IOException {
        InputStream inputStream = inputEntry.getInputStream();
        if (inputStream == null) {
            return;
        }
        try (FileOutputStream outputStream = FileUtils.getFileOutputStream(outputFile);){
            int bytesRead;
            byte[] transferBuffer = new byte[16384];
            while ((bytesRead = inputStream.read(transferBuffer)) > 0) {
                outputStream.write(transferBuffer, 0, bytesRead);
            }
        }
        finally {
            inputStream.close();
        }
    }

    private void setLastModified(ArtifactEntry inputEntry, File outputFile, String outputPath) {
        if (!FileUtils.fileSetLastModified(outputFile, inputEntry.getLastModified())) {
            Tr.error((TraceComponent)tc, (String)("Failed to set last modified [ " + outputPath + " ]"), (Object[])new Object[0]);
        }
    }

    @Trivial
    private boolean deleteAll(File rootFile) {
        int childCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Delete [ " + rootFile.getAbsolutePath() + " ]"), (Object[])new Object[0]);
        }
        if (FileUtils.fileIsFile(rootFile)) {
            boolean didDelete = FileUtils.fileDelete(rootFile);
            if (!didDelete) {
                Tr.error((TraceComponent)tc, (String)("Could not delete file [ " + rootFile.getAbsolutePath() + " ]"), (Object[])new Object[0]);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Deleted", (Object[])new Object[0]);
            }
            return didDelete;
        }
        boolean didDeleteAll = true;
        int deleteCount = 0;
        File[] childFiles = FileUtils.listFiles(rootFile);
        if (childFiles != null) {
            childCount = childFiles.length;
            for (File childFile : childFiles) {
                if (!this.deleteAll(childFile)) {
                    didDeleteAll = false;
                    continue;
                }
                ++deleteCount;
            }
        } else {
            childCount = 0;
            deleteCount = 0;
        }
        if (didDeleteAll) {
            didDeleteAll = FileUtils.fileDelete(rootFile);
        }
        if (!didDeleteAll) {
            Tr.error((TraceComponent)tc, (String)("Could not delete directory [ " + rootFile.getAbsolutePath() + " ]"), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deleted [ " + Integer.valueOf(deleteCount) + " ] of [ " + Integer.valueOf(childCount) + " ]"), (Object[])new Object[0]);
        }
        return didDeleteAll;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        long[] lArray = timingTotals = COLLECT_TIMINGS ? new long[Timings.values().length] : null;
        if (COLLECT_TIMINGS) {
            System.out.println("ZFC Timings Key");
            System.out.println("ZFC [ " + (Object)((Object)Timings.ARRAY_CREATE_TIME) + " ] [ Time creating the zip entry data array ]");
            System.out.println("ZFC [ " + (Object)((Object)Timings.MAP_CREATE_TIME) + " ] [ Time creating zip entry data map ]");
            System.out.println("ZFC [ " + (Object)((Object)Timings.ARRAY_LOOKUP_TIME) + " ] [ Time doing array lookups ]");
            System.out.println("ZFC [ " + (Object)((Object)Timings.MAP_LOOKUP_TIME) + " ] [ Time doing map lookups ]");
            System.out.println("ZFC [ " + (Object)((Object)Timings.EXTRACT_TIME) + " ] [ Time extracting nested containers ]");
        }
        CURRENT_JAVA_VERSION = JavaInfo.majorVersion();
        SecureAction privGet = (SecureAction)AccessController.doPrivileged(SecureAction.get());
        String mrProp = privGet.getProperty(JDK_DISABLE_MULTI_RELEASE_PROPERTY_NAME, JDK_DISABLE_MULTI_RELEASE_DEFAULT_VALUE);
        JDK_DISABLE_MULTI_RELEASE = "false".equalsIgnoreCase(mrProp);
        extractionLocks = new HashMap<String, CountDownLatch>();
    }

    private static enum Timings {
        ARRAY_CREATE_TIME,
        MAP_CREATE_TIME,
        ARRAY_LOOKUP_TIME,
        MAP_LOOKUP_TIME,
        EXTRACT_TIME;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class TimingsLock {
        static final long serialVersionUID = 8021893930679378320L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$TimingsLock", TimingsLock.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class MultiReleaseLock {
        static final long serialVersionUID = 8959987746349083329L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private MultiReleaseLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$MultiReleaseLock", MultiReleaseLock.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ZipFileHandleLock {
        static final long serialVersionUID = 577204417770381964L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ZipFileHandleLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$ZipFileHandleLock", ZipFileHandleLock.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class FastModeLock {
        static final long serialVersionUID = 7544944284472679774L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private FastModeLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$FastModeLock", FastModeLock.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ZipEntryDataLock {
        static final long serialVersionUID = 432860090457110279L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ZipEntryDataLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$ZipEntryDataLock", ZipEntryDataLock.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class IteratorDataLock {
        static final long serialVersionUID = -8492814183963259302L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private IteratorDataLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$IteratorDataLock", IteratorDataLock.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class NestedContainerEntriesLock {
        static final long serialVersionUID = -4671661208873605597L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private NestedContainerEntriesLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$NestedContainerEntriesLock", NestedContainerEntriesLock.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ArchiveFileLock {
        static final long serialVersionUID = 313863420221723326L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ArchiveFileLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$ArchiveFileLock", ArchiveFileLock.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ExtractionGuard {
        public final String path;
        public final boolean isPrimary;
        public final CountDownLatch completionLatch;
        static final long serialVersionUID = 5264434521593914875L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ExtractionGuard(String path, boolean isPrimary, CountDownLatch completionLatch) {
            this.path = path;
            this.isPrimary = isPrimary;
            this.completionLatch = completionLatch;
        }

        @FFDCIgnore(value={InterruptedException.class})
        public boolean waitForCompletion() {
            try {
                return this.completionLatch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$ExtractionGuard", ExtractionGuard.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
        }
    }
}

