/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.util;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class XmlSecurityUtil {
    private static final String SP_ALLOWED_PROTOCOLS = "org.apache.taglibs.standard.xml.accessExternalEntity";
    private static final String ALLOWED_PROTOCOLS = XmlSecurityUtil.initAllowedProtocols();

    private static String initAllowedProtocols() {
        String defaultProtocols = "";
        if (System.getSecurityManager() == null) {
            return System.getProperty(SP_ALLOWED_PROTOCOLS, "");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(XmlSecurityUtil.SP_ALLOWED_PROTOCOLS, "");
                }
            });
        }
        catch (AccessControlException e) {
            return "";
        }
    }

    public static void checkProtocol(String uri) {
        if ("all".equalsIgnoreCase(ALLOWED_PROTOCOLS)) {
            return;
        }
        String protocol = XmlSecurityUtil.getScheme(uri);
        for (String allowed : ALLOWED_PROTOCOLS.split(",")) {
            if (!allowed.trim().equalsIgnoreCase(protocol)) continue;
            return;
        }
        throw new AccessControlException("Access to external URI not allowed: " + uri);
    }

    private static String getScheme(CharSequence url) {
        StringBuilder scheme = new StringBuilder();
        for (int i = 0; i < url.length(); ++i) {
            String result;
            char ch = url.charAt(i);
            if (ch == ':' && !"jar".equals(result = scheme.toString())) {
                return result;
            }
            scheme.append(ch);
        }
        throw new IllegalArgumentException("No scheme found: " + url);
    }
}

