/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.microprofile.metrics.monitor.MonitorCounter;
import com.ibm.ws.microprofile.metrics.monitor.MonitorGauge;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MonitorMetrics {
    private static final TraceComponent tc = Tr.register(MonitorMetrics.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
    protected String objectName;
    private String mbeanStatsName;
    private MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private Set<String> metricNames;
    static final long serialVersionUID = -2315988316600056351L;

    public MonitorMetrics(String objectName) {
        this.objectName = objectName;
        this.metricNames = new HashSet<String>();
    }

    public void createMetrics(SharedMetricRegistries sharedMetricRegistry, String[][] data) {
        MetricRegistry registry = sharedMetricRegistry.getOrCreate(MetricRegistry.Type.VENDOR.getName());
        for (String[] metricData : data) {
            String metricName = this.getMetricName(metricData[0]);
            MetricType type = MetricType.valueOf((String)metricData[3]);
            if (MetricType.COUNTER.equals((Object)type)) {
                MonitorCounter mc = metricData[6] == null ? new MonitorCounter(this.mbs, this.objectName, metricData[5]) : new MonitorCounter(this.mbs, this.objectName, metricData[5], metricData[6]);
                registry.register(new Metadata(metricName, metricData[1], metricData[2], type, metricData[4]), (Metric)mc);
                this.metricNames.add(metricName);
                Tr.debug((TraceComponent)tc, (String)("Registered " + metricName), (Object[])new Object[0]);
                continue;
            }
            if (MetricType.GAUGE.equals((Object)type)) {
                MonitorGauge mg = metricData[6] == null ? new MonitorGauge(this.mbs, this.objectName, metricData[5]) : new MonitorGauge(this.mbs, this.objectName, metricData[5], metricData[6]);
                registry.register(new Metadata(metricName, metricData[1], metricData[2], type, metricData[4]), mg);
                this.metricNames.add(metricName);
                Tr.debug((TraceComponent)tc, (String)("Registered " + metricName), (Object[])new Object[0]);
                continue;
            }
            Tr.debug((TraceComponent)tc, (String)("Falied to register " + metricName + " because of invalid type " + type), (Object[])new Object[0]);
        }
    }

    private String getMBeanStatsString() {
        if (this.mbeanStatsName == null) {
            String serviceName = null;
            String serviceURL = null;
            String portName = null;
            String mbeanObjName = null;
            StringBuffer sb = new StringBuffer();
            for (String subString : this.objectName.split(",")) {
                if ((subString = subString.trim()).contains("service=")) {
                    serviceName = this.getMBeanStatsServiceName(subString);
                    serviceURL = this.getMBeanStatsServiceURL(subString);
                    continue;
                }
                if (subString.contains("port=")) {
                    portName = this.getMBeanStatsPortName(subString);
                    continue;
                }
                if (!subString.contains("name=")) continue;
                mbeanObjName = this.getMBeanStatsName(subString);
                break;
            }
            if (serviceURL != null && serviceName != null && portName != null) {
                sb.append(serviceURL);
                sb.append(".");
                sb.append(serviceName);
                sb.append(".");
                sb.append(portName);
            } else if (mbeanObjName != null) {
                sb.append(mbeanObjName);
            } else {
                sb.append("unknown");
            }
            this.mbeanStatsName = sb.toString();
        }
        return this.mbeanStatsName;
    }

    private String getMBeanStatsName(String nameStr) {
        String mbeanName = nameStr.split("=")[1];
        mbeanName = mbeanName.replaceAll(" ", "_");
        mbeanName = mbeanName.replaceAll("/", "_");
        mbeanName = mbeanName.replaceAll("[^a-zA-Z0-9_]", "_");
        return mbeanName;
    }

    private String getMBeanStatsServiceName(String serviceStr) {
        serviceStr = serviceStr.split("=")[1];
        serviceStr = serviceStr.replaceAll("\"", "");
        String serviceName = serviceStr.substring(serviceStr.indexOf("}") + 1);
        return serviceName;
    }

    private String getMBeanStatsServiceURL(String serviceStr) {
        serviceStr = serviceStr.split("=")[1];
        serviceStr = serviceStr.replaceAll("\"", "");
        String serviceURL = serviceStr.substring(serviceStr.indexOf("{") + 1, serviceStr.indexOf("}"));
        serviceURL = serviceURL.replace("http://", "").replace("https://", "").replace("/", ".");
        return serviceURL;
    }

    private String getMBeanStatsPortName(String portStr) {
        portStr = portStr.split("=")[1];
        String portName = portStr.replaceAll("\"", "");
        return portName;
    }

    private String getMetricName(String name) {
        return name.replace("%s", this.getMBeanStatsString());
    }

    public void unregisterMetrics(SharedMetricRegistries sharedMetricRegistry) {
        MetricRegistry registry = sharedMetricRegistry.getOrCreate(MetricRegistry.Type.VENDOR.getName());
        for (String metricName : this.metricNames) {
            boolean rc = registry.remove(metricName);
            Tr.debug((TraceComponent)tc, (String)("Unregistered " + metricName + " " + (rc ? "successfully" : "unsuccessfully")), (Object[])new Object[0]);
        }
        this.metricNames.clear();
    }
}

