/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.ejb;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ejbcontainer.EJBEndpoint;
import com.ibm.ws.ejbcontainer.EJBEndpoints;
import com.ibm.ws.ejbcontainer.EJBType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.ejb.EJBInJarEndpointInfo;
import com.ibm.ws.jaxrs20.ejb.EJBInfo;
import com.ibm.ws.jaxrs20.ejb.EJBUtils;
import com.ibm.ws.jaxrs20.ejb.internal.EjbProviderProxy;
import com.ibm.ws.jaxrs20.metadata.CXFJaxRsProviderResourceHolder;
import com.ibm.ws.jaxrs20.metadata.EndpointInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.jaxrs20.metadata.ProviderResourceInfo;
import com.ibm.ws.jaxrs20.utils.JaxRsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.message.Message;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.jaxrs20.ejb.JaxRsFactoryEJBBeanCustomizer", immediate=true, property={"service.vendor=IBM"})
public class JaxRsFactoryBeanEJBCustomizer
implements JaxRsFactoryBeanCustomizer {
    private static final TraceComponent tc = Tr.register(JaxRsFactoryBeanEJBCustomizer.class, (String)"JaxRs20EJB", (String)"com.ibm.ws.jaxrs20.ejb.internal.resources.JaxRsEJBMessages");
    private static final Set<String> SERVER_PROVIDER_CLASS_NAMES = new HashSet<String>();
    static final long serialVersionUID = 5364205421030506380L;

    public JaxRsFactoryBeanCustomizer.Priority getPriority() {
        return JaxRsFactoryBeanCustomizer.Priority.Medium;
    }

    public synchronized void onPrepareProviderResource(JaxRsFactoryBeanCustomizer.BeanCustomizerContext context) {
        HashMap<String, EJBInfo> ejbInfos;
        block10: {
            EndpointInfo endpointInfo = context.getEndpointInfo();
            String ejbModuleName = null;
            if (endpointInfo instanceof EJBInJarEndpointInfo) {
                ejbModuleName = ((EJBInJarEndpointInfo)endpointInfo).getEJBModuleName();
            }
            JaxRsModuleMetaData moduleMetaData = context.getModuleMetaData();
            ejbInfos = new HashMap<String, EJBInfo>();
            Set perRequestProviderAndPathInfos = endpointInfo.getPerRequestProviderAndPathInfos();
            Set singletonProviderAndPathInfos = endpointInfo.getSingletonProviderAndPathInfos();
            Iterator<ProviderResourceInfo> perRequestIterator = perRequestProviderAndPathInfos.iterator();
            Iterator<ProviderResourceInfo> singletonIterator = singletonProviderAndPathInfos.iterator();
            try {
                EJBEndpoints ejbEndpoints = (EJBEndpoints)moduleMetaData.getModuleContainer().adapt(EJBEndpoints.class);
                ArrayList<EJBEndpoint> ejbEndpointList = new ArrayList<EJBEndpoint>();
                ejbEndpointList.addAll(ejbEndpoints.getEJBEndpoints());
                for (EJBEndpoint ejbEndpoint : ejbEndpointList) {
                    HashMap<String, String> methodToJNDI = new HashMap<String, String>();
                    HashMap<String, Object> ejbCache = new HashMap<String, Object>();
                    String ejbClassName = ejbEndpoint.getClassName();
                    String ejbName = ejbEndpoint.getName();
                    List localInterfaceNameList = ejbEndpoint.getLocalBusinessInterfaceNames();
                    EJBInfo ejbInfo = new EJBInfo(ejbClassName, ejbName, ejbEndpoint.getEJBType(), methodToJNDI, ejbCache, localInterfaceNameList, ejbModuleName);
                    ejbInfos.put(ejbClassName, ejbInfo);
                    if (localInterfaceNameList.size() == 0) {
                        Method[] methods = Thread.currentThread().getContextClassLoader().loadClass(ejbClassName).getMethods();
                        String jndiName = this.getJNDIName(ejbEndpoint, null, ejbModuleName);
                        for (Method m : methods) {
                            String implBeanMthod = EJBUtils.methodToString(m);
                            methodToJNDI.put(implBeanMthod, jndiName);
                        }
                        continue;
                    }
                    for (String localInterfaceName : localInterfaceNameList) {
                        Method[] localInterfaceMethods;
                        Class<?> localInterface = moduleMetaData.getAppContextClassLoader().loadClass(localInterfaceName);
                        for (Method localInterfaceMethod : localInterfaceMethods = localInterface.getMethods()) {
                            String localInterfaceMethodToString = EJBUtils.methodToString(localInterfaceMethod);
                            String jndiName = this.getJNDIName(ejbEndpoint, localInterfaceName, ejbModuleName);
                            methodToJNDI.put(localInterfaceMethodToString, jndiName);
                        }
                    }
                }
                CXFJaxRsProviderResourceHolder cxfPRHolder = context.getCxfRPHolder();
                this.findEJBClass(cxfPRHolder, ejbEndpointList, perRequestIterator, true);
                this.findEJBClass(cxfPRHolder, ejbEndpointList, singletonIterator, false);
                this.handleAbstractClassInterface(cxfPRHolder, moduleMetaData, ejbEndpointList, endpointInfo.getAbstractClassInterfaceList(), perRequestProviderAndPathInfos, singletonProviderAndPathInfos, ejbModuleName);
            }
            catch (UnableToAdaptException ejbEndpoints) {
                FFDCFilter.processException((Throwable)ejbEndpoints, (String)"com.ibm.ws.jaxrs20.ejb.JaxRsFactoryBeanEJBCustomizer", (String)"143", (Object)this, (Object[])new Object[]{context});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to get EJBEndpoints due to adapt failed", (Object[])new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.ejb.JaxRsFactoryBeanEJBCustomizer", (String)"147", (Object)this, (Object[])new Object[]{context});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)("Failed to load EJB class " + e.toString()), (Object[])new Object[0]);
            }
        }
        context.setContextObject(ejbInfos);
    }

    private void handleAbstractClassInterface(CXFJaxRsProviderResourceHolder cxfPRHolder, JaxRsModuleMetaData moduleMetaData, List<EJBEndpoint> ejbEndpointList, List<String> abstractClassInterfaceList, Set<ProviderResourceInfo> perRequestProviderAndPathInfos, Set<ProviderResourceInfo> singletonProviderAndPathInfos, String ejbModuleName) {
        for (String abstractClassInterfaceName : abstractClassInterfaceList) {
            for (int i = 0; i < ejbEndpointList.size(); ++i) {
                EJBEndpoint ejbEndpoint = ejbEndpointList.get(i);
                EJBType ejbType = ejbEndpoint.getEJBType();
                if (!ejbType.equals((Object)EJBType.SINGLETON_SESSION) && !ejbType.equals((Object)EJBType.STATELESS_SESSION)) continue;
                String ejbClassName = ejbEndpoint.getClassName();
                List interfaceNames = ejbEndpoint.getLocalBusinessInterfaceNames();
                if (!interfaceNames.contains(abstractClassInterfaceName)) continue;
                String jndiName = this.getJNDIName(ejbEndpoint, abstractClassInterfaceName, ejbModuleName);
                this.addResourceProvider(moduleMetaData, jndiName, cxfPRHolder, ejbType, abstractClassInterfaceName, ejbClassName, perRequestProviderAndPathInfos, singletonProviderAndPathInfos);
            }
        }
    }

    public boolean isCustomizableBean(Class<?> clazz, Object context) {
        if (context == null) {
            return false;
        }
        Map ejbInfos = (Map)context;
        EJBInfo ejbInfo = (EJBInfo)ejbInfos.get(clazz.getName());
        if (ejbInfo != null) {
            return true;
        }
        Iterator iterator = ejbInfos.entrySet().iterator();
        while (iterator.hasNext()) {
            List<String> localInterfaceNameList = ((EJBInfo)iterator.next().getValue()).getLocalInterfaceNameList();
            if (!localInterfaceNameList.contains(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public <T> T onSingletonProviderInit(T provider, Object context, Message m) {
        if (context == null) {
            return null;
        }
        Map ejbInfos = (Map)context;
        EJBInfo ejbInfo = (EJBInfo)ejbInfos.get(provider.getClass().getName());
        String ejbName = ejbInfo.getEjbName();
        String ejbModuleName = ejbInfo.getEjbModuleName();
        List<String> ejbLocalInterfaces = ejbInfo.getLocalInterfaceNameList();
        EjbProviderProxy providerProxy = new EjbProviderProxy(ServerProviderFactory.getInstance((Message)m).createExceptionMapper(EJBException.class, m) != null, ejbName, ejbLocalInterfaces, ejbModuleName);
        Object returnedObj = providerProxy.createEjbProviderObject(provider);
        if (ejbInfo.getEjbType().equals((Object)EJBType.STATELESS_SESSION)) {
            Tr.warning((TraceComponent)tc, (String)"warning.jaxrs.ejb.provider.mismatch", (Object[])new Object[]{provider.getClass().getName(), "STATELESS", "EJB"});
        }
        return (T)(returnedObj == null ? provider : returnedObj);
    }

    public <T> T onSingletonServiceInit(T service, Object context) {
        return service;
    }

    public <T> T beforeServiceInvoke(T serviceObject, boolean isSingleton, Object context) {
        return serviceObject;
    }

    @FFDCIgnore(value={NamingException.class, Exception.class, Exception.class})
    public Object serviceInvoke(Object serviceObject, Method m, Object[] params, boolean isSingleton, Object context, Message inMessage) throws Exception {
        Map ejbInfos = (Map)context;
        EJBInfo ejbInfo = (EJBInfo)ejbInfos.get(serviceObject.getClass().getName());
        if (ejbInfo == null) {
            return serviceObject;
        }
        String jndiKey = EJBUtils.methodToString(m);
        String jndiName = ejbInfo.getMethodToJNDI().get(jndiKey);
        if (jndiName == null) {
            return m.invoke(serviceObject, params);
        }
        Object ejbServiceObject = null;
        ejbServiceObject = ejbInfo.getEjbInstanceCache().get(jndiName);
        if (null == ejbServiceObject) {
            try {
                ejbServiceObject = new InitialContext().lookup(jndiName);
                ejbInfo.getEjbInstanceCache().put(jndiName, ejbServiceObject);
                if (ejbInfo.getEjbType().equals((Object)EJBType.SINGLETON_SESSION) && !isSingleton) {
                    Tr.warning((TraceComponent)tc, (String)"warning.jaxrs.ejb.resource.mismatch", (Object[])new Object[]{serviceObject.getClass().getName(), "PERREQUEST", "SINGLETON", "EJB"});
                }
                if (ejbInfo.getEjbType().equals((Object)EJBType.STATELESS_SESSION) && isSingleton) {
                    Tr.warning((TraceComponent)tc, (String)"warning.jaxrs.ejb.resource.mismatch", (Object[])new Object[]{serviceObject.getClass().getName(), "SINGLETON", "STATELESS", "EJB"});
                }
            }
            catch (NamingException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Couldn't get instance for " + serviceObject.getClass().getName() + " through JNDI: " + jndiName + ", will use JAX-RS instance."), (Object[])new Object[0]);
                }
                return null;
            }
        }
        if (null != ejbServiceObject) {
            if (jndiName.indexOf("!") > 0) {
                Method method = null;
                String interfaceName = jndiName.substring(jndiName.lastIndexOf("!") + 1);
                Class<?> clazzInerface = null;
                clazzInerface = Thread.currentThread().getContextClassLoader().loadClass(interfaceName);
                for (Method inteM : clazzInerface.getMethods()) {
                    if (!EJBUtils.matchMethod(inteM, m)) continue;
                    method = inteM;
                    break;
                }
                if (method != null) {
                    try {
                        return method.invoke(clazzInerface.cast(ejbServiceObject), params);
                    }
                    catch (Exception e) {
                        Exception causedByException;
                        List<Class<?>> exceptionTypes = Arrays.asList(m.getExceptionTypes());
                        boolean ejbExceptionMapped = ServerProviderFactory.getInstance((Message)inMessage).createExceptionMapper(EJBException.class, inMessage) != null;
                        Throwable causeException = e.getCause();
                        Class<?> exceptionClass = causeException.getClass();
                        if (ejbExceptionMapped) {
                            Exception causedByException2;
                            if (EJBException.class.equals(exceptionClass) && (causedByException2 = ((EJBException)e.getCause()).getCausedByException()) != null && exceptionTypes.contains(causedByException2.getClass())) {
                                throw causedByException2;
                            }
                        } else if (EJBException.class.isAssignableFrom(exceptionClass) && (causedByException = ((EJBException)e.getCause()).getCausedByException()) != null) {
                            throw causedByException;
                        }
                        if (e instanceof InvocationTargetException) {
                            throw (Exception)causeException;
                        }
                        throw e;
                    }
                }
                return null;
            }
            try {
                return m.invoke(ejbServiceObject, params);
            }
            catch (Exception e) {
                Exception causedByException;
                List<Class<?>> exceptionTypes = Arrays.asList(m.getExceptionTypes());
                boolean ejbExceptionMapped = ServerProviderFactory.getInstance((Message)inMessage).createExceptionMapper(EJBException.class, inMessage) != null;
                Throwable causeException = e.getCause();
                Class<?> exceptionClass = causeException.getClass();
                if (ejbExceptionMapped) {
                    Exception causedByException3;
                    if (EJBException.class.equals(exceptionClass) && (causedByException3 = ((EJBException)e.getCause()).getCausedByException()) != null && exceptionTypes.contains(causedByException3.getClass())) {
                        throw causedByException3;
                    }
                } else if (EJBException.class.isAssignableFrom(exceptionClass) && (causedByException = ((EJBException)e.getCause()).getCausedByException()) != null) {
                    throw causedByException;
                }
                if (e instanceof InvocationTargetException) {
                    throw (Exception)causeException;
                }
                throw e;
            }
        }
        return null;
    }

    public void afterServiceInvoke(Object serviceObject, boolean isSingleton, Object context) {
    }

    private String getJNDIName(EJBEndpoint ejbEndpoint, String interfaceName, String ejbModuleName) {
        StringBuffer jndiName;
        String beanName = ejbEndpoint.getName();
        StringBuffer stringBuffer = jndiName = ejbModuleName == null ? new StringBuffer("java:module/").append(beanName) : new StringBuffer("java:app/").append(ejbModuleName + "/").append(beanName);
        if (interfaceName != null && !interfaceName.trim().equals("")) {
            jndiName.append("!").append(interfaceName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("jndi name is" + jndiName.toString()), (Object[])new Object[0]);
        }
        return jndiName.toString();
    }

    private void findEJBClass(CXFJaxRsProviderResourceHolder cxfPRHolder, List<EJBEndpoint> ejbEndpointList, Iterator<ProviderResourceInfo> providerResourceInfoIterator, Boolean perRequest) {
        while (providerResourceInfoIterator.hasNext()) {
            ProviderResourceInfo providerResourceInfo = providerResourceInfoIterator.next();
            if (providerResourceInfo.getRuntimeType() != ProviderResourceInfo.RuntimeType.POJO) continue;
            String className = providerResourceInfo.getClassName();
            for (int i = 0; i < ejbEndpointList.size(); ++i) {
                EJBEndpoint ejbEndpoint = ejbEndpointList.get(i);
                EJBType ejbType = ejbEndpoint.getEJBType();
                if (!ejbType.equals((Object)EJBType.SINGLETON_SESSION) && !ejbType.equals((Object)EJBType.STATELESS_SESSION)) continue;
                String ejbClassName = ejbEndpoint.getClassName();
                List interfaceNames = ejbEndpoint.getLocalBusinessInterfaceNames();
                if (ejbClassName.equals(className)) {
                    providerResourceInfo.setRuntimeType(ProviderResourceInfo.RuntimeType.EJB);
                    providerResourceInfo.putCustomizedProperty("EJBType", (Object)ejbType);
                    ejbEndpoint.getLocalBusinessInterfaceNames();
                    this.resetCXFHolder(providerResourceInfo, cxfPRHolder, perRequest, ejbType, className);
                    continue;
                }
                if (!interfaceNames.contains(className)) continue;
                providerResourceInfo.setRuntimeType(ProviderResourceInfo.RuntimeType.EJB);
                providerResourceInfo.putCustomizedProperty("EJBType", (Object)ejbType);
                this.resetCXFHolder(providerResourceInfo, cxfPRHolder, perRequest, ejbType, className);
            }
        }
    }

    public Application onApplicationInit(Application app, JaxRsModuleMetaData metaData) {
        String appClassName = app.getClass().getName();
        if (appClassName.equals("javax.ws.rs.core.Application")) {
            return app;
        }
        if (app.getClass().getInterfaces().length > 0) {
            return app;
        }
        Application ejbInstance = null;
        String ejbModuleName = null;
        try {
            if (JaxRsUtils.isEJBModule((Container)metaData.getModuleContainer())) {
                ejbModuleName = metaData.getModuleInfo().getName();
            }
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxrs20.ejb.JaxRsFactoryBeanEJBCustomizer", (String)"447", (Object)this, (Object[])new Object[]{app, metaData});
        }
        try {
            EJBEndpoints ejbEndpoints = (EJBEndpoints)metaData.getModuleContainer().adapt(EJBEndpoints.class);
            ArrayList ejbEndpointList = new ArrayList();
            ejbEndpointList.addAll(ejbEndpoints.getEJBEndpoints());
            for (int i = 0; i < ejbEndpointList.size(); ++i) {
                EJBEndpoint ejbEndpoint = (EJBEndpoint)ejbEndpointList.get(i);
                EJBType ejbType = ejbEndpoint.getEJBType();
                if (ejbType != EJBType.SINGLETON_SESSION && ejbType != EJBType.STATELESS_SESSION) continue;
                String ejbClassName = ejbEndpoint.getClassName();
                String jndiName = null;
                if (!appClassName.equals(ejbClassName)) continue;
                jndiName = this.getJNDIName(ejbEndpoint, null, ejbModuleName);
                ejbInstance = (Application)new InitialContext().lookup(jndiName);
                break;
            }
        }
        catch (UnableToAdaptException ejbEndpointList) {
            FFDCFilter.processException((Throwable)ejbEndpointList, (String)"com.ibm.ws.jaxrs20.ejb.JaxRsFactoryBeanEJBCustomizer", (String)"475", (Object)this, (Object[])new Object[]{app, metaData});
            return app;
        }
        catch (NamingException e1) {
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.jaxrs20.ejb.JaxRsFactoryBeanEJBCustomizer", (String)"477", (Object)this, (Object[])new Object[]{app, metaData});
            return app;
        }
        return ejbInstance == null ? app : ejbInstance;
    }

    @FFDCIgnore(value={IllegalAccessException.class, InstantiationException.class})
    private void resetCXFHolder(ProviderResourceInfo providerResourceInfo, CXFJaxRsProviderResourceHolder cxfPRHolder, Boolean perRequest, EJBType ejbType, String className) {
        if (!providerResourceInfo.isJaxRsProvider()) {
            if (ejbType.equals((Object)EJBType.SINGLETON_SESSION) && perRequest.booleanValue()) {
                try {
                    Object po = providerResourceInfo.getProviderResourceClass().newInstance();
                    providerResourceInfo.setObject(po);
                    cxfPRHolder.removeResouceProvider(providerResourceInfo.getProviderResourceClass());
                    cxfPRHolder.addResouceProvider(providerResourceInfo.getProviderResourceClass(), (ResourceProvider)new SingletonResourceProvider(po));
                }
                catch (IllegalAccessException e) {
                    Tr.warning((TraceComponent)tc, (String)"warning.failed.instantiate.ejb.instance", (Object[])new Object[]{providerResourceInfo.getProviderResourceClass().getName()});
                    providerResourceInfo.setRuntimeType(ProviderResourceInfo.RuntimeType.POJO);
                    providerResourceInfo.removeCustomizedProperty("EJBType");
                }
                catch (InstantiationException e) {
                    Tr.warning((TraceComponent)tc, (String)"warning.failed.instantiate.ejb.instance", (Object[])new Object[]{providerResourceInfo.getProviderResourceClass().getName()});
                    providerResourceInfo.setRuntimeType(ProviderResourceInfo.RuntimeType.POJO);
                    providerResourceInfo.removeCustomizedProperty("EJBType");
                }
            }
            if (ejbType.equals((Object)EJBType.STATELESS_SESSION) && !perRequest.booleanValue()) {
                cxfPRHolder.removeResouceProvider(providerResourceInfo.getProviderResourceClass());
                cxfPRHolder.addResouceProvider(providerResourceInfo.getProviderResourceClass(), (ResourceProvider)new PerRequestResourceProvider(providerResourceInfo.getProviderResourceClass()));
            }
        }
    }

    @FFDCIgnore(value={IllegalAccessException.class, InstantiationException.class})
    private void addResourceProvider(JaxRsModuleMetaData moduleMetaData, String jndiName, CXFJaxRsProviderResourceHolder cxfPRHolder, EJBType ejbType, String abstractClassInterfaceName, String ejbClassName, Set<ProviderResourceInfo> perRequestProviderAndPathInfos, Set<ProviderResourceInfo> singletonProviderAndPathInfos) {
        try {
            ProviderResourceInfo providerResourceInfo;
            Object po;
            Class<?> ejbClazz = moduleMetaData.getAppContextClassLoader().loadClass(ejbClassName);
            Class<?> abstractClassInterfaceClazz = moduleMetaData.getAppContextClassLoader().loadClass(abstractClassInterfaceName);
            if (JaxRsFactoryBeanEJBCustomizer.isValidResource(abstractClassInterfaceClazz)) {
                if (ejbType.equals((Object)EJBType.SINGLETON_SESSION)) {
                    po = ejbClazz.newInstance();
                    cxfPRHolder.addResourceClasses(abstractClassInterfaceClazz);
                    cxfPRHolder.addAbstractResourceMapItem(abstractClassInterfaceClazz, ejbClazz);
                    cxfPRHolder.addResouceProvider(abstractClassInterfaceClazz, (ResourceProvider)new SingletonResourceProvider(po));
                    providerResourceInfo = new ProviderResourceInfo(po, true, false);
                    providerResourceInfo.setRuntimeType(ProviderResourceInfo.RuntimeType.EJB);
                    providerResourceInfo.putCustomizedProperty("EJBType", (Object)ejbType);
                    singletonProviderAndPathInfos.add(providerResourceInfo);
                }
                if (ejbType.equals((Object)EJBType.STATELESS_SESSION)) {
                    cxfPRHolder.addResourceClasses(abstractClassInterfaceClazz);
                    cxfPRHolder.addAbstractResourceMapItem(abstractClassInterfaceClazz, ejbClazz);
                    cxfPRHolder.addResouceProvider(abstractClassInterfaceClazz, (ResourceProvider)new PerRequestResourceProvider(ejbClazz));
                    ProviderResourceInfo providerResourceInfo2 = new ProviderResourceInfo(ejbClazz, true, false);
                    providerResourceInfo2.setRuntimeType(ProviderResourceInfo.RuntimeType.EJB);
                    providerResourceInfo2.putCustomizedProperty("EJBType", (Object)ejbType);
                    perRequestProviderAndPathInfos.add(providerResourceInfo2);
                }
            }
            if (JaxRsFactoryBeanEJBCustomizer.isValidProvider(abstractClassInterfaceClazz)) {
                po = ejbClazz.newInstance();
                cxfPRHolder.addProvider(po);
                providerResourceInfo = JaxRsFactoryBeanEJBCustomizer.isValidResource(ejbClazz) ? new ProviderResourceInfo(po, true, true) : new ProviderResourceInfo(po, true, false);
                providerResourceInfo.setRuntimeType(ProviderResourceInfo.RuntimeType.EJB);
                providerResourceInfo.putCustomizedProperty("EJBType", (Object)ejbType);
                singletonProviderAndPathInfos.add(providerResourceInfo);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxrs20.ejb.JaxRsFactoryBeanEJBCustomizer", (String)"568", (Object)this, (Object[])new Object[]{moduleMetaData, jndiName, cxfPRHolder, ejbType, abstractClassInterfaceName, ejbClassName, perRequestProviderAndPathInfos, singletonProviderAndPathInfos});
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    public static boolean isValidResource(Class<?> c) {
        if (c == null || c == Object.class) {
            return false;
        }
        if (c.getAnnotation(Path.class) != null) {
            return true;
        }
        if (c.getInterfaces() != null) {
            for (Class<?> ci : c.getInterfaces()) {
                if (!JaxRsFactoryBeanEJBCustomizer.isValidResource(ci)) continue;
                return true;
            }
        }
        return JaxRsFactoryBeanEJBCustomizer.isValidResource(c.getSuperclass());
    }

    public static boolean isValidProvider(Class<?> c) {
        if (c == null || c == Object.class) {
            return false;
        }
        if (c.getAnnotation(Provider.class) != null) {
            return true;
        }
        for (Class<?> itf : c.getInterfaces()) {
            if (!SERVER_PROVIDER_CLASS_NAMES.contains(itf.getName())) continue;
            return true;
        }
        return JaxRsFactoryBeanEJBCustomizer.isValidProvider(c.getSuperclass());
    }

    public <T> T onSetupProviderProxy(T provider, Object contextObject) {
        return null;
    }

    public void destroyApplicationScopeResources(JaxRsModuleMetaData jaxRsModuleMetaData) {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.MessageBodyWriter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.MessageBodyReader");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ExceptionMapper");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ContextResolver");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ReaderInterceptor");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.WriterInterceptor");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ParamConverterProvider");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.ContainerRequestFilter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.ContainerResponseFilter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.DynamicFeature");
        SERVER_PROVIDER_CLASS_NAMES.add("org.apache.cxf.jaxrs.ext.ContextResolver");
    }
}

