/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal.naming;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.naming.LocalColonEJBNamingHelper;
import com.ibm.ws.ejbcontainer.osgi.EJBHomeRuntime;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBBinding;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBNamingInstancer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NamingException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={LocalColonEJBNamingHelper.class, LocalColonEJBNamingHelperImpl.class})
public class LocalColonEJBNamingHelperImpl
extends EJBNamingInstancer
implements LocalColonEJBNamingHelper<EJBBinding> {
    private static final TraceComponent tc = Tr.register(LocalColonEJBNamingHelperImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final HashMap<String, EJBBinding> localColonEJBBindings = new HashMap();
    private final ReentrantReadWriteLock javaColonLock = new ReentrantReadWriteLock();
    static final long serialVersionUID = 7536514625953710177L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(String name) throws NamingException {
        EJBBinding binding;
        ReentrantReadWriteLock.ReadLock readLock = this.javaColonLock.readLock();
        readLock.lock();
        try {
            binding = this.localColonEJBBindings.get(name);
        }
        finally {
            readLock.unlock();
        }
        if (binding != null && binding.isAmbiguousReference) {
            this.throwAmbiguousEJBReferenceException(binding, name);
        }
        return this.initializeEJB(binding, "local:" + name);
    }

    @Reference(service=EJBHomeRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = true;
    }

    protected void unsetEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public synchronized boolean bind(EJBBinding binding, String name, boolean isSimpleName, boolean isDefaultBinding) throws NamingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        boolean notAmbiguous = true;
        EJBBinding newBinding = new EJBBinding(binding.homeRecord, binding.interfaceName, binding.interfaceIndex, binding.isLocal);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("bind: " + name), (Object[])new Object[0]);
        }
        EJBBinding previousBinding = this.localColonEJBBindings.get(name);
        if (isSimpleName) {
            newBinding.setAmbiguousReference();
            notAmbiguous = false;
        }
        if (previousBinding != null) {
            if (isDefaultBinding) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"found ambiguous default binding", (Object[])new Object[0]);
                }
            } else {
                OnErrorUtil.OnError onError = ContainerProperties.customBindingsOnErr;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("found ambiguous binding and customBindingsOnErr=" + onError.toString()), (Object[])new Object[0]);
                }
                BeanMetaData bmd = newBinding.homeRecord.getBeanMetaData();
                BeanMetaData oldbmd = previousBinding.homeRecord.getBeanMetaData();
                switch (onError) {
                    case WARN: {
                        Tr.warning((TraceComponent)tc, (String)"NAME_ALREADY_BOUND_WARN_CNTR0338W", (Object[])new Object[]{newBinding.interfaceName, bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication(), name, previousBinding.interfaceName, oldbmd.j2eeName.getComponent(), oldbmd.j2eeName.getModule(), oldbmd.j2eeName.getApplication()});
                        break;
                    }
                    case FAIL: {
                        Tr.error((TraceComponent)tc, (String)"NAME_ALREADY_BOUND_WARN_CNTR0338W", (Object[])new Object[]{newBinding.interfaceName, bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication(), name, previousBinding.interfaceName, oldbmd.j2eeName.getComponent(), oldbmd.j2eeName.getModule(), oldbmd.j2eeName.getApplication()});
                        throw new NamingException("The " + newBinding.interfaceName + " interface of the " + bmd.j2eeName.getComponent() + " bean in the " + bmd.j2eeName.getModule() + " module of the application cannot be bound to " + name + ", a bean is already bound to that location.");
                    }
                    case IGNORE: {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"customBindingsOnErr is IGNORE, not binding", (Object[])new Object[0]);
                        }
                        return false;
                    }
                }
            }
            newBinding.setAmbiguousReference();
            newBinding.addJ2EENames(previousBinding.getJ2EENames());
            notAmbiguous = false;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            this.localColonEJBBindings.put(name, newBinding);
        }
        finally {
            writeLock.unlock();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("bind: notAmbiguous = " + notAmbiguous));
        }
        return notAmbiguous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public void unbind(String name) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("unbinding: " + name), (Object[])new Object[0]);
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            this.localColonEJBBindings.remove(name);
        }
        finally {
            writeLock.unlock();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unbind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBindings(List<String> names) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            for (String name : names) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("unbinding: " + name), (Object[])new Object[0]);
                }
                this.localColonEJBBindings.remove(name);
            }
        }
        finally {
            writeLock.unlock();
        }
    }
}

