/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal.injection;

import com.ibm.ejs.container.EJBLinkResolver;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ejbcontainer.EJBFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ejbcontainer.osgi.EJBHomeRuntime;
import com.ibm.ws.ejbcontainer.osgi.internal.EJBRuntimeImpl;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={EJBFactory.class})
public class OSGiEJBFactoryImpl
extends EJBLinkResolver {
    private static final TraceComponent tc = Tr.register(OSGiEJBFactoryImpl.class, (String)"EJBContainer", (String)"com.ibm.ws.ejbcontainer.osgi.internal.resources.EJBContainerMessages");
    private static final String REFERENCE_RUNTIME = "runtime";
    private J2EENameFactory j2eeNameFactory;
    private volatile boolean homeRuntime;
    private final AtomicServiceReference<EJBRuntimeImpl> runtimeSR = new AtomicServiceReference("runtime");
    static final long serialVersionUID = 6607425899991647141L;

    @Reference(service=LibertyProcess.class, target="(wlp.process.type=server)")
    protected void setLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    protected void unsetLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    @Reference
    protected void setJ2EENameFactory(J2EENameFactory ref) {
        this.j2eeNameFactory = ref;
    }

    protected void unsetJ2EENameFactory(J2EENameFactory ref) {
    }

    @Reference(service=EJBHomeRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = true;
    }

    protected void unsetEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = false;
    }

    @Reference(name="runtime", service=EJBRuntimeImpl.class)
    protected void setRuntime(ServiceReference<EJBRuntimeImpl> reference) {
        this.runtimeSR.setReference(reference);
    }

    protected void unsetRuntime(ServiceReference<EJBRuntimeImpl> reference) {
        this.runtimeSR.unsetReference(reference);
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        this.runtimeSR.activate(cc);
        this.runtimeSR.getServiceWithException();
        this.initialize(EJSContainer.homeOfHomes, this.j2eeNameFactory);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.runtimeSR.deactivate(cc);
    }

    @Override
    public void checkHomeSupported(EJSHome home, String homeInterface) throws EJBNotFoundException {
        if (!this.homeRuntime) {
            J2EEName j2eeName = home.getJ2EEName();
            String appName = j2eeName.getApplication();
            String moduleName = j2eeName.getModule();
            String ejbName = j2eeName.getComponent();
            String msgTxt = Tr.formatMessage((TraceComponent)tc, (String)"INJECTION_CANNOT_INSTANTIATE_HOME_CNTR4011E", (Object[])new Object[]{homeInterface, ejbName, moduleName, appName});
            throw new EJBNotFoundException(msgTxt);
        }
    }
}

