/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.passivator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.passivator.EJBObjectInfo;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.SessionBeanStore;
import com.ibm.websphere.csi.StreamUnavailableException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.failover.SfFailoverCache;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.managedobject.ManagedObjectContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class StatefulPassivator {
    private static final TraceComponent tc = Tr.register(StatefulPassivator.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.passivator.StatefulPassivator";
    private final SessionBeanStore ivBeanStore;
    protected final EJSContainer ivContainer;
    private boolean ivTerminating = false;
    private final Object ivActivateLock;
    private final Object ivPassivateLock;
    private final Object ivRemoveLock;
    private final SfFailoverCache ivStatefulFailoverCache;

    public StatefulPassivator(SessionBeanStore beanStore, EJSContainer container2, SfFailoverCache failoverCache) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"StatefulPassivator", (Object[])new Object[0]);
        }
        this.ivBeanStore = beanStore;
        this.ivContainer = container2;
        this.ivStatefulFailoverCache = failoverCache;
        this.ivActivateLock = new Object();
        this.ivPassivateLock = new Object();
        this.ivRemoveLock = new Object();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"StatefulPassivator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void passivate(StatefulBeanO beanO, BeanMetaData bmd) throws RemoteException {
        block41: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && StatefulPassivator.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)StatefulPassivator.tc, (String)("passivate: " + beanO), (Object[])new Object[0]);
            }
            if (beanO.isRemoved() || this.isTerminating()) {
                if (isTraceOn == false) return;
                if (StatefulPassivator.tc.isEventEnabled() == false) return;
                Tr.event((TraceComponent)StatefulPassivator.tc, (String)"Bean removed!", (Object[])new Object[0]);
                return;
            }
            bid = beanO.getId();
            sb = beanO.ivEjbInstance;
            exceptionCaught = false;
            beanStream = null;
            credToken = this.ivContainer.getEJBRuntime().pushServerIdentity();
            beanStream2 = null;
            exPC = beanO.getJPAExPcBindingContext();
            baos = null;
            lastAccessTime = beanO.getLastAccessTime();
            var14_16 = this.ivPassivateLock;
            synchronized (var14_16) {
                block42: {
                    if (!beanO.sfsbFailoverEnabled()) ** break block40
                    if (isTraceOn && StatefulPassivator.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)StatefulPassivator.tc, (String)"failover is enabled", (Object[])new Object[0]);
                    }
                    if (this.getEJBModuleVersion(beanO) < 30) break block42;
                    baos = new ByteArrayOutputStream(1024);
                    beanStream = this.createPassivationOutputStream(new GZIPOutputStream((OutputStream)baos));
                    ** GOTO lbl62
                }
                if (isTraceOn && StatefulPassivator.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)StatefulPassivator.tc, (String)"processing EJB 2.1 module or prior", (Object[])new Object[0]);
                }
                bytes = this.getCompressedBytes(sb, lastAccessTime, exPC);
                ostream = this.ivBeanStore.getOutputStream(bid);
                beanStream = this.createPassivationOutputStream(ostream);
                beanStream.writeInt(bytes.length);
                if (isTraceOn && StatefulPassivator.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)StatefulPassivator.tc, (String)("length of compressed bytes is: " + bytes.length), (Object[])new Object[0]);
                }
                beanStream.write(bytes);
                beanStream.close();
                beanO.updateFailoverEntry(bytes, lastAccessTime);
                ** if (credToken == null) goto lbl42
            }
lbl-1000:
            // 1 sources

            {
                this.ivContainer.getEJBRuntime().popServerIdentity(credToken);
            }
lbl42:
            // 2 sources

            if (exceptionCaught == false) return;
            try {
                if (beanStream != null) {
                    beanStream.close();
                    var17_21 = this.ivRemoveLock;
                    synchronized (var17_21) {
                        this.ivBeanStore.remove(bid);
                    }
                }
                if (beanStream2 == null) return;
                beanStream2.close();
                return;
            }
            catch (Exception ex) {
                if (isTraceOn == false) return;
                if (StatefulPassivator.tc.isDebugEnabled() == false) return;
                Tr.debug((TraceComponent)StatefulPassivator.tc, (String)"exception closing stream", (Object[])new Object[]{ex});
            }
            return;
            {
                if (isTraceOn && StatefulPassivator.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)StatefulPassivator.tc, (String)"failover is NOT enabled", (Object[])new Object[0]);
                }
                beanStream = this.createPassivationOutputStream(this.ivBeanStore.getGZIPOutputStream(bid));
lbl62:
                // 2 sources

                objectInfo = null;
                passivatorFields = this.getPassivatorFields(bmd);
                objectInfo = sb instanceof Serializable != false ? this.createSerializableObjectInfo(sb) : this.createNonSerializableObjectInfo(sb, passivatorFields);
                beanStream.writeLong(lastAccessTime);
                beanStream.writeObject(exPC);
                beanStream.writeObject(objectInfo);
                this.writeManagedObjectContext(beanStream, beanO.ivEjbManagedObjectContext);
                interceptors = beanO.ivInterceptors;
                if (interceptors == null) {
                    beanStream.writeInt(-1);
                } else {
                    if (isTraceOn && StatefulPassivator.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)StatefulPassivator.tc, (String)("Processing " + interceptors.length + " interceptors"), (Object[])new Object[0]);
                    }
                    beanStream.writeInt(interceptors.length);
                    for (i = 0; i < interceptors.length; ++i) {
                        interceptor = interceptors[i];
                        interceptorObjectInfo = null;
                        interceptorObjectInfo = interceptor instanceof Serializable != false ? this.createSerializableObjectInfo(interceptor) : this.createNonSerializableObjectInfo(interceptor, passivatorFields);
                        beanStream.writeObject(interceptorObjectInfo);
                    }
                }
                beanStream.close();
                if (beanO.sfsbFailoverEnabled() && baos != null) {
                    bytes = baos.toByteArray();
                    beanStream2 = this.createPassivationOutputStream(this.ivBeanStore.getOutputStream(bid));
                    beanStream2.writeInt(bytes.length);
                    beanStream2.write(bytes);
                    beanStream2.close();
                    beanO.updateFailoverEntry(bytes, lastAccessTime);
                }
                // MONITOREXIT @DISABLED, blocks:[4, 11] lbl90 : MonitorExitStatement: MONITOREXIT : var14_16
                if (credToken != null) {
                    this.ivContainer.getEJBRuntime().popServerIdentity(credToken);
                }
                if (!exceptionCaught) break block41;
            }
            try {
                if (beanStream != null) {
                    beanStream.close();
                    baos = this.ivRemoveLock;
                    synchronized (baos) {
                        this.ivBeanStore.remove(bid);
                    }
                }
                if (beanStream2 != null) {
                    beanStream2.close();
                }
                break block41;
            }
            catch (Exception ex) {
                if (isTraceOn && StatefulPassivator.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)StatefulPassivator.tc, (String)"exception closing stream", (Object[])new Object[]{ex});
                }
                break block41;
            }
            {
                catch (CSIException ex) {
                    try {
                        exceptionCaught = true;
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.passivate", (String)"113", (Object)this);
                        throw new RemoteException("passivation failed", ex);
                        catch (Throwable e) {
                            exceptionCaught = true;
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.passivate", (String)"107", (Object)this);
                            Tr.warning((TraceComponent)StatefulPassivator.tc, (String)"CANNOT_PASSIVATE_STATEFUL_BEAN_CNTR0001W", (Object[])new Object[]{beanO.toString(), this, e});
                            throw new RemoteException("passivation failed", e);
                        }
                    }
                    catch (Throwable var23_28) {
                        if (credToken != null) {
                            this.ivContainer.getEJBRuntime().popServerIdentity(credToken);
                        }
                        if (exceptionCaught == false) throw var23_28;
                        try {
                            if (beanStream != null) {
                                beanStream.close();
                                var24_29 = this.ivRemoveLock;
                                synchronized (var24_29) {
                                    this.ivBeanStore.remove(bid);
                                }
                            }
                            if (beanStream2 == null) throw var23_28;
                            beanStream2.close();
                            throw var23_28;
                        }
                        catch (Exception ex) {
                            if (isTraceOn == false) throw var23_28;
                            if (StatefulPassivator.tc.isDebugEnabled() == false) throw var23_28;
                            Tr.debug((TraceComponent)StatefulPassivator.tc, (String)"exception closing stream", (Object[])new Object[]{ex});
                        }
                        throw var23_28;
                    }
                }
            }
        }
        if (isTraceOn == false) return;
        if (StatefulPassivator.tc.isEntryEnabled() == false) return;
        Tr.exit((TraceComponent)StatefulPassivator.tc, (String)"passivate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(StatefulBeanO beanO, BeanMetaData bmd) throws RemoteException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("activate: " + beanO), (Object[])new Object[0]);
        }
        Object sb = null;
        ManagedObjectContext ejbState = null;
        BeanId bid = beanO.getId();
        ClassLoader classLoader = bmd.classLoader;
        Object credToken = this.ivContainer.getEJBRuntime().pushServerIdentity();
        ObjectInputStream beanStream = null;
        GZIPInputStream istream = null;
        try {
            Object object = this.ivActivateLock;
            synchronized (object) {
                if (!beanO.sfsbFailoverEnabled()) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failover is NOT enabled", (Object[])new Object[0]);
                    }
                    istream = this.ivBeanStore.getGZIPInputStream(bid);
                    beanStream = this.createActivationInputStream(istream, beanO, classLoader);
                } else {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failover is enabled", (Object[])new Object[0]);
                    }
                    byte[] data = null;
                    if (this.ivStatefulFailoverCache.beanExists(bid)) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Retrieving data from failover cache", (Object[])new Object[0]);
                        }
                        boolean isSticky = this.ivStatefulFailoverCache.inStickyUOW(bid);
                        data = this.ivStatefulFailoverCache.getAndRemoveData(bid, beanO.ivSfFailoverClient);
                        if (isSticky) {
                            throw new NoSuchObjectException("Bean Managed Transaction is active, SFSB failover not supported");
                        }
                        if (data == null) {
                            throw new NoSuchObjectException("SFSB replication failed.");
                        }
                    } else {
                        InputStream fis = this.ivBeanStore.getInputStream(bid);
                        ObjectInputStream beanStream2 = this.createActivationInputStream(fis, beanO, classLoader);
                        int n = beanStream2.readInt();
                        data = new byte[n];
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("length of compressed bytes is: " + n), (Object[])new Object[0]);
                        }
                        int bytesRead = 0;
                        for (int offset = 0; offset < n; offset += bytesRead) {
                            bytesRead = beanStream2.read(data, offset, n - offset);
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("bytes read from input stream is: " + bytesRead), (Object[])new Object[0]);
                            }
                            if (bytesRead != -1) continue;
                            throw new IOException("end of input stream while reading compressed bytes");
                        }
                        beanStream2.close();
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    istream = new GZIPInputStream(bais);
                    beanStream = this.createActivationInputStream(istream, beanO, classLoader);
                }
                boolean oldFormat = beanO.sfsbFailoverEnabled() && this.getEJBModuleVersion(beanO) < 30;
                long lastAccessTime = beanStream.readLong();
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("read from data last access time: " + lastAccessTime), (Object[])new Object[0]);
                }
                beanO.setLastAccessTime(lastAccessTime);
                Object exPC = beanStream.readObject();
                beanO.setJPAExPcBindingContext(exPC);
                Map<String, Map<String, Field>> passivatorFields = null;
                if (oldFormat) {
                    sb = beanStream.readObject();
                    ejbState = null;
                } else {
                    EJBObjectInfo sbObjectInfo = (EJBObjectInfo)beanStream.readObject();
                    passivatorFields = this.getPassivatorFields(bmd);
                    sb = sbObjectInfo.isSerializable() ? sbObjectInfo.getSerializableObject() : this.activateObjectFromInfo(sbObjectInfo, bmd.enterpriseBeanClass, passivatorFields);
                    ejbState = this.readManagedObjectContext(beanStream, bmd, sb);
                    int expectedNumInterceptors = 0;
                    if (bmd.ivInterceptorMetaData != null && bmd.ivInterceptorMetaData.ivInterceptorClasses != null) {
                        expectedNumInterceptors = bmd.ivInterceptorMetaData.ivInterceptorClasses.length;
                    }
                    int n = beanStream.readInt();
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("number of interceptors is " + n), (Object[])new Object[0]);
                    }
                    if (n == -1) {
                        n = 0;
                    }
                    if (n != expectedNumInterceptors) {
                        throw new RemoteException("interceptor count " + n + " in serialization data does not match actual count " + expectedNumInterceptors);
                    }
                    if (n != 0) {
                        Class<?>[] interceptorClasses = bmd.ivInterceptorMetaData.ivInterceptorClasses;
                        Object[] interceptors = new Object[n];
                        for (int i = 0; i < n; ++i) {
                            EJBObjectInfo interceptorObjectInfo = (EJBObjectInfo)beanStream.readObject();
                            interceptors[i] = interceptorObjectInfo.isSerializable() ? interceptorObjectInfo.getSerializableObject() : this.activateObjectFromInfo(interceptorObjectInfo, interceptorClasses[i], passivatorFields);
                        }
                        beanO.setInterceptors(interceptors);
                    }
                    beanO.setLastAccessTime(lastAccessTime);
                }
                beanStream.close();
            }
            beanO.setEnterpriseBean(sb, ejbState);
            object = this.ivRemoveLock;
            synchronized (object) {
                this.ivBeanStore.remove(bid);
            }
        }
        catch (StreamUnavailableException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"146", (Object)this);
            throw new NoSuchObjectException("");
        }
        catch (CSIException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"149", (Object)this);
            throw new RemoteException("activation failed", ex);
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"152", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"CANNOT_ACTIVATE_STATEFUL_BEAN_CNTR0003W", (Object[])new Object[]{beanO.toString(), this, e});
            throw new RemoteException("", e);
        }
        catch (RemoteException rex) {
            FFDCFilter.processException((Throwable)rex, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"576", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"CANNOT_ACTIVATE_STATEFUL_BEAN_CNTR0003W", (Object[])new Object[]{beanO.toString(), this, rex});
            throw rex;
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"157", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"CANNOT_ACTIVATE_STATEFUL_BEAN_CNTR0003W", (Object[])new Object[]{beanO.toString(), this, e});
            throw new RemoteException("", e);
        }
        finally {
            if (credToken != null) {
                this.ivContainer.getEJBRuntime().popServerIdentity(credToken);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(BeanId beanId, boolean removeFromFailoverCache) throws RemoteException {
        if (this.ivStatefulFailoverCache == null || !this.ivStatefulFailoverCache.beanExists(beanId)) {
            Object object = this.ivRemoveLock;
            synchronized (object) {
                this.ivBeanStore.remove(beanId);
            }
        } else if (removeFromFailoverCache) {
            this.ivStatefulFailoverCache.removeCacheEntry(beanId);
        }
    }

    public synchronized void terminate() {
        this.ivTerminating = true;
    }

    private synchronized boolean isTerminating() {
        return this.ivTerminating;
    }

    protected abstract ObjectOutputStream createPassivationOutputStream(OutputStream var1) throws IOException;

    protected abstract ObjectInputStream createActivationInputStream(InputStream var1, StatefulBeanO var2, ClassLoader var3) throws IOException;

    protected abstract void writeManagedObjectContext(ObjectOutputStream var1, ManagedObjectContext var2) throws IOException;

    protected abstract ManagedObjectContext readManagedObjectContext(ObjectInputStream var1, BeanMetaData var2, Object var3) throws IOException, ClassNotFoundException;

    private byte[] getCompressedBytes(Object sb, long lastAccessTime, Object exPC) throws IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCompressedBytes", (Object[])new Object[]{sb});
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        GZIPOutputStream gout = new GZIPOutputStream(baos);
        ObjectOutputStream beanStream2 = this.createPassivationOutputStream(gout);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writing failover data with last access time set to: " + lastAccessTime), (Object[])new Object[0]);
        }
        beanStream2.writeLong(lastAccessTime);
        beanStream2.writeObject(exPC);
        beanStream2.writeObject(sb);
        gout.finish();
        gout.close();
        beanStream2.close();
        byte[] bytes = baos.toByteArray();
        baos.close();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCompressedBytes");
        }
        return bytes;
    }

    private static void collectPassivatorFields(Class<?> klass, Map<String, Map<String, Field>> allFields) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("collectPassivatorFields: " + klass.getName()), (Object[])new Object[0]);
        }
        if (Serializable.class.isAssignableFrom(klass)) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"collectPassivatorFields: serializable");
            }
            return;
        }
        for (Class<?> classIter = klass; classIter != Object.class; classIter = classIter.getSuperclass()) {
            String className = classIter.getName();
            Map<String, Field> classPassivatorFields = allFields.get(className);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(classIter + ", cached = " + (classPassivatorFields != null)), (Object[])new Object[0]);
            }
            if (classPassivatorFields != null) continue;
            classPassivatorFields = new LinkedHashMap<String, Field>();
            allFields.put(className, classPassivatorFields);
            AccessibleObject[] fields = classIter.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                int modifiers = ((Field)field).getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) {
                    if (!isTraceOn || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("ignoring " + field), (Object[])new Object[0]);
                    continue;
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("adding " + field), (Object[])new Object[0]);
                }
                classPassivatorFields.put(((Field)field).getName(), (Field)field);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"collectPassivatorFields");
        }
    }

    public Map<String, Map<String, Field>> getPassivatorFields(final BeanMetaData bmd) {
        Map<String, Map<String, Field>> result = bmd.ivPassivatorFields;
        if (result == null) {
            bmd.ivPassivatorFields = result = AccessController.doPrivileged(new PrivilegedAction<Map<String, Map<String, Field>>>(){

                @Override
                public Map<String, Map<String, Field>> run() {
                    HashMap<String, Map<String, Field>> allFields = new HashMap<String, Map<String, Field>>();
                    StatefulPassivator.collectPassivatorFields(bmd.enterpriseBeanClass, allFields);
                    if (bmd.ivInterceptorMetaData != null) {
                        for (Class<?> klass : bmd.ivInterceptorMetaData.ivInterceptorClasses) {
                            StatefulPassivator.collectPassivatorFields(klass, allFields);
                        }
                    }
                    return allFields;
                }
            });
        }
        return result;
    }

    private EJBObjectInfo createNonSerializableObjectInfo(Object obj, Map<String, Map<String, Field>> passivatorFields) throws RemoteException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createNonSerializableObjectInfo", (Object[])new Object[]{obj});
        }
        EJBObjectInfo ejbObjectInfo = new EJBObjectInfo();
        ejbObjectInfo.setSerializable(false);
        Class<?> clazz = obj.getClass();
        ejbObjectInfo.setClassName(clazz.getName());
        for (Class<?> classIter = clazz; classIter != Object.class; classIter = classIter.getSuperclass()) {
            String className = classIter.getName();
            Map<String, Field> classPassivatorFields = passivatorFields.get(className);
            ArrayList<EJBObjectInfo.FieldInfo> fieldInfoList = new ArrayList<EJBObjectInfo.FieldInfo>(classPassivatorFields.size());
            for (Field field : classPassivatorFields.values()) {
                EJBObjectInfo.FieldInfo fieldInfo = this.generateFieldInfo(obj, field);
                fieldInfoList.add(fieldInfo);
            }
            ejbObjectInfo.addFieldInfo(className, fieldInfoList);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createNonSerializableObjectInfo", (Object)ejbObjectInfo);
        }
        return ejbObjectInfo;
    }

    private EJBObjectInfo createSerializableObjectInfo(Object parentObj) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSerializableObjectInfo", (Object[])new Object[]{parentObj});
        }
        EJBObjectInfo objectInfo = new EJBObjectInfo();
        objectInfo.setSerializable(true);
        objectInfo.setSerializableObject(parentObj);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSerializableObjectInfo", (Object)objectInfo);
        }
        return objectInfo;
    }

    private EJBObjectInfo.FieldInfo generateFieldInfo(Object obj, Field field) throws RemoteException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generateFieldInfo", (Object[])new Object[]{field});
        }
        EJBObjectInfo.FieldInfo fieldInfo = new EJBObjectInfo.FieldInfo();
        String fieldName = field.getName();
        Object fieldObj = null;
        try {
            fieldObj = field.get(obj);
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.generateFieldInfo", (String)"851", (Object)this);
            throw new RemoteException("passivation failed", e);
        }
        catch (IllegalAccessException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.generateFieldInfo", (String)"857", (Object)this);
            throw new RemoteException("passivation failed", e);
        }
        fieldInfo.name = fieldName;
        fieldInfo.value = fieldObj;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"generateFieldInfo", (Object)fieldInfo);
        }
        return fieldInfo;
    }

    private Object activateObjectFromInfo(EJBObjectInfo ejbObjectInfo, Class<?> objClass, Map<String, Map<String, Field>> passivatorFields) throws RemoteException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"activateObjectFromInfo", (Object[])new Object[]{ejbObjectInfo, objClass});
        }
        Object obj = null;
        try {
            if (!objClass.getName().equals(ejbObjectInfo.getClassName())) {
                throw new RemoteException("serialization data for class " + ejbObjectInfo.getClassName() + " does not match actual class name " + objClass.getName());
            }
            obj = objClass.newInstance();
            Map<String, List<EJBObjectInfo.FieldInfo>> fieldInfoMap = ejbObjectInfo.getFieldInfoMap();
            for (Class<?> classIter = objClass; classIter != Object.class; classIter = classIter.getSuperclass()) {
                String className = classIter.getName();
                Map<String, Field> classPassivatorFields = passivatorFields.get(className);
                List<EJBObjectInfo.FieldInfo> fieldInfoList = fieldInfoMap.get(className);
                for (EJBObjectInfo.FieldInfo fieldInfo : fieldInfoList) {
                    Field field = classPassivatorFields.get(fieldInfo.name);
                    field.set(obj, fieldInfo.value);
                }
            }
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activateObjectFromInfo", (String)"843", (Object)this);
            throw new RemoteException("activation failed", e);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activateObjectFromInfo", obj);
        }
        return obj;
    }

    private int getEJBModuleVersion(StatefulBeanO beanO) {
        BeanId beanId = beanO.getId();
        BeanMetaData beanMetaData = beanId.getBeanMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("EJB module version is " + beanMetaData.ivModuleVersion), (Object[])new Object[0]);
        }
        return beanMetaData.ivModuleVersion;
    }
}

