/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.locks.ReentrantLock;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ThreadLocalProxyCopyOnWriteArrayList<E>
implements List<E>,
RandomAccess {
    private static final long serialVersionUID = 8673264195747942595L;
    final transient ReentrantLock lock = new ReentrantLock();
    private volatile transient Object[] array;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    final Object[] getArray() {
        return this.array;
    }

    final void setArray(Object[] a) {
        this.array = a;
    }

    public ThreadLocalProxyCopyOnWriteArrayList() {
        this.setArray(new Object[0]);
    }

    public ThreadLocalProxyCopyOnWriteArrayList(Collection<? extends E> c) {
        Object[] elements = c.toArray();
        if (elements.getClass() != Object[].class) {
            elements = Arrays.copyOf(elements, elements.length, Object[].class);
        }
        this.setArray(elements);
    }

    public ThreadLocalProxyCopyOnWriteArrayList(E[] toCopyIn) {
        this.setArray(Arrays.copyOf(toCopyIn, toCopyIn.length, Object[].class));
    }

    @Override
    public int size() {
        return this.getArray().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2;
    }

    private static int indexOf(Object o, Object[] elements, int index, int fence) {
        if (o == null) {
            for (int i = index; i < fence; ++i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < fence; ++i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static int lastIndexOf(Object o, Object[] elements, int index) {
        if (o == null) {
            for (int i = index; i >= 0; --i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        Object[] elements = this.getArray();
        return ThreadLocalProxyCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        Object[] elements = this.getArray();
        return ThreadLocalProxyCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length);
    }

    public int indexOf(E e, int index) {
        Object[] elements = this.getArray();
        return ThreadLocalProxyCopyOnWriteArrayList.indexOf(e, elements, index, elements.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] elements = this.getArray();
        return ThreadLocalProxyCopyOnWriteArrayList.lastIndexOf(o, elements, elements.length - 1);
    }

    public int lastIndexOf(E e, int index) {
        Object[] elements = this.getArray();
        return ThreadLocalProxyCopyOnWriteArrayList.lastIndexOf(e, elements, index);
    }

    @Override
    public Object[] toArray() {
        Object[] elements = this.getArray();
        return Arrays.copyOf(elements, elements.length);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] elements = this.getArray();
        int len = elements.length;
        if (a.length < len) {
            return Arrays.copyOf(elements, len, a.getClass());
        }
        System.arraycopy(elements, 0, a, 0, len);
        if (a.length > len) {
            a[len] = null;
        }
        return a;
    }

    private E get(Object[] a, int index) {
        return (E)a[index];
    }

    @Override
    public E get(int index) {
        return this.get(this.getArray(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            E oldValue = this.get(elements, index);
            if (oldValue != element) {
                int len = elements.length;
                Object[] newElements = Arrays.copyOf(elements, len);
                newElements[index] = element;
                this.setArray(newElements);
            } else {
                this.setArray(elements);
            }
            E e = oldValue;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            Object[] newElements = Arrays.copyOf(elements, len + 1);
            newElements[len] = e;
            this.setArray(newElements);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] newElements;
            Object[] elements = this.getArray();
            int len = elements.length;
            if (index > len || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
            }
            int numMoved = len - index;
            if (numMoved == 0) {
                newElements = Arrays.copyOf(elements, len + 1);
            } else {
                newElements = new Object[len + 1];
                System.arraycopy(elements, 0, newElements, 0, index);
                System.arraycopy(elements, index, newElements, index + 1, numMoved);
            }
            newElements[index] = element;
            this.setArray(newElements);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            E oldValue = this.get(elements, index);
            int numMoved = len - index - 1;
            if (numMoved == 0) {
                this.setArray(Arrays.copyOf(elements, len - 1));
            } else {
                Object[] newElements = new Object[len - 1];
                System.arraycopy(elements, 0, newElements, 0, index);
                System.arraycopy(elements, index + 1, newElements, index, numMoved);
                this.setArray(newElements);
            }
            E e = oldValue;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (len != 0) {
                int newlen = len - 1;
                Object[] newElements = new Object[newlen];
                for (int i = 0; i < newlen; ++i) {
                    if (ThreadLocalProxyCopyOnWriteArrayList.eq(o, elements[i])) {
                        for (int k = i + 1; k < len; ++k) {
                            newElements[k - 1] = elements[k];
                        }
                        this.setArray(newElements);
                        boolean bl = true;
                        return bl;
                    }
                    newElements[i] = elements[i];
                }
                if (ThreadLocalProxyCopyOnWriteArrayList.eq(o, elements[newlen])) {
                    this.setArray(newElements);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRange(int fromIndex, int toIndex) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (fromIndex < 0 || toIndex > len || toIndex < fromIndex) {
                throw new IndexOutOfBoundsException();
            }
            int newlen = len - (toIndex - fromIndex);
            int numMoved = len - toIndex;
            if (numMoved == 0) {
                this.setArray(Arrays.copyOf(elements, newlen));
            } else {
                Object[] newElements = new Object[newlen];
                System.arraycopy(elements, 0, newElements, 0, fromIndex);
                System.arraycopy(elements, toIndex, newElements, fromIndex, numMoved);
                this.setArray(newElements);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIfAbsent(E e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            Object[] newElements = new Object[len + 1];
            for (int i = 0; i < len; ++i) {
                if (ThreadLocalProxyCopyOnWriteArrayList.eq(e, elements[i])) {
                    boolean bl = false;
                    return bl;
                }
                newElements[i] = elements[i];
            }
            newElements[len] = e;
            this.setArray(newElements);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Object[] elements = this.getArray();
        int len = elements.length;
        for (Object e : c) {
            if (ThreadLocalProxyCopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (len != 0) {
                int newlen = 0;
                Object[] temp = new Object[len];
                for (int i = 0; i < len; ++i) {
                    Object element = elements[i];
                    if (c.contains(element)) continue;
                    temp[newlen++] = element;
                }
                if (newlen != len) {
                    this.setArray(Arrays.copyOf(temp, newlen));
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (len != 0) {
                int newlen = 0;
                Object[] temp = new Object[len];
                for (int i = 0; i < len; ++i) {
                    Object element = elements[i];
                    if (!c.contains(element)) continue;
                    temp[newlen++] = element;
                }
                if (newlen != len) {
                    this.setArray(Arrays.copyOf(temp, newlen));
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection<? extends E> c) {
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return 0;
        }
        Object[] uniq = new Object[cs.length];
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            int added = 0;
            for (int i = 0; i < cs.length; ++i) {
                Object e = cs[i];
                if (ThreadLocalProxyCopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0 || ThreadLocalProxyCopyOnWriteArrayList.indexOf(e, uniq, 0, added) >= 0) continue;
                uniq[added++] = e;
            }
            if (added > 0) {
                Object[] newElements = Arrays.copyOf(elements, len + added);
                System.arraycopy(uniq, 0, newElements, len, added);
                this.setArray(newElements);
            }
            int n = added;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.setArray(new Object[0]);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return false;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            Object[] newElements = Arrays.copyOf(elements, len + cs.length);
            System.arraycopy(cs, 0, newElements, len, cs.length);
            this.setArray(newElements);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Object[] cs = c.toArray();
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] newElements;
            Object[] elements = this.getArray();
            int len = elements.length;
            if (index > len || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
            }
            if (cs.length == 0) {
                boolean bl = false;
                return bl;
            }
            int numMoved = len - index;
            if (numMoved == 0) {
                newElements = Arrays.copyOf(elements, len + cs.length);
            } else {
                newElements = new Object[len + cs.length];
                System.arraycopy(elements, 0, newElements, 0, index);
                System.arraycopy(elements, index, newElements, index + cs.length, numMoved);
            }
            System.arraycopy(cs, 0, newElements, index, cs.length);
            this.setArray(newElements);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] elements = this.getArray();
        s.writeInt(elements.length);
        for (Object element : elements) {
            s.writeObject(element);
        }
    }

    public String toString() {
        return Arrays.toString(this.getArray());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        Iterator it = list.iterator();
        Object[] elements = this.getArray();
        int len = elements.length;
        for (int i = 0; i < len; ++i) {
            if (it.hasNext() && ThreadLocalProxyCopyOnWriteArrayList.eq(elements[i], it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object obj : this.getArray()) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Object[] elements = this.getArray();
        int len = elements.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new COWIterator(elements, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (fromIndex < 0 || toIndex > len || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException();
            }
            COWSubList cOWSubList = new COWSubList(this, fromIndex, toIndex);
            return cOWSubList;
        }
        finally {
            lock.unlock();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.ThreadLocalProxyCopyOnWriteArrayList", ThreadLocalProxyCopyOnWriteArrayList.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class COWIterator<E>
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;
        static final long serialVersionUID = -7862899564186261453L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private COWIterator(Object[] elements, int initialCursor) {
            this.cursor = initialCursor;
            this.snapshot = elements;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.ThreadLocalProxyCopyOnWriteArrayList$COWIterator", COWIterator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class COWSubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final ThreadLocalProxyCopyOnWriteArrayList<E> l;
        private final int offset;
        private int size;
        private Object[] expectedArray;
        static final long serialVersionUID = 5644185654580354275L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        COWSubList(ThreadLocalProxyCopyOnWriteArrayList<E> list, int fromIndex, int toIndex) {
            this.l = list;
            this.expectedArray = this.l.getArray();
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        private void checkForComodification() {
            if (this.l.getArray() != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int index, E element) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.rangeCheck(index);
                this.checkForComodification();
                E x = this.l.set(index + this.offset, element);
                this.expectedArray = this.l.getArray();
                E e = x;
                return e;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int index) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.rangeCheck(index);
                this.checkForComodification();
                E e = this.l.get(index + this.offset);
                return e;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public int size() {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                int n = this.size;
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E element) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                if (index < 0 || index > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(index + this.offset, element);
                this.expectedArray = this.l.getArray();
                ++this.size;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void clear() {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                ((ThreadLocalProxyCopyOnWriteArrayList)this.l).removeRange(this.offset, this.offset + this.size);
                this.expectedArray = this.l.getArray();
                this.size = 0;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.rangeCheck(index);
                this.checkForComodification();
                E result = this.l.remove(index + this.offset);
                this.expectedArray = this.l.getArray();
                --this.size;
                E e = result;
                return e;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean remove(Object o) {
            int index = this.indexOf(o);
            if (index == -1) {
                return false;
            }
            this.remove(index);
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                COWSubListIterator<E> cOWSubListIterator = new COWSubListIterator<E>(this.l, 0, this.offset, this.size);
                return cOWSubListIterator;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int index) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                if (index < 0 || index > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
                }
                COWSubListIterator<E> cOWSubListIterator = new COWSubListIterator<E>(this.l, index, this.offset, this.size);
                return cOWSubListIterator;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            ReentrantLock lock = this.l.lock;
            lock.lock();
            try {
                this.checkForComodification();
                if (fromIndex < 0 || toIndex > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                COWSubList<E> cOWSubList = new COWSubList<E>(this.l, fromIndex + this.offset, toIndex + this.offset);
                return cOWSubList;
            }
            finally {
                lock.unlock();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.ThreadLocalProxyCopyOnWriteArrayList$COWSubList", COWSubList.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class COWSubListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> i;
        private final int index;
        private final int offset;
        private final int size;
        static final long serialVersionUID = -4504877489440041851L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        COWSubListIterator(List<E> l, int index, int offset, int size) {
            this.index = index;
            this.offset = offset;
            this.size = size;
            this.i = l.listIterator(index + offset);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex() - this.offset;
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex() - this.offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.ThreadLocalProxyCopyOnWriteArrayList$COWSubListIterator", COWSubListIterator.class, null, null);
        }
    }
}

