/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.http;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.AbstractSessionData;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.http.HttpSessionContextImpl;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.ISession;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionImpl
extends AbstractSessionData {
    private static final String methodClassName = "HttpSessionImpl";
    private static boolean _loggedVersion = false;
    private static final HttpSessionContext _httpSessionContext = new HttpSessionContextImpl();
    private static final String iseMessage = "The method is called on an invalidated session: ";

    protected HttpSessionImpl(ISession session) {
        super(session);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "HttpSessionImpl Constructor (ISession)");
            _loggedVersion = true;
        }
    }

    protected HttpSessionImpl(ISession session, SessionContext sessCtx, ServletContext servCtx) {
        super(session, sessCtx, servCtx);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "HttpSessionImpl Constructor (ISession, SessionContext, ServletContext)");
            _loggedVersion = true;
        }
    }

    public HttpSessionContext getSessionContext() {
        return _httpSessionContext;
    }

    public Object getValue(String attributeName) {
        return this.getAttribute(attributeName);
    }

    public String[] getValueNames() {
        if (!this.getISession().isValid()) {
            throw new IllegalStateException(iseMessage + this.getISession().getId());
        }
        Enumeration<String> enumeration = this.getAttributeNames();
        Vector<String> valueNames = new Vector<String>();
        String name = null;
        while (enumeration.hasMoreElements()) {
            name = enumeration.nextElement();
            valueNames.add(name);
        }
        String[] names = new String[valueNames.size()];
        return valueNames.toArray(names);
    }

    public void putValue(String attributeName, Object value) {
        this.setAttribute(attributeName, value);
    }

    public void removeValue(String attributeName) {
        this.removeAttribute(attributeName);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("# HttpSessionImpl # \n { ").append("\n _iSession=").append(this.getISession()).append("\n _httpSessionContext=").append(_httpSessionContext).append("\n } \n");
        return sb.toString();
    }
}

