/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.utils;

import com.ibm.ws.collective.utility.utils.CommandUtils;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class PromptX509TrustManager
implements X509TrustManager {
    private final Logger logger = Logger.getLogger(PromptX509TrustManager.class.getCanonicalName());
    private final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final ConsoleWrapper stdin;
    private final PrintStream stdout;
    private final TrustManager[] trustManagers;
    private final boolean autoAccept;
    private static Map<String, Boolean> answeredCertificates = new HashMap<String, Boolean>();

    static void clearAnsweredCertificates() {
        answeredCertificates.clear();
    }

    public PromptX509TrustManager(ConsoleWrapper stdin, PrintStream stdout, TrustManager[] trustManagers, boolean autoAccept) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.trustManagers = trustManagers;
        this.autoAccept = autoAccept;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    private String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    private String generateDigest(String algorithmName, X509Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithmName);
            md.update(cert.getEncoded());
            byte[] data = md.digest();
            StringBuilder buffer = new StringBuilder(3 * data.length);
            int i = 0;
            buffer.append(this.HEX_CHARS[data[i] >> 4 & 0xF]);
            buffer.append(this.HEX_CHARS[data[i] % 16 & 0xF]);
            ++i;
            while (i < data.length) {
                buffer.append(':');
                buffer.append(this.HEX_CHARS[data[i] >> 4 & 0xF]);
                buffer.append(this.HEX_CHARS[data[i] % 16 & 0xF]);
                ++i;
            }
            return buffer.toString();
        }
        catch (NoClassDefFoundError e) {
            return this.getMessage("sslTrust.genDigestError", algorithmName, e.getMessage());
        }
        catch (Exception e) {
            return this.getMessage("sslTrust.genDigestError", algorithmName, e.getMessage());
        }
    }

    boolean isYes(String read) {
        String expectedYesShortResponse = this.getMessage("yes.response.short", new Object[0]);
        String expectedYesFullResponse = this.getMessage("yes.response.full", new Object[0]);
        return "y".equalsIgnoreCase(read) || "yes".equalsIgnoreCase(read) || expectedYesShortResponse != null && expectedYesShortResponse.length() > 0 && expectedYesShortResponse.equalsIgnoreCase(read) || expectedYesFullResponse != null && expectedYesFullResponse.length() > 0 && expectedYesFullResponse.equalsIgnoreCase(read);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        int i;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Attempting to estalbish trust with target certificate chain:");
            for (i = 0; i < chain.length; ++i) {
                this.logger.fine("Certificate information [" + i + "]:");
                this.logger.fine("  Subject DN: " + chain[i].getSubjectDN());
                this.logger.fine("  Issuer DN: " + chain[i].getIssuerDN());
                this.logger.fine("  Serial number: " + chain[i].getSerialNumber());
                this.logger.fine("");
            }
        }
        if (this.trustManagers != null && this.trustManagers.length > 0) {
            for (i = 0; i < this.trustManagers.length; ++i) {
                TrustManager tm = this.trustManagers[i];
                if (!(tm instanceof X509TrustManager)) continue;
                X509TrustManager x509tm = (X509TrustManager)tm;
                try {
                    x509tm.checkServerTrusted(chain, authType);
                    this.logger.fine("One of the default trust managers trusts the certificate, accepting...");
                    return;
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
        }
        this.logger.fine("None of the default trust managers trusts the certificate...");
        StringBuilder fullMD5Buf = new StringBuilder();
        for (int i2 = 0; i2 < chain.length; ++i2) {
            fullMD5Buf.append(this.generateDigest("MD5", chain[i2]));
            if (i2 >= chain.length - 1) continue;
            fullMD5Buf.append(',');
        }
        String fullMD5 = fullMD5Buf.toString();
        Boolean previousAnswer = answeredCertificates.get(fullMD5);
        if (previousAnswer != null) {
            if (previousAnswer.booleanValue()) {
                return;
            }
            throw new CertificateException(this.getMessage("sslTrust.rejectTrust", new Object[0]));
        }
        if (this.autoAccept) {
            this.stdout.println();
            this.stdout.println(this.getMessage("sslTrust.autoAccept", chain[0].getSubjectDN()));
            this.stdout.println();
            answeredCertificates.put(fullMD5, Boolean.TRUE);
            return;
        }
        this.stdout.println();
        this.stdout.println(this.getMessage("sslTrust.noDefaultTrust", new Object[0]));
        this.stdout.println();
        this.stdout.println(this.getMessage("sslTrust.certInfo", new Object[0]));
        for (int i3 = 0; i3 < chain.length; ++i3) {
            this.stdout.println(this.getMessage("sslTrust.cert", "[" + i3 + "]"));
            this.stdout.println(this.getMessage("sslTrust.certSubjectDN", chain[i3].getSubjectDN()));
            this.stdout.println(this.getMessage("sslTrust.certIssueDN", chain[i3].getIssuerDN()));
            this.stdout.println(this.getMessage("sslTrust.certSerial", chain[i3].getSerialNumber()));
            this.stdout.println(this.getMessage("sslTrust.certExpires", chain[i3].getNotAfter()));
            this.stdout.println(this.getMessage("sslTrust.certSHADigest", this.generateDigest("SHA-1", chain[i3])));
            this.stdout.println(this.getMessage("sslTrust.certMD5Digest", this.generateDigest("MD5", chain[i3])));
            this.stdout.println();
        }
        String read = this.stdin.readText(this.getMessage("sslTrust.promptToAcceptTrust", new Object[0]));
        if (!this.isYes(read)) {
            answeredCertificates.put(fullMD5, Boolean.FALSE);
            throw new CertificateException(this.getMessage("sslTrust.rejectTrust", new Object[0]));
        }
        answeredCertificates.put(fullMD5, Boolean.TRUE);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

