/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.utils;

import com.ibm.ws.collective.utility.IMaintenanceModeMBeanConnection;
import com.ibm.ws.collective.utility.utils.CommonMBeanConnection;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;

public class MaintenanceModeMBeanConnection
extends CommonMBeanConnection
implements IMaintenanceModeMBeanConnection {
    private static final String OBJECT_NAME = "WebSphere:feature=collectiveController,type=MaintenanceMode,name=MaintenanceMode";
    private final ObjectName objectName;
    private static final String MAINT_MODE_TARGET_MACHINE_EXCEPTION = "Problem connecting to target machine";

    public MaintenanceModeMBeanConnection(ConsoleWrapper stdin, PrintStream stdout) {
        super(stdin, stdout);
        try {
            this.objectName = new ObjectName(OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Statically defined MBean name WebSphere:feature=collectiveController,type=MaintenanceMode,name=MaintenanceMode was not valid...", e);
        }
    }

    @Override
    public List<Map<String, String>> enterHostMaintenanceMode(String controllerHost, int controllerPort, String user, String password, List<String> hostNames, boolean affinity, boolean force) throws ConnectException, IOException, IllegalArgumentException, KeyManagementException, NoSuchAlgorithmException, InstanceNotFoundException, MBeanException, ReflectionException {
        JMXConnector connector = this.getJMXConnector(controllerHost, controllerPort, user, password);
        Object[] params = new Object[]{hostNames, affinity, force};
        String[] signature = new String[]{"java.util.List", "boolean", "boolean"};
        try {
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            List list = (List)mbsc.invoke(this.objectName, "enterHostMaintenanceMode", params, signature);
            return list;
        }
        catch (ConnectException e) {
            throw new ConnectException(MAINT_MODE_TARGET_MACHINE_EXCEPTION);
        }
        finally {
            connector.close();
        }
    }

    @Override
    public List<Map<String, String>> enterServerMaintenanceMode(String controllerHost, int controllerPort, String user, String password, List<String> serverTuples, boolean affinity, boolean force) throws ConnectException, IOException, IllegalArgumentException, KeyManagementException, NoSuchAlgorithmException, InstanceNotFoundException, MBeanException, ReflectionException {
        JMXConnector connector = this.getJMXConnector(controllerHost, controllerPort, user, password);
        Object[] params = new Object[]{serverTuples, affinity, force};
        String[] signature = new String[]{"java.util.List", "boolean", "boolean"};
        try {
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            List list = (List)mbsc.invoke(this.objectName, "enterServerMaintenanceMode", params, signature);
            return list;
        }
        catch (ConnectException e) {
            throw new ConnectException(MAINT_MODE_TARGET_MACHINE_EXCEPTION);
        }
        finally {
            connector.close();
        }
    }

    @Override
    public List<Map<String, String>> exitHostMaintenanceMode(String controllerHost, int controllerPort, String user, String password, List<String> hostNames) throws ConnectException, IOException, IllegalArgumentException, KeyManagementException, NoSuchAlgorithmException, InstanceNotFoundException, MBeanException, ReflectionException {
        JMXConnector connector = this.getJMXConnector(controllerHost, controllerPort, user, password);
        Object[] params = new Object[]{hostNames};
        String[] signature = new String[]{"java.util.List"};
        try {
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            List list = (List)mbsc.invoke(this.objectName, "exitHostMaintenanceMode", params, signature);
            return list;
        }
        catch (ConnectException e) {
            throw new ConnectException(MAINT_MODE_TARGET_MACHINE_EXCEPTION);
        }
        finally {
            connector.close();
        }
    }

    @Override
    public List<Map<String, String>> exitServerMaintenanceMode(String controllerHost, int controllerPort, String user, String password, List<String> serverTuples) throws ConnectException, IOException, IllegalArgumentException, KeyManagementException, NoSuchAlgorithmException, InstanceNotFoundException, MBeanException, ReflectionException {
        JMXConnector connector = this.getJMXConnector(controllerHost, controllerPort, user, password);
        Object[] params = new Object[]{serverTuples};
        String[] signature = new String[]{"java.util.List"};
        try {
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            List list = (List)mbsc.invoke(this.objectName, "exitServerMaintenanceMode", params, signature);
            return list;
        }
        catch (ConnectException e) {
            throw new ConnectException(MAINT_MODE_TARGET_MACHINE_EXCEPTION);
        }
        finally {
            connector.close();
        }
    }

    @Override
    public List<Map<String, String>> getHostMaintenanceMode(String controllerHost, int controllerPort, String user, String password, List<String> hostNames) throws ConnectException, IOException, IllegalArgumentException, KeyManagementException, NoSuchAlgorithmException, InstanceNotFoundException, MBeanException, ReflectionException {
        JMXConnector connector = this.getJMXConnector(controllerHost, controllerPort, user, password);
        Object[] params = new Object[]{hostNames};
        String[] signature = new String[]{"java.util.List"};
        try {
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            List list = (List)mbsc.invoke(this.objectName, "getHostMaintenanceMode", params, signature);
            return list;
        }
        catch (ConnectException e) {
            throw new ConnectException(MAINT_MODE_TARGET_MACHINE_EXCEPTION);
        }
        finally {
            connector.close();
        }
    }

    @Override
    public List<Map<String, String>> getServerMaintenanceMode(String controllerHost, int controllerPort, String user, String password, List<String> serverTuples) throws ConnectException, IOException, IllegalArgumentException, KeyManagementException, NoSuchAlgorithmException, InstanceNotFoundException, MBeanException, ReflectionException {
        JMXConnector connector = this.getJMXConnector(controllerHost, controllerPort, user, password);
        Object[] params = new Object[]{serverTuples};
        String[] signature = new String[]{"java.util.List"};
        try {
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            List list = (List)mbsc.invoke(this.objectName, "getServerMaintenanceMode", params, signature);
            return list;
        }
        catch (ConnectException e) {
            throw new ConnectException(MAINT_MODE_TARGET_MACHINE_EXCEPTION);
        }
        finally {
            connector.close();
        }
    }

    @Override
    public String getMaintModeConnectExceptionMsg() {
        return MAINT_MODE_TARGET_MACHINE_EXCEPTION;
    }
}

