/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.util;

import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;

public class FieldInitializer {
    public static void initFromSystemProperties(Class<?> c) {
        FieldInitializer.updateFieldsFromSystemProperties(c, null);
    }

    public static void initFromSystemProperties(Object o) {
        FieldInitializer.updateFieldsFromSystemProperties(o.getClass(), o);
    }

    public static void initFromSystemProperties(Class<?> c, Properties prop) {
        FieldInitializer.updateFieldsFromProperties(c, null, prop);
    }

    public static void initFromSystemProperties(Object o, Properties prop) {
        FieldInitializer.updateFieldsFromProperties(o.getClass(), o, prop);
    }

    private static void updateFieldsFromSystemProperties(Class<?> c, Object o) {
        FieldInitializer.updateFieldsFromProperties(c, o, System.getProperties());
    }

    private static void updateFieldsFromProperties(Class<?> c, Object o, Properties prop) {
        Enumeration<?> propNames = prop.propertyNames();
        String prefix = c.getName();
        Field[] fields = c.getDeclaredFields();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (!FieldInitializer.isClassProperty(fields, propName, prefix)) continue;
            Field field = null;
            try {
                int modifiers;
                String fieldName = propName.substring(propName.lastIndexOf(46) + 1);
                field = FieldInitializer.getDeclaredField(c, fieldName);
                if (field != null && o == null && !Modifier.isStatic(modifiers = field.getModifiers())) {
                    field = null;
                }
                if (field != null) {
                    AccessController.doPrivileged(new SetAccessibleAction(field, true));
                    String val = (String)prop.get(propName);
                    Class<?> fClass = field.getType();
                    if (fClass == String.class) {
                        field.set(o, val);
                    } else if (fClass == Integer.TYPE) {
                        field.setInt(o, Integer.parseInt(val));
                    } else if (fClass == Boolean.TYPE) {
                        field.setBoolean(o, Boolean.valueOf(val));
                    } else if (fClass == Long.TYPE) {
                        field.setLong(o, Long.parseLong(val));
                    } else if (fClass == Byte.TYPE) {
                        field.setByte(o, Byte.parseByte(val));
                    } else if (fClass == Character.TYPE) {
                        field.setChar(o, val.charAt(0));
                    } else if (fClass == Float.TYPE) {
                        field.setFloat(o, Float.parseFloat(val));
                    } else if (fClass == Double.TYPE) {
                        field.setDouble(o, Double.parseDouble(val));
                    } else if (fClass == Short.TYPE) {
                        field.setShort(o, Short.parseShort(val));
                    }
                }
            }
            catch (IllegalAccessException iae) {
                FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.util.FieldInitializer", (String)"110");
            }
            catch (IllegalArgumentException iae) {
                FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.util.FieldInitializer", (String)"113");
            }
            catch (NullPointerException npe) {
                FFDCFilter.processException((Throwable)npe, (String)"com.ibm.ws.util.FieldInitializer", (String)"116");
            }
            catch (ExceptionInInitializerError eiie) {
                FFDCFilter.processException((Throwable)eiie, (String)"com.ibm.ws.util.FieldInitializer", (String)"119");
            }
            if (field == null) continue;
            AccessController.doPrivileged(new SetAccessibleAction(field, false));
        }
    }

    private static Field getDeclaredField(Class<?> c, String fieldName) {
        Field f = null;
        do {
            try {
                f = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException nsfe) {
                if (c == Object.class) {
                    FFDCFilter.processException((Throwable)nsfe, (String)"com.ibm.ws.util.FieldInitializer", (String)"133");
                    c = null;
                    continue;
                }
                c = c.getSuperclass();
            }
            catch (NullPointerException npe) {
                FFDCFilter.processException((Throwable)npe, (String)"com.ibm.ws.util.FieldInitializer", (String)"137");
                c = null;
            }
            catch (SecurityException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.util.FieldInitializer", (String)"140");
                c = null;
            }
        } while (f == null && c != null);
        return f;
    }

    private static boolean isClassProperty(Field[] fields, String propName, String className) {
        try {
            if (propName.startsWith(className)) {
                propName = propName.substring(propName.lastIndexOf(46) + 1);
            }
            for (Field field : fields) {
                if (!field.getName().equals(propName)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static class SetAccessibleAction
    implements PrivilegedAction<Void> {
        private final Field field;
        private final boolean accessible;

        SetAccessibleAction(Field field, boolean accessible) {
            this.field = field;
            this.accessible = accessible;
        }

        @Override
        public Void run() {
            this.field.setAccessible(this.accessible);
            return null;
        }
    }
}

