/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.websphere.cache.PreInvalidationListener;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.Scheduler;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.EventSource;
import java.util.HashSet;

public class DCEventSource
implements EventSource {
    private static TraceComponent tc = Tr.register(DCEventSource.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private String cacheNameNonPrefixed;
    static final InvalidationListener[] EMPTY_INV_LISTENERS = new InvalidationListener[0];
    static final ChangeListener[] EMPTY_CHANGE_LISTENERS = new ChangeListener[0];
    private int invalidationListenerCount = 0;
    private int preInvalidationListenerCount = 0;
    private int changeListenerCount = 0;
    private boolean bUpdateInvalidationListener = false;
    private boolean bUpdateChangeListener = false;
    private HashSet<InvalidationListener> hsInvalidationListeners = new HashSet(2);
    private HashSet<ChangeListener> hsChangeListeners = new HashSet(2);
    private InvalidationListener[] currentInvalidationListeners = EMPTY_INV_LISTENERS;
    private PreInvalidationListener currentPreInvalidationListener;
    private ChangeListener[] currentChangeListeners = EMPTY_CHANGE_LISTENERS;
    private boolean _async = false;

    public DCEventSource(String cacheNameNonPrefixed, boolean async) {
        this.cacheNameNonPrefixed = cacheNameNonPrefixed;
        this._async = async;
    }

    @Override
    public int getInvalidationListenerCount() {
        return this.invalidationListenerCount;
    }

    @Override
    public int getPreInvalidationListenerCount() {
        return this.preInvalidationListenerCount;
    }

    @Override
    public int getChangeListenerCount() {
        return this.changeListenerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEvent(final InvalidationEvent event) {
        block10: {
            if (this.bUpdateInvalidationListener) {
                HashSet<InvalidationListener> hashSet = this.hsInvalidationListeners;
                synchronized (hashSet) {
                    if (this.invalidationListenerCount > 0) {
                        this.currentInvalidationListeners = new InvalidationListener[this.invalidationListenerCount];
                        this.hsInvalidationListeners.toArray(this.currentInvalidationListeners);
                    } else {
                        this.currentInvalidationListeners = EMPTY_INV_LISTENERS;
                    }
                    this.bUpdateInvalidationListener = false;
                }
            }
            try {
                event.m_cacheName = this.cacheNameNonPrefixed;
                for (int i = 0; i < this.currentInvalidationListeners.length; ++i) {
                    final InvalidationListener currentIL = this.currentInvalidationListeners[i];
                    if (this._async) {
                        Scheduler.submit(new Runnable(){

                            @Override
                            public void run() {
                                currentIL.fireEvent(event);
                            }
                        });
                        continue;
                    }
                    currentIL.fireEvent(event);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.DCEventSource.fireEvent", (String)"85", (Object)this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)("Exception thrown in fireEvent method of InvalidationListener\n" + t.toString()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(InvalidationListener listener) {
        HashSet<InvalidationListener> hashSet = this.hsInvalidationListeners;
        synchronized (hashSet) {
            this.hsInvalidationListeners.add(listener);
            this.invalidationListenerCount = this.hsInvalidationListeners.size();
            this.bUpdateInvalidationListener = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(InvalidationListener listener) {
        HashSet<InvalidationListener> hashSet = this.hsInvalidationListeners;
        synchronized (hashSet) {
            this.hsInvalidationListeners.remove(listener);
            this.invalidationListenerCount = this.hsInvalidationListeners.size();
            this.bUpdateInvalidationListener = true;
        }
    }

    @Override
    public boolean shouldInvalidate(Object id, int sourceOfInvalidation, int causeOfInvalidation) {
        boolean retVal;
        block3: {
            retVal = true;
            if (this.preInvalidationListenerCount > 0) {
                try {
                    retVal = this.currentPreInvalidationListener.shouldInvalidate(id, sourceOfInvalidation, causeOfInvalidation);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.DCEventSource.shouldInvalidate", (String)"120", (Object)this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in shouldInvalidate method of PreInvalidationListener\n" + t.toString()), (Object[])new Object[0]);
                }
            }
        }
        return retVal;
    }

    @Override
    public void addListener(PreInvalidationListener listener) {
        if (this.preInvalidationListenerCount == 1 && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Over-writing current PreInvalidationListener with new one", (Object[])new Object[0]);
        }
        this.currentPreInvalidationListener = listener;
        this.preInvalidationListenerCount = 1;
    }

    @Override
    public void removeListener(PreInvalidationListener listener) {
        if (listener == this.currentPreInvalidationListener) {
            this.currentPreInvalidationListener = null;
            this.preInvalidationListenerCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheEntryChanged(final ChangeEvent event) {
        block10: {
            if (this.bUpdateChangeListener) {
                HashSet<ChangeListener> hashSet = this.hsChangeListeners;
                synchronized (hashSet) {
                    if (this.changeListenerCount > 0) {
                        this.currentChangeListeners = new ChangeListener[this.changeListenerCount];
                        this.hsChangeListeners.toArray(this.currentChangeListeners);
                    } else {
                        this.currentChangeListeners = EMPTY_CHANGE_LISTENERS;
                    }
                    this.bUpdateChangeListener = false;
                }
            }
            try {
                event.m_cacheName = this.cacheNameNonPrefixed;
                for (int i = 0; i < this.currentChangeListeners.length; ++i) {
                    final ChangeListener cl = this.currentChangeListeners[i];
                    if (this._async) {
                        Scheduler.submit(new Runnable(){

                            @Override
                            public void run() {
                                cl.cacheEntryChanged(event);
                            }
                        });
                        continue;
                    }
                    cl.cacheEntryChanged(event);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.DCEventSource.cacheEntryChanged", (String)"169", (Object)this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)("Exception thrown in cacheEntryChanged method of ChangeListener\n" + t.toString()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ChangeListener listener) {
        HashSet<ChangeListener> hashSet = this.hsChangeListeners;
        synchronized (hashSet) {
            this.hsChangeListeners.add(listener);
            this.changeListenerCount = this.hsChangeListeners.size();
            this.bUpdateChangeListener = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ChangeListener listener) {
        HashSet<ChangeListener> hashSet = this.hsChangeListeners;
        synchronized (hashSet) {
            this.hsChangeListeners.remove(listener);
            this.changeListenerCount = this.hsChangeListeners.size();
            this.bUpdateChangeListener = true;
        }
    }
}

