/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={AccessIdUtil.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public final class AccessIdUtil {
    static final TraceComponent tc = Tr.register(AccessIdUtil.class, (String)"security", (String)"com.ibm.ws.security.internal.resources.LoggingMessages");
    static final Pattern p = Pattern.compile("([^:]+):([^/]+)/(.+)");
    static final Pattern ph = Pattern.compile("([^:]+):([^:]+://[^/]+)/(.+)");
    public static final String TYPE_SERVER = "server";
    public static final String TYPE_USER = "user";
    public static final String TYPE_GROUP = "group";
    public static final String TYPE_SEPARATOR = ":";
    public static final String REALM_SEPARATOR = "/";
    public static final String KEY_SECURITY_SERVICE = "securityService";
    private static volatile RealmHolder realmHolder;
    static final long serialVersionUID = 198023963016137500L;

    @Reference(service=SecurityService.class, name="securityService", policy=ReferencePolicy.DYNAMIC, target="(UserRegistry=*)", updated="setSecurityService")
    protected void setSecurityService(ServiceReference<SecurityService> ref) {
        String[] realm = (String[])ref.getProperty("UserRegistry");
        realmHolder = new RealmHolder(realm);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> ref) {
        realmHolder = null;
    }

    public static String createAccessId(String type, String realm, String uniqueId) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("An internal error occured. type is null");
        }
        if (realm == null || realm.isEmpty()) {
            throw new IllegalArgumentException("An internal error occured. realm is null");
        }
        if (uniqueId == null || uniqueId.isEmpty()) {
            throw new IllegalArgumentException("An internal error occured. uniqueId is null");
        }
        return type + TYPE_SEPARATOR + realm + REALM_SEPARATOR + uniqueId;
    }

    private static boolean isCompleteAccessId(String accessId) {
        return AccessIdUtil.matcher(accessId) != null;
    }

    static Matcher matcher(String accessId) {
        Matcher m;
        if (accessId == null || accessId.isEmpty()) {
            return null;
        }
        RealmHolder holder = realmHolder;
        if (holder != null && holder.realmPattern != null && (m = holder.realmPattern.matcher(accessId)).matches()) {
            if (m.group(3).length() > 0) {
                return m;
            }
            return null;
        }
        m = ph.matcher(accessId);
        if (m.matches()) {
            return m;
        }
        m = p.matcher(accessId);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    static boolean validateRealm(Matcher m) {
        String[] realms;
        RealmHolder holder = realmHolder;
        String[] stringArray = realms = holder == null ? null : holder.realm;
        if (realms == null || realms.length != 1) {
            return true;
        }
        String r = m.group(2);
        return r.equals(realms[0]);
    }

    public static String getEntityType(String accessId) {
        Matcher m = AccessIdUtil.matcher(accessId);
        if (m != null) {
            return m.group(1);
        }
        return null;
    }

    public static String getRealm(String accessId) {
        Matcher m = AccessIdUtil.matcher(accessId);
        if (m != null) {
            return m.group(2);
        }
        return null;
    }

    public static String getUniqueId(String accessId) {
        Matcher m = AccessIdUtil.matcher(accessId);
        if (m != null) {
            return m.group(3);
        }
        return null;
    }

    public static String getUniqueId(String accessId, String realm) {
        Pattern pattern = realm == null ? null : AccessIdUtil.getPatternForRealm(realm);
        return AccessIdUtil.getUniqueId(pattern, accessId);
    }

    private static Pattern getPatternForRealm(String realm) {
        RealmHolder holder = realmHolder;
        Pattern pattern = holder != null && holder.realmPattern != null && realm.equals(holder.realm[0]) ? holder.realmPattern : Pattern.compile("([^:]+):(" + Pattern.quote(realm) + ")/(.*)");
        return pattern;
    }

    private static final String getUniqueId(Pattern realmPattern, String accessId) {
        String uniqueId;
        Matcher m;
        if (realmPattern != null && (m = realmPattern.matcher(accessId)).matches() && (uniqueId = m.group(3)).length() > 0) {
            return uniqueId;
        }
        return AccessIdUtil.getUniqueId(accessId);
    }

    public static Collection<String> getUniqueIds(String[] accessIds, String realm) {
        ArrayList<String> uniqueIds = new ArrayList<String>();
        Pattern pattern = realm == null ? null : AccessIdUtil.getPatternForRealm(realm);
        for (String accessId : accessIds) {
            uniqueIds.add(AccessIdUtil.getUniqueId(pattern, accessId));
        }
        return uniqueIds;
    }

    public static boolean isAccessId(String accessId) {
        return AccessIdUtil.isCompleteAccessId(accessId);
    }

    public static boolean isServerAccessId(String accessId) {
        return AccessIdUtil.isAccessId(accessId) && accessId.startsWith("server:");
    }

    public static boolean isUserAccessId(String accessId) {
        return AccessIdUtil.isAccessId(accessId) && accessId.startsWith("user:");
    }

    public static boolean isGroupAccessId(String accessId) {
        return AccessIdUtil.isAccessId(accessId) && accessId.startsWith("group:");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class RealmHolder {
        final String[] realm;
        final Pattern realmPattern;
        static final long serialVersionUID = -3517957270999671776L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RealmHolder(String[] realm) {
            this.realm = realm;
            this.realmPattern = realm.length == 1 ? Pattern.compile("([^:]+):(" + Pattern.quote(realm[0]) + ")/(.*)") : null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.AccessIdUtil$RealmHolder", RealmHolder.class, (String)"security", (String)"com.ibm.ws.security.internal.resources.LoggingMessages");
        }
    }
}

