/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPDataValidationException;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;
import org.bouncycastle.util.io.TeeInputStream;

public class PGPSymmetricKeyEncryptedData
extends PGPEncryptedData {
    protected PGPSymmetricKeyEncryptedData(InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
    }

    protected InputStream createDecryptionStream(PGPDataDecryptorFactory pGPDataDecryptorFactory, PGPSessionKey pGPSessionKey) throws PGPException {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aEADEncDataPacket = (AEADEncDataPacket)this.encData;
            if (aEADEncDataPacket.getAlgorithm() != pGPSessionKey.getAlgorithm()) {
                throw new PGPException("session key and AEAD algorithm mismatch");
            }
            PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(aEADEncDataPacket, pGPSessionKey);
            BCPGInputStream bCPGInputStream = this.encData.getInputStream();
            return new BCPGInputStream(pGPDataDecryptor.getInputStream(bCPGInputStream));
        }
        if (this.encData instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)this.encData;
            if (symmetricEncIntegrityPacket.getVersion() == 1) {
                PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(true, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
                return this.getDataStream(true, pGPDataDecryptor);
            }
            if (symmetricEncIntegrityPacket.getVersion() == 2) {
                PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
                return new BCPGInputStream(pGPDataDecryptor.getInputStream(this.encData.getInputStream()));
            }
            throw new UnsupportedPacketVersionException("Unsupported SEIPD packet version: " + symmetricEncIntegrityPacket.getVersion());
        }
        PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(false, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
        return this.getDataStream(false, pGPDataDecryptor);
    }

    private InputStream getDataStream(boolean bl, PGPDataDecryptor pGPDataDecryptor) throws PGPException {
        try {
            boolean bl2;
            int n;
            int n2;
            BCPGInputStream bCPGInputStream = this.encData.getInputStream();
            bCPGInputStream.mark(pGPDataDecryptor.getBlockSize() + 2);
            this.encStream = new BCPGInputStream(pGPDataDecryptor.getInputStream(bCPGInputStream));
            if (bl) {
                this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                this.integrityCalculator = pGPDataDecryptor.getIntegrityCalculator();
                this.encStream = new TeeInputStream(this.truncStream, this.integrityCalculator.getOutputStream());
            }
            byte[] byArray = new byte[pGPDataDecryptor.getBlockSize()];
            for (n2 = 0; n2 != byArray.length; ++n2) {
                n = this.encStream.read();
                if (n < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                byArray[n2] = (byte)n;
            }
            n2 = this.encStream.read();
            n = this.encStream.read();
            if (n2 < 0 || n < 0) {
                throw new EOFException("unexpected end of stream.");
            }
            boolean bl3 = byArray[byArray.length - 2] == (byte)n2 && byArray[byArray.length - 1] == (byte)n;
            boolean bl4 = bl2 = n2 == 0 && n == 0;
            if (!bl3 && !bl2) {
                bCPGInputStream.reset();
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }
}

