/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.osgi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.yoko.osgi.ProviderRegistry;

public enum ProviderLocator {

    private static ProviderRegistry registry;

    public static void setRegistry(ProviderRegistry registry) {
        ProviderLocator.registry = registry;
    }

    public static <T> Class<T> loadClass(String className, Class<?> contextClass, ClassLoader loader) throws ClassNotFoundException {
        ClassNotFoundException cnfe;
        block4: {
            Optional<Class> clz = ProviderLocator.getRegistry().map(r -> r.locate(className));
            if (clz.isPresent()) {
                return ProviderLocator.generify(clz.get());
            }
            cnfe = null;
            if (null != loader) {
                try {
                    return ProviderLocator.findClass(className, loader, null);
                }
                catch (ClassNotFoundException e) {
                    cnfe = e;
                    if (null != contextClass) break block4;
                    throw e;
                }
            }
        }
        return ProviderLocator.findClass(className, Optional.ofNullable(contextClass).map(c -> ProviderLocator.doPriv(c::getClassLoader)).orElse(null), cnfe);
    }

    private static <T> Class<T> findClass(String className, ClassLoader loader, ClassNotFoundException previous) throws ClassNotFoundException {
        try {
            return ProviderLocator.generify(Class.forName(className, false, loader));
        }
        catch (ClassNotFoundException e) {
            if (null == previous) {
                throw e;
            }
            previous.addSuppressed(e);
            throw previous;
        }
    }

    private static <T> Class<T> generify(Class<?> c) {
        return c;
    }

    private static <T> T doPriv(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    public static <T> Optional<T> getService(String iface, Class<?> contextClass, ClassLoader loader, Function<Class<T>, Constructor<T>> privilegedGetConstructor) {
        return ProviderLocator.getRegistry().map(r -> r.getService(iface)).map(Optional::of).orElseGet(() -> ProviderLocator.locateServiceClass(iface, contextClass, loader).map(privilegedGetConstructor).map(ProviderLocator::newInstance));
    }

    private static <T> T newInstance(Constructor<T> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new Error(e);
        }
    }

    public static <T> PrivilegedAction<Constructor<T>> getNoArgsConstructor(Class<T> clz) {
        return () -> {
            try {
                return clz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new Error(e);
            }
        };
    }

    public static <T> Optional<Class<T>> getServiceClass(String iface, Class<?> contextClass, ClassLoader loader) {
        return ProviderLocator.getRegistry().map(r -> r.getServiceClass(iface)).map(Optional::of).orElseGet(() -> ProviderLocator.locateServiceClass(iface, contextClass, loader));
    }

    public static boolean isServiceClassLoader(ClassLoader loader) {
        return ProviderLocator.getRegistry().map(r -> r.isServiceClassLoader(loader)).orElse(false);
    }

    static Optional<String> locateServiceClassName(String iface, ClassLoader loader) {
        if (loader != null) {
            try {
                for (URL provider : Collections.list(loader.getResources("META-INF/services/" + iface))) {
                    Iterator<String> iterator = ProviderLocator.parseServiceDefinition(provider).iterator();
                    if (!iterator.hasNext()) continue;
                    String providerName = iterator.next();
                    return Optional.of(providerName);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static <T> Optional<Class<T>> locateServiceClass(String iface, Class<?> contextClass, ClassLoader loader) {
        Optional<String> name = ProviderLocator.locateServiceClassName(iface, loader);
        ClassLoader cl = name.map(n -> loader).orElse(null == contextClass ? loader : ProviderLocator.doPriv(contextClass::getClassLoader));
        return name.map(Optional::of).orElseGet(() -> ProviderLocator.locateServiceClassName(iface, cl)).map(n -> {
            try {
                return ProviderLocator.loadClass(n, contextClass, cl);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        });
    }

    private static List<String> parseServiceDefinition(URL u) {
        String url = u.toString();
        ArrayList<String> classes = new ArrayList<String>();
        if (url.endsWith("/")) {
            return classes;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(u.openStream(), StandardCharsets.UTF_8));
            String line = br.readLine();
            while (line != null) {
                int comment = line.indexOf(35);
                if (comment != -1) {
                    line = line.substring(0, comment);
                }
                if ((line = line.trim()).length() > 0) {
                    classes.add(line);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classes;
    }

    private static Optional<ProviderRegistry> getRegistry() {
        return Optional.ofNullable(registry);
    }
}

