/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.utility.actions;

import com.ibm.ws.config.utility.ConfigUtilityAction;
import com.ibm.ws.config.utility.TaskErrorException;
import com.ibm.ws.config.utility.utils.CommandUtils;
import com.ibm.ws.config.utility.utils.ConsoleWrapper;
import com.ibm.ws.config.utility.utils.RepositoryAccessUtility;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.repository.exceptions.RepositoryException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;

public class FindAction
implements ConfigUtilityAction {
    static final String NL = System.getProperty("line.separator");

    @Override
    public void handleAction(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException, RepositoryException, InstallException {
        if (args.length == 1) {
            stdout.println(CommandUtils.getMessage("getListOfAllSnippets", new Object[0]));
            List<String> configSnippetList = RepositoryAccessUtility.getConfigSnippetList();
            Collections.sort(configSnippetList);
            for (String snippet : configSnippetList) {
                stdout.println(NL + snippet);
            }
        } else if (args.length >= 2) {
            String find_snippet = args[1];
            stdout.println(CommandUtils.getMessage("findSnippet", find_snippet));
            List<String> configSnippetList = RepositoryAccessUtility.getConfigSnippetList();
            boolean found = false;
            if (find_snippet != null) {
                for (String snippet : configSnippetList) {
                    String desc = RepositoryAccessUtility.getConfigSnippetDescription(snippet);
                    if (!snippet.toLowerCase().contains(find_snippet.toLowerCase()) && !desc.toLowerCase().contains(find_snippet.toLowerCase())) continue;
                    stdout.println(NL + snippet);
                    found = true;
                }
            }
            if (!found) {
                stdout.println(CommandUtils.getMessage("snippetNotFound", find_snippet));
            }
        }
    }

    @Override
    public String getActionName() {
        return "find";
    }
}

