/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.ltpakeyutil;

import com.ibm.ws.crypto.ltpakeyutil.LTPACrypto;
import java.security.PrivateKey;

public final class LTPAPrivateKey
implements PrivateKey {
    private static final long serialVersionUID = -2566137894245694562L;
    private static final int PRIVATE_EXPONENT = 1;
    private static final int PUBLIC_EXPONENT = 2;
    private static final int PRIME_P = 3;
    private static final int PRIME_Q = 4;
    private static final int PRIVATE_EXPONENT_LENGTH_FIELD_LENGTH = 4;
    private static final int PUBLIC_EXPONENT_LENGTH = 3;
    private static final int PRIME_P_LENGTH = 65;
    private static final int PRIME_Q_LENGTH = 65;
    private int privateExponentLength;
    private final byte[][] rawKey;
    private final byte[] encodedKey;

    LTPAPrivateKey(byte[][] key) {
        this.rawKey = key;
        LTPACrypto.setRSAKey(key);
        this.privateExponentLength = key[1].length;
        this.encodedKey = this.encode();
    }

    public LTPAPrivateKey(byte[] encodedKey) {
        this.encodedKey = (byte[])encodedKey.clone();
        this.rawKey = this.decode(encodedKey);
    }

    private final byte[][] decode(byte[] encodedPrivateKey) {
        byte[][] decodedKey = new byte[8][];
        if (encodedPrivateKey.length > 133) {
            byte[] lengthBytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                lengthBytes[i] = encodedPrivateKey[i];
            }
            this.privateExponentLength = LTPAPrivateKey.toInt(lengthBytes);
            decodedKey[1] = new byte[this.privateExponentLength];
            decodedKey[2] = new byte[3];
            decodedKey[3] = new byte[65];
            decodedKey[4] = new byte[65];
            System.arraycopy(encodedPrivateKey, 4, decodedKey[1], 0, this.privateExponentLength);
            System.arraycopy(encodedPrivateKey, 4 + this.privateExponentLength, decodedKey[2], 0, 3);
            System.arraycopy(encodedPrivateKey, 4 + this.privateExponentLength + 3, decodedKey[3], 0, 65);
            System.arraycopy(encodedPrivateKey, 4 + this.privateExponentLength + 3 + 65, decodedKey[4], 0, 65);
        } else {
            decodedKey[2] = new byte[3];
            decodedKey[3] = new byte[65];
            decodedKey[4] = new byte[65];
            System.arraycopy(encodedPrivateKey, 0, decodedKey[2], 0, 3);
            System.arraycopy(encodedPrivateKey, 3, decodedKey[3], 0, 65);
            System.arraycopy(encodedPrivateKey, 68, decodedKey[4], 0, 65);
        }
        return decodedKey;
    }

    private byte[] encode() {
        int encodedKeyLength = 4 + this.privateExponentLength + 3 + 65 + 65;
        byte[] encodedPrivateKey = new byte[encodedKeyLength];
        byte[] lengthBytes = LTPAPrivateKey.toByteArray(this.privateExponentLength);
        this.copy(lengthBytes, 0, 4, encodedPrivateKey, 0);
        this.copy(this.rawKey[1], 0, this.privateExponentLength, encodedPrivateKey, 4);
        this.copy(this.rawKey[2], 0, 3, encodedPrivateKey, 4 + this.privateExponentLength);
        this.copy(this.rawKey[3], 0, 65, encodedPrivateKey, 4 + this.privateExponentLength + 3);
        this.copy(this.rawKey[4], 0, 65, encodedPrivateKey, 4 + this.privateExponentLength + 65 + 3);
        return encodedPrivateKey;
    }

    public static byte[] toByteArray(int a) {
        byte[] b = new byte[]{(byte)(a >>> 24 & 0xFF), (byte)(a >>> 16 & 0xFF), (byte)(a >>> 8 & 0xFF), (byte)(a >>> 0 & 0xFF)};
        return b;
    }

    public static final int toInt(byte[] byteVal) {
        int i = byteVal[3] & 0xFF;
        i |= byteVal[2] << 8 & 0xFF00;
        i |= byteVal[1] << 16 & 0xFF0000;
        return i |= byteVal[0] << 24 & 0xFF000000;
    }

    private void copy(byte[] from, int offsetFrom, int len, byte[] to, int offsetTo) {
        for (int i = 0; i < len; ++i) {
            to[offsetTo + i] = from[offsetFrom + i];
        }
    }

    @Override
    public final String getAlgorithm() {
        return "RSA/SHA-1";
    }

    @Override
    public final byte[] getEncoded() {
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public final String getFormat() {
        return "LTPAFormat";
    }

    protected final byte[][] getRawKey() {
        return (byte[][])this.rawKey.clone();
    }
}

