/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.writer;

import com.ibm.websphere.logging.hpel.reader.HpelFormatter;
import com.ibm.websphere.logging.hpel.writer.CompatibilityRepositoryExporter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CompatibilityZipRepositoryExporter
extends CompatibilityRepositoryExporter {
    private static final String BUNDLE_NAME = "com.ibm.ws.logging.hpel.resources.HpelMessages";
    private static final String className = CompatibilityZipRepositoryExporter.class.getName();
    private static final Logger logger = Logger.getLogger(className, "com.ibm.ws.logging.hpel.resources.HpelMessages");
    private final ZipOutputStream out;

    public CompatibilityZipRepositoryExporter(File archiveFile, HpelFormatter formatter) throws IOException {
        this(new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(archiveFile, false))), archiveFile.getName(), formatter);
    }

    private CompatibilityZipRepositoryExporter(ZipOutputStream out, String name, HpelFormatter formatter) throws IOException {
        super(out, formatter);
        this.out = out;
        if (name.endsWith(".zip")) {
            name = name.substring(0, name.length() - 4);
        }
        this.out.putNextEntry(new ZipEntry(name + ".txt"));
    }

    @Override
    public void close() {
        super.close();
        try {
            this.out.closeEntry();
            this.out.close();
        }
        catch (IOException ex) {
            logger.logp(Level.WARNING, className, "finish", "HPEL_ErrorClosingZipStream", ex);
        }
    }
}

