/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

public class URLStreamHandlerAdapter
implements URLStreamHandlerService {
    private URLStreamHandler urlStreamHandlerInstance = null;
    private String urlStreamHandlerClass = null;
    private String urlStreamHandlerClassPath = null;
    private String protocol = null;
    private ServiceRegistration registration = null;
    private static Method _equals;
    private static Method _getDefaultPort;
    private static Method _getHostAddress;
    private static Method _hashCode;
    private static Method _hostsEqual;
    private static Method _openConnection;
    private static Method _openConnectionProxy;
    private static Method _parseURL;
    private static Method _sameFile;
    private static Method _toExternalForm;
    private static Field _handlerField;

    public URLStreamHandlerAdapter(String protocol, String className, String classPath) {
        this.urlStreamHandlerClass = className;
        this.urlStreamHandlerClassPath = classPath;
        this.protocol = protocol;
        Bundle b = FrameworkUtil.getBundle(StreamHandlerUtils.class);
        BundleContext ctx = b.getBundleContext();
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{protocol});
        this.registration = ctx.registerService(URLStreamHandlerService.class.getName(), (Object)this, properties);
    }

    void destroy() {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public URLConnection openConnection(URL url) throws IOException {
        try {
            return (URLConnection)_openConnection.invoke(this.getInstance(), url);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"openConnection", (Object)url);
            return null;
        }
    }

    public URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        try {
            return (URLConnection)_openConnectionProxy.invoke(this.getInstance(), url, proxy);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"openConnection", (Object[])new Object[]{url, proxy});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseURL(URLStreamHandlerSetter setter, URL url, String arg2, int arg3, int arg4) {
        URLStreamHandler currentHandler = null;
        currentHandler = (URLStreamHandler)_handlerField.get(url);
        _handlerField.set(url, this.getInstance());
        _parseURL.invoke(this.getInstance(), url, arg2, arg3, arg4);
        if (currentHandler == null) return;
        try {
            _handlerField.set(url, currentHandler);
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"parseURL", (Object[])new Object[]{url, this, currentHandler});
        }
        return;
        catch (Exception e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"parseURL", (Object[])new Object[]{url, this, currentHandler});
                if (currentHandler == null) return;
            }
            catch (Throwable throwable) {
                if (currentHandler == null) throw throwable;
                try {
                    _handlerField.set(url, currentHandler);
                    throw throwable;
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, (String)this.getClass().getName(), (String)"parseURL", (Object[])new Object[]{url, this, currentHandler});
                }
                throw throwable;
            }
            try {
                _handlerField.set(url, currentHandler);
                return;
            }
            catch (Exception e3) {
                FFDCFilter.processException((Throwable)e3, (String)this.getClass().getName(), (String)"parseURL", (Object[])new Object[]{url, this, currentHandler});
            }
            return;
        }
    }

    public String toExternalForm(URL url) {
        try {
            return (String)_toExternalForm.invoke(this.getInstance(), url);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"toExternalForm", (Object)url);
            return null;
        }
    }

    public boolean equals(URL url1, URL url2) {
        try {
            Boolean result = (Boolean)_equals.invoke(this.getInstance(), url1, url2);
            return result;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"equals", (Object[])new Object[]{url1, url2});
            return false;
        }
    }

    public int getDefaultPort() {
        try {
            Integer result = (Integer)_getDefaultPort.invoke(this.getInstance(), (Object[])null);
            return result;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getDefaultPort");
            return 0;
        }
    }

    public InetAddress getHostAddress(URL url) {
        try {
            return (InetAddress)_getHostAddress.invoke(this.getInstance(), url);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getHostAddress", (Object)url);
            return null;
        }
    }

    public int hashCode(URL url) {
        try {
            Integer result = (Integer)_hashCode.invoke(this.getInstance(), url);
            return result;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"hashCode", (Object)url);
            return url.hashCode();
        }
    }

    public boolean hostsEqual(URL url1, URL url2) {
        try {
            Boolean result = (Boolean)_hostsEqual.invoke(this.getInstance(), url1, url2);
            return result;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"hostsEqual", (Object[])new Object[]{url1, url2});
            return false;
        }
    }

    public boolean sameFile(URL url1, URL url2) {
        try {
            Boolean result = (Boolean)_sameFile.invoke(this.getInstance(), url1, url2);
            return result;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"sameFile", (Object[])new Object[]{url1, url2});
            return false;
        }
    }

    private synchronized Object getInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException, MalformedURLException {
        if (this.urlStreamHandlerInstance == null) {
            this.urlStreamHandlerInstance = (URLStreamHandler)Class.forName(this.urlStreamHandlerClass, true, StreamHandlerUtils.getResourceClassLoader(this.urlStreamHandlerClassPath, null)).newInstance();
        }
        return this.urlStreamHandlerInstance;
    }

    static {
        try {
            _equals = URLStreamHandler.class.getDeclaredMethod("equals", URL.class, URL.class);
            _equals.setAccessible(true);
            _getDefaultPort = URLStreamHandler.class.getDeclaredMethod("getDefaultPort", null);
            _getDefaultPort.setAccessible(true);
            _getHostAddress = URLStreamHandler.class.getDeclaredMethod("getHostAddress", URL.class);
            _getHostAddress.setAccessible(true);
            _hashCode = URLStreamHandler.class.getDeclaredMethod("hashCode", URL.class);
            _hashCode.setAccessible(true);
            _hostsEqual = URLStreamHandler.class.getDeclaredMethod("hostsEqual", URL.class, URL.class);
            _hostsEqual.setAccessible(true);
            _openConnection = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
            _openConnection.setAccessible(true);
            _openConnectionProxy = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class, Proxy.class);
            _openConnectionProxy.setAccessible(true);
            _parseURL = URLStreamHandler.class.getDeclaredMethod("parseURL", URL.class, String.class, Integer.TYPE, Integer.TYPE);
            _parseURL.setAccessible(true);
            _sameFile = URLStreamHandler.class.getDeclaredMethod("sameFile", URL.class, URL.class);
            _sameFile.setAccessible(true);
            _toExternalForm = URLStreamHandler.class.getDeclaredMethod("toExternalForm", URL.class);
            _toExternalForm.setAccessible(true);
            _handlerField = URL.class.getDeclaredField("handler");
            _handlerField.setAccessible(true);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)URLStreamHandlerAdapter.class.getName(), (String)"static init");
        }
    }
}

