/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util.text.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.misc.Launcher;
import sun.security.action.GetPropertyAction;

public class LocaleData {
    private static Vector classPathSegments = new Vector();
    private static Locale[] localeList;
    private static final String PACKAGE = "com.ibm.security.util.text.resources";
    private static final String PREFIX = "LocaleElements_";
    private static final char ZIPSEPARATOR = '/';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Locale[] getAvailableLocales(String key) {
        if (localeList == null) {
            Class<LocaleData> clazz = LocaleData.class;
            // MONITORENTER : com.ibm.security.util.text.resources.LocaleData.class
            if (localeList == null) {
                localeList = LocaleData.createLocaleList();
            }
            // MONITOREXIT : clazz
        }
        Locale[] temp = new Locale[localeList.length];
        System.arraycopy(localeList, 0, temp, 0, localeList.length);
        return temp;
    }

    public static ResourceBundle getLocaleElements(Locale locale) {
        return LocaleData.getBundle("com.ibm.security.util.text.resources.LocaleElements", locale);
    }

    public static ResourceBundle getDateFormatZoneData(Locale locale) {
        return LocaleData.getBundle("com.ibm.security.util.text.resources.DateFormatZoneData", locale);
    }

    private static ResourceBundle getBundle(final String baseName, final Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResourceBundle.getBundle(baseName, locale);
            }
        });
    }

    private static Locale[] createLocaleList() {
        String classPath = AccessController.doPrivileged(new GetPropertyAction("sun.boot.class.path"));
        String s2 = AccessController.doPrivileged(new GetPropertyAction("java.class.path"));
        if (s2 != null && s2.length() != 0) {
            classPath = classPath + File.pathSeparator + s2;
        }
        while (classPath != null && classPath.length() != 0) {
            int i2 = classPath.lastIndexOf(File.pathSeparatorChar);
            String dir = classPath.substring(i2 + 1);
            classPath = i2 == -1 ? null : classPath.substring(0, i2);
            classPathSegments.insertElementAt(dir, 0);
        }
        ClassLoader appLoader = Launcher.getLauncher().getClassLoader();
        URLClassLoader extLoader = (URLClassLoader)appLoader.getParent();
        URL[] urls = extLoader.getURLs();
        for (int i3 = 0; i3 < urls.length; ++i3) {
            classPathSegments.insertElementAt(urls[i3].getFile(), 0);
        }
        String[] classList = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return LocaleData.getClassList(LocaleData.PACKAGE, LocaleData.PREFIX);
            }
        });
        int plen = PREFIX.length();
        Locale[] locales = new Locale[classList.length];
        for (int i4 = 0; i4 < classList.length; ++i4) {
            int p2 = 0;
            int p1 = classList[i4].indexOf(95, plen);
            String lang = "";
            String region = "";
            String var = "";
            if (p1 == -1) {
                lang = classList[i4].substring(plen);
            } else {
                lang = classList[i4].substring(plen, p1);
                p2 = classList[i4].indexOf(95, p1 + 1);
                if (p2 == -1) {
                    region = classList[i4].substring(p1 + 1);
                } else {
                    region = classList[i4].substring(p1 + 1, p2);
                    if (p2 < classList[i4].length()) {
                        var = classList[i4].substring(p2 + 1);
                    }
                }
            }
            locales[i4] = new Locale(lang, region, var);
        }
        return locales;
    }

    private static String[] getClassList(String pkgName, String prefix) {
        Vector listBuffer = new Vector();
        String packagePath = pkgName.replace('.', File.separatorChar) + File.separatorChar;
        String zipPackagePath = pkgName.replace('.', '/') + '/';
        for (int i2 = 0; i2 < classPathSegments.size(); ++i2) {
            String fullPath;
            File dir;
            String onePath = (String)classPathSegments.elementAt(i2);
            File f2 = new File(onePath);
            if (!f2.exists()) continue;
            if (f2.isFile()) {
                LocaleData.scanFile(f2, zipPackagePath, listBuffer, prefix);
                continue;
            }
            if (!f2.isDirectory() || !(dir = new File(fullPath = onePath.endsWith(File.separator) ? onePath + packagePath : onePath + File.separatorChar + packagePath)).exists() || !dir.isDirectory()) continue;
            LocaleData.scanDir(dir, listBuffer, prefix);
        }
        Object[] classNames = new String[listBuffer.size()];
        listBuffer.copyInto(classNames);
        return classNames;
    }

    private static void addClass(String className, Vector listBuffer, String prefix) {
        if (className != null && className.startsWith(prefix) && !listBuffer.contains(className)) {
            listBuffer.addElement(className);
        }
    }

    private static String midString(String str, String pre, String suf) {
        String midStr = str.startsWith(pre) && str.endsWith(suf) ? str.substring(pre.length(), str.length() - suf.length()) : null;
        return midStr;
    }

    private static void scanDir(File dir, Vector listBuffer, String prefix) {
        String[] fileList = dir.list();
        for (int i2 = 0; i2 < fileList.length; ++i2) {
            LocaleData.addClass(LocaleData.midString(fileList[i2], "", ".class"), listBuffer, prefix);
        }
    }

    private static void scanFile(File f2, String packagePath, Vector listBuffer, String prefix) {
        try {
            ZipEntry entry;
            ZipInputStream zipFile = new ZipInputStream(new FileInputStream(f2));
            while ((entry = zipFile.getNextEntry()) != null) {
                String eName = entry.getName();
                if (!eName.startsWith(packagePath) || !eName.endsWith(".class")) continue;
                LocaleData.addClass(LocaleData.midString(eName, packagePath, ".class"), listBuffer, prefix);
            }
        }
        catch (FileNotFoundException e2) {
            System.out.println("file not found:" + e2);
        }
        catch (IOException e3) {
            System.out.println("file IO Exception:" + e3);
        }
        catch (Exception e4) {
            System.out.println("Exception:" + e4);
        }
    }
}

