/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util.text;

public final class Utility {
    static final char ESCAPE = '\ua5a5';
    static final byte ESCAPE_BYTE = -91;
    static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final boolean arrayEquals(Object[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof Object[])) {
            return false;
        }
        Object[] targ = (Object[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(int[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof int[])) {
            return false;
        }
        int[] targ = (int[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(double[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof double[])) {
            return false;
        }
        double[] targ = (double[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(Object source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (source instanceof Object[]) {
            return Utility.arrayEquals((Object[])source, target);
        }
        if (source instanceof int[]) {
            return Utility.arrayEquals((int[])source, target);
        }
        if (source instanceof double[]) {
            return Utility.arrayEquals((int[])source, target);
        }
        return source.equals(target);
    }

    public static final boolean arrayRegionMatches(Object[] source, int sourceStart, Object[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i2 = sourceStart; i2 < sourceEnd; ++i2) {
            if (Utility.arrayEquals(source[i2], target[i2 + delta])) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(int[] source, int sourceStart, int[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i2 = sourceStart; i2 < sourceEnd; ++i2) {
            if (source[i2] == target[i2 + delta]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(double[] source, int sourceStart, double[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i2 = sourceStart; i2 < sourceEnd; ++i2) {
            if (source[i2] == target[i2 + delta]) continue;
            return false;
        }
        return true;
    }

    public static final boolean objectEquals(Object source, Object target) {
        if (source == null) {
            return target == null;
        }
        return source.equals(target);
    }

    public static final String arrayToRLEString(short[] a2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append((char)(a2.length >> 16));
        buffer.append((char)a2.length);
        short runValue = a2[0];
        int runLength = 1;
        for (int i2 = 1; i2 < a2.length; ++i2) {
            short s2 = a2[i2];
            if (s2 == runValue && runLength < 65535) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, runValue, runLength);
            runValue = s2;
            runLength = 1;
        }
        Utility.encodeRun(buffer, runValue, runLength);
        return buffer.toString();
    }

    public static final String arrayToRLEString(byte[] a2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append((char)(a2.length >> 16));
        buffer.append((char)a2.length);
        byte runValue = a2[0];
        int runLength = 1;
        byte[] state = new byte[2];
        for (int i2 = 1; i2 < a2.length; ++i2) {
            byte b2 = a2[i2];
            if (b2 == runValue && runLength < 255) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, runValue, runLength, state);
            runValue = b2;
            runLength = 1;
        }
        Utility.encodeRun(buffer, runValue, runLength, state);
        if (state[0] != 0) {
            Utility.appendEncodedByte(buffer, (byte)0, state);
        }
        return buffer.toString();
    }

    public static final String arrayToRLEString(char[] a2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append((char)(a2.length >> 16));
        buffer.append((char)a2.length);
        char runValue = a2[0];
        int runLength = 1;
        for (int i2 = 1; i2 < a2.length; ++i2) {
            char s2 = a2[i2];
            if (s2 == runValue && runLength < 65535) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, (short)runValue, runLength);
            runValue = s2;
            runLength = 1;
        }
        Utility.encodeRun(buffer, (short)runValue, runLength);
        return buffer.toString();
    }

    public static final String arrayToRLEString(int[] a2) {
        StringBuilder buffer = new StringBuilder();
        Utility.appendInt(buffer, a2.length);
        int runValue = a2[0];
        int runLength = 1;
        for (int i2 = 1; i2 < a2.length; ++i2) {
            int s2 = a2[i2];
            if (s2 == runValue && runLength < 65535) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, runValue, runLength);
            runValue = s2;
            runLength = 1;
        }
        Utility.encodeRun(buffer, runValue, runLength);
        return buffer.toString();
    }

    private static final void encodeRun(StringBuilder buffer, short value, int length) {
        if (length < 4) {
            for (int j2 = 0; j2 < length; ++j2) {
                if (value == 42405) {
                    buffer.append('\ua5a5');
                }
                buffer.append((char)value);
            }
        } else {
            if (length == 42405) {
                if (value == 42405) {
                    buffer.append('\ua5a5');
                }
                buffer.append((char)value);
                --length;
            }
            buffer.append('\ua5a5');
            buffer.append((char)length);
            buffer.append((char)value);
        }
    }

    private static final void encodeRun(StringBuilder buffer, byte value, int length, byte[] state) {
        if (length < 4) {
            for (int j2 = 0; j2 < length; ++j2) {
                if (value == -91) {
                    Utility.appendEncodedByte(buffer, (byte)-91, state);
                }
                Utility.appendEncodedByte(buffer, value, state);
            }
        } else {
            if (length == -91) {
                if (value == -91) {
                    Utility.appendEncodedByte(buffer, (byte)-91, state);
                }
                Utility.appendEncodedByte(buffer, value, state);
                --length;
            }
            Utility.appendEncodedByte(buffer, (byte)-91, state);
            Utility.appendEncodedByte(buffer, (byte)length, state);
            Utility.appendEncodedByte(buffer, value, state);
        }
    }

    private static final void encodeRun(StringBuilder buffer, int value, int length) {
        if (length < 4) {
            for (int j2 = 0; j2 < length; ++j2) {
                if (value == 42405) {
                    Utility.appendInt(buffer, value);
                }
                Utility.appendInt(buffer, value);
            }
        } else {
            if (length == 42405) {
                if (value == 42405) {
                    Utility.appendInt(buffer, 42405);
                }
                Utility.appendInt(buffer, value);
                --length;
            }
            Utility.appendInt(buffer, 42405);
            Utility.appendInt(buffer, length);
            Utility.appendInt(buffer, value);
        }
    }

    private static final void appendInt(StringBuilder buffer, int value) {
        buffer.append((char)(value >>> 16));
        buffer.append((char)(value & 0xFFFF));
    }

    private static final void appendEncodedByte(StringBuilder buffer, byte value, byte[] state) {
        if (state[0] != 0) {
            char c2 = (char)(state[1] << 8 | value & 0xFF);
            buffer.append(c2);
            state[0] = 0;
        } else {
            state[0] = 1;
            state[1] = value;
        }
    }

    public static final short[] RLEStringToShortArray(String s2) {
        int length = s2.charAt(0) << 16 | s2.charAt(1);
        short[] array = new short[length];
        int ai = 0;
        for (int i2 = 2; i2 < s2.length(); ++i2) {
            int c2 = s2.charAt(i2);
            if (c2 == 42405) {
                if ((c2 = s2.charAt(++i2)) == 42405) {
                    array[ai++] = (short)c2;
                    continue;
                }
                int runLength = c2;
                short runValue = (short)s2.charAt(++i2);
                for (int j2 = 0; j2 < runLength; ++j2) {
                    array[ai++] = runValue;
                }
                continue;
            }
            array[ai++] = (short)c2;
        }
        if (ai != length) {
            throw new InternalError("Bad run-length encoded short array");
        }
        return array;
    }

    public static final byte[] RLEStringToByteArray(String s2) {
        int length = s2.charAt(0) << 16 | s2.charAt(1);
        byte[] array = new byte[length];
        boolean nextChar = true;
        int c2 = 0;
        int node = 0;
        int runLength = 0;
        int i2 = 2;
        int ai = 0;
        while (ai < length) {
            int b2;
            if (nextChar) {
                c2 = s2.charAt(i2++);
                b2 = (byte)(c2 >> 8);
                nextChar = false;
            } else {
                b2 = c2 & 0xFF;
                nextChar = true;
            }
            switch (node) {
                case 0: {
                    if (b2 == -91) {
                        node = 1;
                        break;
                    }
                    array[ai++] = b2;
                    break;
                }
                case 1: {
                    if (b2 == -91) {
                        array[ai++] = -91;
                        node = 0;
                        break;
                    }
                    runLength = b2;
                    if (runLength < 0) {
                        runLength += 256;
                    }
                    node = 2;
                    break;
                }
                case 2: {
                    for (int j2 = 0; j2 < runLength; ++j2) {
                        array[ai++] = b2;
                    }
                    node = 0;
                }
            }
        }
        if (node != 0) {
            throw new InternalError("Bad run-length encoded byte array");
        }
        if (i2 != s2.length()) {
            throw new InternalError("Excess data in RLE byte array string");
        }
        return array;
    }

    public static final char[] RLEStringToCharArray(String s2) {
        int length = s2.charAt(0) << 16 | s2.charAt(1);
        char[] array = new char[length];
        int ai = 0;
        for (int i2 = 2; i2 < s2.length(); ++i2) {
            int c2 = s2.charAt(i2);
            if (c2 == 42405) {
                if ((c2 = s2.charAt(++i2)) == 42405) {
                    array[ai++] = c2;
                    continue;
                }
                int runLength = c2;
                char runValue = s2.charAt(++i2);
                for (int j2 = 0; j2 < runLength; ++j2) {
                    array[ai++] = runValue;
                }
                continue;
            }
            array[ai++] = c2;
        }
        if (ai != length) {
            throw new InternalError("Bad run-length encoded short array");
        }
        return array;
    }

    public static final int[] RLEStringToIntArray(String s2) {
        int length = Utility.getInt(s2, 0);
        int[] array = new int[length];
        int ai = 0;
        int i2 = 1;
        int maxI = s2.length() / 2;
        while (ai < length && i2 < maxI) {
            int c2;
            if ((c2 = Utility.getInt(s2, i2++)) == 42405) {
                if ((c2 = Utility.getInt(s2, i2++)) == 42405) {
                    array[ai++] = c2;
                    continue;
                }
                int runLength = c2;
                int runValue = Utility.getInt(s2, i2++);
                for (int j2 = 0; j2 < runLength; ++j2) {
                    array[ai++] = runValue;
                }
                continue;
            }
            array[ai++] = c2;
        }
        if (ai != length || i2 != maxI) {
            throw new InternalError("Bad run-length encoded int array");
        }
        return array;
    }

    public static final String formatForSource(String s2) {
        StringBuilder buffer = new StringBuilder();
        int i2 = 0;
        while (i2 < s2.length()) {
            if (i2 > 0) {
                buffer.append("+\n");
            }
            buffer.append("        \"");
            int count = 11;
            while (i2 < s2.length() && count < 80) {
                char c2;
                if ((c2 = s2.charAt(i2++)) < ' ' || c2 == '\"') {
                    buffer.append('\\');
                    buffer.append(HEX_DIGIT[(c2 & 0x1C0) >> 6]);
                    buffer.append(HEX_DIGIT[(c2 & 0x38) >> 3]);
                    buffer.append(HEX_DIGIT[c2 & 7]);
                    count += 4;
                    continue;
                }
                if (c2 <= '~') {
                    buffer.append(c2);
                    ++count;
                    continue;
                }
                buffer.append("\\u");
                buffer.append(HEX_DIGIT[(c2 & 0xF000) >> 12]);
                buffer.append(HEX_DIGIT[(c2 & 0xF00) >> 8]);
                buffer.append(HEX_DIGIT[(c2 & 0xF0) >> 4]);
                buffer.append(HEX_DIGIT[c2 & 0xF]);
                count += 6;
            }
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public static final String hex(char ch) {
        StringBuilder buff = new StringBuilder();
        return Utility.hex(ch, buff).toString();
    }

    public static final StringBuilder hex(String src, StringBuilder buff) {
        if (src != null && buff != null) {
            int strLen = src.length();
            int x2 = 0;
            Utility.hex(src.charAt(x2), buff);
            while (x2 < strLen) {
                buff.append(',');
                Utility.hex(src.charAt(x2++), buff);
            }
        }
        return buff;
    }

    public static final String hex(String str) {
        StringBuilder buff = new StringBuilder();
        Utility.hex(str, buff);
        return buff.toString();
    }

    public static final String hex(StringBuilder buff) {
        return Utility.hex(buff.toString());
    }

    public static final StringBuilder hex(char ch, StringBuilder buff) {
        for (int shift = 12; shift >= 0; shift -= 4) {
            buff.append(HEX_DIGIT[(byte)(ch >> shift & 0xF)]);
        }
        return buff;
    }

    static final int getInt(String s2, int i2) {
        return s2.charAt(2 * i2) << 16 | s2.charAt(2 * i2 + 1);
    }
}

