/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jpa.management.JPAPXml;
import com.ibm.ws.jpa.management.JaxbPersistence;
import com.ibm.ws.jpa.management.JaxbPersistence10;
import com.ibm.ws.jpa.management.JaxbPersistence20;
import com.ibm.ws.jpa.management.JaxbPersistence21;
import com.ibm.ws.jpa.management.JaxbPersistence22;
import com.ibm.ws.jpa.management.JaxbPersistence30;
import com.ibm.ws.xml.ParserFactory;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.PersistenceException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.SAXParser;
import javax.xml.validation.Schema;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class JaxbUnmarshaller
extends DefaultHandler {
    private static final String CLASS_NAME = JaxbUnmarshaller.class.getName();
    private static final TraceComponent tc = Tr.register(JaxbUnmarshaller.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private static final String PERSISTENCE_NAMESPACE_URI = "http://java.sun.com/xml/ns/persistence";
    private static final String JCP_PERSISTENCE_NAMESPACE_URI = "http://xmlns.jcp.org/xml/ns/persistence";
    private static final String JAKARTA_PERSISTENCE_NAMESPACE_URI = "https://jakarta.ee/xml/ns/persistence";
    private static final String PERSISTENCE_LOCAL_NAME = "persistence";
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final ClassLoader svClassLoader = JaxbUnmarshaller.class.getClassLoader();
    private final JPAPXml ivJPAPXml;
    private JaxbPersistence ivPersistence;
    private UnmarshallerHandler ivHandler;
    private Locator ivLocator;
    private final List<PrefixMapping> ivPrefixMappings = new ArrayList<PrefixMapping>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JaxbPersistence unmarshal(JPAPXml pxml) throws PersistenceException {
        JaxbPersistence persistence;
        boolean isTraceOn;
        block12: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("unmarshal : " + pxml), (Object[])new Object[0]);
            }
            InputStream is = null;
            persistence = null;
            try {
                SAXParser parser = ParserFactory.newSAXParser((boolean)true, (boolean)false);
                JaxbUnmarshaller handler = new JaxbUnmarshaller(pxml);
                is = pxml.openStream();
                parser.parse(is, (DefaultHandler)handler);
                persistence = handler.ivPersistence;
                persistence.setResult(handler.ivHandler.getResult());
                if (is == null) break block12;
            }
            catch (Throwable ex) {
                try {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".unmarshal"), (String)"109", (Object)pxml);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("  unmarshal : caught exception : " + ex), (Object[])new Object[0]);
                    }
                    Throwable root = JaxbUnmarshaller.findRootCause(ex);
                    PersistenceException pex = null;
                    String appName = pxml.getApplInfo().getApplName();
                    String modName = pxml.getArchiveName();
                    if (root instanceof SAXParseException) {
                        SAXParseException saxEx = (SAXParseException)root;
                        int line = saxEx.getLineNumber();
                        int column = saxEx.getColumnNumber();
                        Tr.error((TraceComponent)tc, (String)"SYNTAX_ERROR_IN_PERSISTENCE_XML_CWWJP0040E", (Object[])new Object[]{appName, modName, line, column, saxEx});
                        pex = new PersistenceException("CWWJP0040E: The persistence.xml in application " + appName + ", module " + modName + ", has a syntax error at line number: " + line + ", column number: " + column + ".", (Throwable)saxEx);
                        throw pex;
                    }
                    String urlString = pxml.getRootURL().getPath();
                    Tr.error((TraceComponent)tc, (String)"MALFORMED_PERSISTENCE_XML_CWWJP0018E", (Object[])new Object[]{urlString, root});
                    pex = new PersistenceException("CWWJP0018E: Incorrect syntax or error detected in " + urlString + " for application " + appName + " module " + modName + ". The following associated error occurred:", root);
                    throw pex;
                }
                catch (Throwable throwable) {
                    block13: {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable ex2) {
                                FFDCFilter.processException((Throwable)ex2, (String)(CLASS_NAME + ".unmarshal"), (String)"192", (Object)is);
                                if (!isTraceOn || !tc.isDebugEnabled()) break block13;
                                Tr.debug((TraceComponent)tc, (String)("  unmarshal : caught exception : " + ex2), (Object[])new Object[0]);
                            }
                        }
                    }
                    if (!isTraceOn) throw throwable;
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit((TraceComponent)tc, (String)("unmarshal : " + persistence));
                    throw throwable;
                }
            }
            try {
                is.close();
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".unmarshal"), (String)"192", (Object)is);
                if (!isTraceOn || !tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)("  unmarshal : caught exception : " + ex), (Object[])new Object[0]);
            }
        }
        if (!isTraceOn) return persistence;
        if (!tc.isEntryEnabled()) return persistence;
        Tr.exit((TraceComponent)tc, (String)("unmarshal : " + persistence));
        return persistence;
    }

    private static Throwable findRootCause(Throwable t) {
        Throwable root = t;
        Throwable cause = root.getCause();
        while (cause != null) {
            root = cause;
            cause = root.getCause();
        }
        return root;
    }

    private JaxbUnmarshaller(JPAPXml jpapXml) {
        this.ivJPAPXml = jpapXml;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.ivLocator = locator;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.ivHandler != null) {
            this.ivHandler.endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.ivHandler != null) {
            this.ivHandler.startPrefixMapping(prefix, uri);
        } else {
            this.ivPrefixMappings.add(new PrefixMapping(prefix, uri));
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.ivHandler != null) {
            this.ivHandler.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.ivHandler == null) {
            if (!PERSISTENCE_LOCAL_NAME.equals(localName) || !PERSISTENCE_NAMESPACE_URI.equals(uri) && !JCP_PERSISTENCE_NAMESPACE_URI.equals(uri) && !JAKARTA_PERSISTENCE_NAMESPACE_URI.contentEquals(uri)) {
                throw new SAXParseException("expected root element {http://java.sun.com/xml/ns/persistence}persistence", this.ivLocator);
            }
            String version = atts.getValue("", VERSION_ATTRIBUTE_NAME);
            if ("1.0".equals(version)) {
                this.ivPersistence = new JaxbPersistence10(this.ivJPAPXml);
            } else if ("2.0".equals(version)) {
                this.ivPersistence = new JaxbPersistence20(this.ivJPAPXml);
            } else if ("2.1".equals(version)) {
                this.ivPersistence = new JaxbPersistence21(this.ivJPAPXml);
            } else if ("2.2".equals(version)) {
                this.ivPersistence = new JaxbPersistence22(this.ivJPAPXml);
            } else if ("3.0".equals(version)) {
                this.ivPersistence = new JaxbPersistence30(this.ivJPAPXml);
            }
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)this.ivPersistence.ivJAXBPackageName, (ClassLoader)new DelegateToJVMClassLoader(svClassLoader));
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                Schema schema = this.ivJPAPXml.newSchema(this.ivPersistence.ivXSDName);
                unmarshaller.setSchema(schema);
                this.ivHandler = unmarshaller.getUnmarshallerHandler();
            }
            catch (JAXBException ex) {
                throw new RuntimeException(ex);
            }
            this.ivHandler.setDocumentLocator(this.ivLocator);
            this.ivHandler.startDocument();
            for (PrefixMapping prefixMapping : this.ivPrefixMappings) {
                this.ivHandler.startPrefixMapping(prefixMapping.ivPrefix, prefixMapping.ivURI);
            }
        }
        this.ivHandler.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.ivHandler.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.ivHandler.characters(ch, start, length);
    }

    private static class PrefixMapping {
        final String ivPrefix;
        final String ivURI;

        PrefixMapping(String prefix, String uri) {
            this.ivPrefix = prefix;
            this.ivURI = uri;
        }
    }

    private static class DelegateToJVMClassLoader
    extends ClassLoader {
        final ClassLoader jvmCL = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });

        DelegateToJVMClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        @FFDCIgnore(value={ClassNotFoundException.class})
        public Class<?> findClass(String className) throws ClassNotFoundException {
            return this.jvmCL.loadClass(className);
        }
    }
}

