/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.mbeans;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.webcontainer.httpsession.SessionManager;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHost;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHostManager;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.channelfw.utils.HostNameUtils;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.SessionCookieConfig;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class PluginGenerator {
    private static final TraceComponent tc = Tr.register(PluginGenerator.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private static final String styleSheet = " <xsl:stylesheet version=\"1.0\"                                   \n     xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">           \n   <xsl:output method=\"xml\"/>                                    \n   <xsl:param name=\"indent-increment\" select=\"'   '\" />        \n   <xsl:template match=\"*\">                                      \n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>              \n      <xsl:value-of select=\"$indent\"/>                           \n      <xsl:copy>                                                   \n        <xsl:copy-of select=\"@*\" />                              \n        <xsl:apply-templates>                                      \n          <xsl:with-param name=\"indent\"                          \n               select=\"concat($indent, $indent-increment)\"/>     \n        </xsl:apply-templates>                                     \n        <xsl:if test=\"*\">                                        \n          <xsl:value-of select=\"$indent\"/>                       \n        </xsl:if>                                                  \n      </xsl:copy>                                                  \n   </xsl:template>                                                 \n   <xsl:template match=\"comment()|processing-instruction()\">     \n      <xsl:copy />                                                 \n   </xsl:template>                                                 \n   <xsl:template match=\"text()[normalize-space(.)='']\"/>         \n </xsl:stylesheet>                                                 \n";
    private static final String NOT_DEFINED = "NOT_DEFINED";
    private static final String DEFAULT_VIRTUAL_HOST = "default_host";
    private static final String PLUGIN_CFG_ALIAS = "pluginConfiguration";
    private static final String HTTP_ALLOWED_ENDPOINT = "allowFromEndpointRef";
    private static final String LOCALHOST = "localhost";
    private final PluginConfigData pcd;
    private final BundleContext context;
    private final Bundle bundle;
    private boolean utilityRequest;
    private String appServerName;
    private String webServerName;
    private Integer previousConfigHash;
    private File cachedFile;
    public static final String XALAN_TRANSFORMER_FACTORY_CLASS_NAME = "org.apache.xalan.processor.TransformerFactoryImpl";
    public static final String IBM_XLTXEJ_COMPILED_TRANSFORMER_FACTORY_CLASS_NAME = "com.ibm.xtq.xslt.jaxp.compiler.TransformerFactoryImpl";
    public static final String SAX_LEXICAL_HANDLER_CLASS_NAME = "org.xml.sax.ext.LexicalHandler";

    PluginGenerator(Map<String, Object> config, WsLocationAdmin locSvc, BundleContext context) {
        PluginConfigData newPcd;
        block5: {
            this.utilityRequest = true;
            this.appServerName = null;
            this.webServerName = null;
            this.previousConfigHash = null;
            this.context = context;
            newPcd = null;
            try {
                newPcd = new PluginConfigData(config);
                newPcd.print(tc);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)PluginGenerator.class.getName(), (String)"processConfig");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                Tr.event((TraceComponent)tc, (String)("Error process Config: " + t.getMessage()), (Object[])new Object[0]);
            }
        }
        this.pcd = newPcd;
        this.appServerName = locSvc.getServerName();
        this.bundle = context.getBundle();
        this.cachedFile = this.bundle.getDataFile("cached-PluginCfg.xml");
        if (this.cachedFile.exists()) {
            try {
                PluginConfigQuickPeek quickPeek = new PluginConfigQuickPeek(new FileInputStream(this.cachedFile));
                this.previousConfigHash = quickPeek.getHashValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Exception decompiling
     */
    @FFDCIgnore(value={IOException.class})
    protected synchronized void generateXML(String rootLoc, String serverName, WebContainer container, SessionManager smgr, DynamicVirtualHostManager vhostMgr, WsLocationAdmin locationService, boolean utilityReq, File writeDirectory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 33[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FFDCIgnore(value={IOException.class})
    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static TransformerFactory getTransformerFactory() {
        boolean useApacheXalanTransformer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransformerFactory", (Object[])new Object[0]);
        }
        TransformerFactory tf = null;
        boolean bl = useApacheXalanTransformer = JavaInfo.isSystemClassAvailable((String)IBM_XLTXEJ_COMPILED_TRANSFORMER_FACTORY_CLASS_NAME) && JavaInfo.isSystemClassAvailable((String)XALAN_TRANSFORMER_FACTORY_CLASS_NAME) && JavaInfo.isSystemClassAvailable((String)SAX_LEXICAL_HANDLER_CLASS_NAME);
        if (useApacheXalanTransformer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JDK : Use transformer factory: org.apache.xalan.processor.TransformerFactoryImpl", (Object[])new Object[0]);
            }
            tf = TransformerFactory.newInstance(XALAN_TRANSFORMER_FACTORY_CLASS_NAME, ClassLoader.getSystemClassLoader());
        } else {
            tf = TransformerFactory.newInstance();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JDK : Actual transformer factory: " + tf.getClass().getName()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransformerFactory");
        }
        return tf;
    }

    private boolean hasConfigChanged(Document newConfig) {
        NodeList list = newConfig.getElementsByTagName("*");
        int currentHash = this.nodeListHashValue(list);
        if (this.previousConfigHash == null || currentHash != this.previousConfigHash) {
            this.previousConfigHash = currentHash;
            this.storeHashValue(newConfig, this.previousConfigHash);
            return true;
        }
        return false;
    }

    private void storeHashValue(Document newConfig, Integer configHashValue) {
        Element root = newConfig.getDocumentElement();
        boolean hasHash = root.hasAttribute("ConfigHash");
        if (!hasHash) {
            Attr hashAttribute = newConfig.createAttribute("ConfigHash");
            hashAttribute.setValue(configHashValue.toString());
            root.setAttributeNode(hashAttribute);
        } else {
            root.setAttribute("ConfigHash", configHashValue.toString());
        }
    }

    private Integer nodeListHashValue(NodeList list) {
        if (list == null) {
            return null;
        }
        int currentHash = 0;
        int listLength = list.getLength();
        for (int iterator = 0; iterator < listLength; ++iterator) {
            NamedNodeMap map = list.item(iterator).getAttributes();
            int numAttrs = map.getLength();
            for (int i = 0; i < numAttrs; ++i) {
                Attr attr = (Attr)map.item(i);
                int hash1 = attr.getNodeName().hashCode();
                int hash2 = attr.getNodeValue().hashCode();
                currentHash += hash1 + hash2;
            }
        }
        return currentHash;
    }

    Set<DynamicVirtualHost> processVirtualHosts(DynamicVirtualHostManager vhostMgr, Map<String, List<VHostData>> vhostAliasData, HttpEndpointInfo httpEndpointInfo, Element rootElement) throws Exception {
        Document doc = rootElement.getOwnerDocument();
        Map<String, ServiceReference<?>> vhostConfigRefs = this.getVirtualHostRefs();
        HashSet<DynamicVirtualHost> virtualHostSet = new HashSet<DynamicVirtualHost>();
        HashMap<Integer, List<String>> portToVHostNameMap = new HashMap<Integer, List<String>>();
        boolean findVirtualHosts = true;
        ServiceReference<?> defaultHost = vhostConfigRefs.get(DEFAULT_VIRTUAL_HOST);
        boolean defaultHostIsCatchAll = true;
        if (defaultHost == null || defaultHost.getProperty("hostAlias") != null) {
            defaultHostIsCatchAll = false;
        }
        if (vhostConfigRefs.size() == 1 && defaultHostIsCatchAll) {
            DynamicVirtualHost vh;
            Iterator<DynamicVirtualHost> vHosts = vhostMgr.getVirtualHosts();
            DynamicVirtualHost dynamicVirtualHost = vh = vHosts.hasNext() ? vHosts.next() : null;
            if (!this.blockedByRestrictions(defaultHost.getProperty(HTTP_ALLOWED_ENDPOINT))) {
                if (vh == null) {
                    if (!this.utilityRequest) {
                        Tr.warning((TraceComponent)tc, (String)"warn.check.applications", (Object[])new Object[0]);
                    }
                    Comment comment = doc.createComment(String.format(" No Virtual Hosts were found, possibly because no applications are defined. %n\t Verify that at least one application is defined in the server configuration. ", new Object[0]));
                    rootElement.appendChild(comment);
                    return Collections.emptySet();
                }
                findVirtualHosts = false;
                virtualHostSet.add(vh);
                Comment comment = doc.createComment(String.format(" The default_host contained only aliases for endpoint %s.%n\t The generated VirtualHostGroup will contain only configured web server ports:%n\t\t%s%s%s ", httpEndpointInfo.getEndpointId(), this.pcd.webServerHttpPort > 0 ? "webserverPort=" + this.pcd.webServerHttpPort : "", this.pcd.webServerHttpPort > 0 && this.pcd.webServerHttpsPort > 0 ? "\n\t\t" : "", this.pcd.webServerHttpsPort > 0 ? "webserverSecurePort=" + this.pcd.webServerHttpsPort : ""));
                rootElement.appendChild(comment);
                ArrayList<VHostData> vh_aliasData = new ArrayList<VHostData>();
                if (this.pcd.webServerHttpPort > 0) {
                    VHostData webServerHttpPort = new VHostData("*", this.pcd.webServerHttpPort);
                    vh_aliasData.add(webServerHttpPort);
                    this.mapPortUsage(portToVHostNameMap, DEFAULT_VIRTUAL_HOST, webServerHttpPort);
                }
                if (this.pcd.webServerHttpsPort > 0) {
                    VHostData webServerHttpsPort = new VHostData("*", this.pcd.webServerHttpsPort);
                    vh_aliasData.add(webServerHttpsPort);
                    this.mapPortUsage(portToVHostNameMap, DEFAULT_VIRTUAL_HOST, webServerHttpsPort);
                }
                vhostAliasData.put(DEFAULT_VIRTUAL_HOST, vh_aliasData);
            }
        }
        if (findVirtualHosts) {
            Comment comment;
            VHostData vhostData;
            boolean foundWildcardWebserverHttp = false;
            boolean foundWildcardWebserverHttps = false;
            Iterator<DynamicVirtualHost> i = vhostMgr.getVirtualHosts();
            while (i.hasNext()) {
                DynamicVirtualHost vh = i.next();
                String vh_name = vh.getName();
                ServiceReference<?> vhostConfig = vhostConfigRefs.get(vh_name);
                if (vhostConfig == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Virtual host " + vh.getName() + " has no configuration"), (Object[])new Object[0]);
                    continue;
                }
                if (this.blockedByRestrictions(vhostConfig.getProperty(HTTP_ALLOWED_ENDPOINT))) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Virtual host " + vh.getName() + " is not accessible from configured endpoint"), (Object[])new Object[]{"plugin endpoint = " + this.pcd.httpEndpointPid, "vhost required endpoints = " + this.getList((String[])vhostConfig.getProperty(HTTP_ALLOWED_ENDPOINT))});
                    continue;
                }
                virtualHostSet.add(vh);
                List<String> vh_aliases = vh.getAliases();
                if (vh_aliases.isEmpty()) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Virtual host " + vh.getName() + " has no defined host aliases"), (Object[])new Object[0]);
                    continue;
                }
                ArrayList<VHostData> vh_aliasData = new ArrayList<VHostData>();
                for (String alias : vh_aliases) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("adding " + vh.getName() + " -> " + alias), (Object[])new Object[0]);
                    }
                    VHostData vh_alias = new VHostData(alias);
                    vh_aliasData.add(vh_alias);
                    this.mapPortUsage(portToVHostNameMap, vh_name, vh_alias);
                    if (!vh_alias.host.equals("*")) continue;
                    if (vh_alias.port == this.pcd.webServerHttpPort) {
                        foundWildcardWebserverHttp = true;
                    }
                    if (vh_alias.port != this.pcd.webServerHttpsPort) continue;
                    foundWildcardWebserverHttps = true;
                }
                vhostAliasData.put(vh_name, vh_aliasData);
            }
            List<VHostData> vh_aliasData = vhostAliasData.get(DEFAULT_VIRTUAL_HOST);
            if (this.pcd.webServerHttpPort > 0 && !foundWildcardWebserverHttp) {
                if (defaultHostIsCatchAll && vh_aliasData != null && !this.blockedByRestrictions(defaultHost.getProperty(HTTP_ALLOWED_ENDPOINT))) {
                    vhostData = new VHostData("*", this.pcd.webServerHttpPort);
                    vh_aliasData.add(vhostData);
                    this.mapPortUsage(portToVHostNameMap, DEFAULT_VIRTUAL_HOST, vhostData);
                } else {
                    comment = doc.createComment(String.format(" No virtual hosts are configured to accept requests from the webserver http port (*:%s).%n\t Verify that virtualHost elements in server.xml have appropriate hostAlias attributes to support the webserver. ", this.pcd.webServerHttpPort));
                    rootElement.appendChild(comment);
                }
            }
            if (this.pcd.webServerHttpsPort > 0 && !foundWildcardWebserverHttps) {
                if (defaultHostIsCatchAll && vh_aliasData != null && !this.blockedByRestrictions(defaultHost.getProperty(HTTP_ALLOWED_ENDPOINT))) {
                    vhostData = new VHostData("*", this.pcd.webServerHttpsPort);
                    vh_aliasData.add(vhostData);
                    this.mapPortUsage(portToVHostNameMap, DEFAULT_VIRTUAL_HOST, vhostData);
                } else {
                    comment = doc.createComment(String.format(" No virtual hosts are configured to accept requests from the webserver https port (*:%s).%n\t Verify that virtualHost elements in server.xml have appropriate hostAlias attributes to support the webserver. ", this.pcd.webServerHttpsPort));
                    rootElement.appendChild(comment);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Finished finding vhosts and aliases", (Object[])new Object[]{portToVHostNameMap, vhostAliasData});
            }
        }
        if (virtualHostSet.isEmpty()) {
            Comment comment = doc.createComment(String.format(" No virtual hosts are accessible from the configured endpoint (%s).%n\t Verify the allowed endpoints for the virtualHost elements in server.xml. ", httpEndpointInfo.getEndpointId()));
            rootElement.appendChild(comment);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Finished finding/pruning vhosts and aliases", (Object[])new Object[]{portToVHostNameMap, vhostAliasData, virtualHostSet});
        }
        return virtualHostSet;
    }

    private boolean blockedByRestrictions(Object restrictions) {
        if (restrictions == null) {
            return false;
        }
        List<String> endpoints = this.getList((String[])restrictions);
        if (endpoints.isEmpty()) {
            return false;
        }
        return !endpoints.contains(this.pcd.httpEndpointPid);
    }

    private void mapPortUsage(Map<Integer, List<String>> portToVHostNameMap, String vh_name, VHostData vh_alias) throws UnknownHostException {
        List<String> port_vhostName = portToVHostNameMap.get(vh_alias.port);
        if (port_vhostName == null) {
            port_vhostName = new ArrayList<String>();
            portToVHostNameMap.put(vh_alias.port, port_vhostName);
        }
        port_vhostName.add(vh_name);
    }

    Map<String, ServiceReference<?>> getVirtualHostRefs() throws Exception {
        String filter = "(&(service.factoryPid=com.ibm.ws.http.virtualhost)(|(enabled=true)(id=default_host)))";
        ServiceReference[] refs = this.context.getAllServiceReferences(null, filter);
        if (refs == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"getVirtualHostRefs -- no configured virtual hosts found", (Object[])new Object[0]);
            }
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        for (ServiceReference ref : refs) {
            String id = (String)ref.getProperty("id");
            result.put(id, ref);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"getVirtualHostRefs", (Object[])new Object[]{id, ref});
        }
        return result;
    }

    List<String> getList(String[] property) {
        if (property == null || property.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(property);
    }

    boolean buildServerTransportData(String appServerName, String serverID, HttpEndpointInfo httpEndpointInfo, List<ServerData> serverDataList, boolean preferIPv6, WebContainer container) throws Exception {
        Integer httpsPort;
        String defaultHostName = (String)httpEndpointInfo.getProperty("_defaultHostName");
        String host = (String)httpEndpointInfo.getProperty("host");
        Integer httpPort = (Integer)httpEndpointInfo.getProperty("httpPort");
        if (httpPort == null) {
            httpPort = -1;
        }
        if ((httpsPort = (Integer)httpEndpointInfo.getProperty("httpsPort")) == null) {
            httpsPort = -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("buildServerTransportData: adding " + httpEndpointInfo.getEndpointId()), (Object[])new Object[]{host, defaultHostName, httpPort, httpsPort});
        }
        ServerData sd = new ServerData(appServerName, serverID, this.pcd);
        serverDataList.add(sd);
        sd.nodeName = "default_node";
        if (this.pcd == null || FrameworkState.isStopping() || WebContainer.isServerStopping()) {
            return false;
        }
        sd.hostName = PluginGenerator.tryDetermineHostName(host, defaultHostName, preferIPv6);
        if (!this.utilityRequest && sd.hostName.equals(LOCALHOST)) {
            Tr.warning((TraceComponent)tc, (String)"collocated.appserver", (Object[])new Object[]{sd.nodeName, sd.serverName});
        }
        if (httpPort > 0) {
            sd.addTransportData(sd.hostName, httpPort, false);
        }
        if (httpsPort > 0) {
            sd.addTransportData(sd.hostName, httpsPort, true);
        }
        return true;
    }

    private static String appendWildCardString(String rootURI) {
        String rc = rootURI;
        if (!rc.startsWith("*.")) {
            if (rc.endsWith("/")) {
                rc = rc + "*";
            } else if (!rc.endsWith("/*")) {
                rc = rc + "/*";
            }
        }
        return rc;
    }

    protected static String tryDetermineHostName(String host, String defaultHostName, boolean preferIPv6) {
        String hostName = null;
        hostName = "*".equals(host) && !LOCALHOST.equals(defaultHostName) && !defaultHostName.isEmpty() ? (HostNameUtils.validLocalHostName((String)defaultHostName, (boolean)preferIPv6) ? defaultHostName : LOCALHOST) : HostNameUtils.tryResolveHostName((String)host, (boolean)preferIPv6);
        return hostName == null ? LOCALHOST : hostName;
    }

    @Trivial
    private String addSlash(String input) {
        if (input.endsWith("/") || input.endsWith("\\")) {
            return "";
        }
        return File.separator;
    }

    protected static class PluginConfigData {
        public Integer maxConnections = -1;
        protected String LogFile = "http_plugin.log";
        protected String LogLevel = "Error";
        protected Boolean ESIEnable = Boolean.TRUE;
        protected Integer ESIMaxCacheSize = 1024;
        protected Boolean ESIInvalidationMonitor = Boolean.FALSE;
        protected Boolean ESIEnableToPassCookies = Boolean.FALSE;
        protected String TempPluginConfigFileName = ".plugin-cfg.xml";
        protected String PluginConfigFileName = "plugin-cfg.xml";
        protected String loadBalance = "Round Robin";
        protected Boolean ignoreAffinityRequests = Boolean.TRUE;
        protected Integer retryInterval = 60;
        protected Boolean removeSpecialHeaders = Boolean.TRUE;
        protected Boolean cloneSeparatorChange = Boolean.FALSE;
        protected Integer postSizeLimit = -1;
        protected Integer postBufferSize = 0;
        protected Boolean GetDWLMTable = Boolean.FALSE;
        protected Integer HTTPMaxHeaders = 300;
        protected Boolean TrustedProxyEnable = null;
        protected String[] TrustedProxyGroup = null;
        protected String PluginInstallRoot = null;
        protected String webServerName = null;
        protected Integer webServerHttpPort = 70;
        protected Integer webServerHttpsPort = 343;
        protected String KeyringLocation = null;
        protected String StashfileLocation = null;
        protected String CertLabel = null;
        protected Boolean IPv6Preferred = null;
        protected String httpEndpointPid = null;
        protected Long serverIOTimeout = null;
        protected Long wsServerIOTimeout = null;
        protected Long wsServerIdleTimeout = null;
        public Long connectTimeout = null;
        public Boolean waitForContinue = null;
        protected String LogFileName = null;
        protected String LogDirLocation = null;
        protected Integer serverIOTimeoutRetry = null;
        protected Hashtable<String, String> extraConfigProperties = new Hashtable();
        protected Integer loadBalanceWeight = null;
        protected Role roleKind = null;

        protected PluginConfigData() {
        }

        protected PluginConfigData(Map<String, Object> config) {
            this.PluginInstallRoot = (String)config.get("pluginInstallRoot");
            this.webServerName = (String)config.get("webserverName");
            this.webServerHttpPort = MetatypeUtils.parseInteger((Object)PluginGenerator.PLUGIN_CFG_ALIAS, (String)"webserverPort", (Object)config.get("webserverPort"), (int)this.webServerHttpPort);
            this.webServerHttpsPort = MetatypeUtils.parseInteger((Object)PluginGenerator.PLUGIN_CFG_ALIAS, (String)"webserverSecurePort", (Object)config.get("webserverSecurePort"), (int)this.webServerHttpsPort);
            this.KeyringLocation = (String)config.get("sslKeyringLocation");
            this.StashfileLocation = (String)config.get("sslStashfileLocation");
            this.CertLabel = (String)config.get("sslCertlabel");
            this.IPv6Preferred = (Boolean)config.get("ipv6Preferred");
            this.ignoreAffinityRequests = (Boolean)config.get("ignoreAffinityRequests");
            this.httpEndpointPid = (String)config.get("httpEndpointRef");
            this.serverIOTimeout = (Long)config.get("serverIOTimeout");
            this.wsServerIOTimeout = (Long)config.get("wsServerIOTimeout");
            this.wsServerIdleTimeout = (Long)config.get("wsServerIdleTimeout");
            this.connectTimeout = (Long)config.get("connectTimeout");
            this.waitForContinue = (Boolean)config.get("waitForContinue");
            this.LogFileName = (String)config.get("logFileName");
            this.LogDirLocation = (String)config.get("logDirLocation");
            this.serverIOTimeoutRetry = (Integer)config.get("serverIOTimeoutRetry");
            this.loadBalanceWeight = (Integer)config.get("loadBalanceWeight");
            Role role = this.roleKind = config.get("serverRole") != null && ((String)config.get("serverRole")).equals("BACKUP") ? Role.SECONDARY : Role.PRIMARY;
            if (config.get("ESIEnable") != null) {
                this.ESIEnable = (Boolean)config.get("ESIEnable");
            }
            if (config.get("ESIMaxCacheSize") != null) {
                this.ESIMaxCacheSize = (Integer)config.get("ESIMaxCacheSize");
            }
            if (config.get("ESIInvalidationMonitor") != null) {
                this.ESIInvalidationMonitor = (Boolean)config.get("ESIInvalidationMonitor");
            }
            if (config.get("ESIEnableToPassCookies") != null) {
                this.ESIEnableToPassCookies = (Boolean)config.get("ESIEnableToPassCookies");
            }
            this.TrustedProxyEnable = (Boolean)config.get("trustedProxyEnable");
            String proxyList = (String)config.get("trustedProxyGroup");
            if (proxyList != null) {
                this.TrustedProxyGroup = proxyList.split(",");
            }
            this.extraConfigProperties.put("ASDisableNagle", "false");
            this.extraConfigProperties.put("AcceptAllContent", "false");
            this.extraConfigProperties.put("AppServerPortPreference", "HostHeader");
            this.extraConfigProperties.put("ChunkedResponse", "false");
            this.extraConfigProperties.put("FIPSEnable", "false");
            this.extraConfigProperties.put("IISDisableNagle", "false");
            this.extraConfigProperties.put("IISPluginPriority", "High");
            this.extraConfigProperties.put("IgnoreDNSFailures", "false");
            this.extraConfigProperties.put("RefreshInterval", "60");
            this.extraConfigProperties.put("ResponseChunkSize", "64");
            this.extraConfigProperties.put("SSLConsolidate", "false");
            this.extraConfigProperties.put("TrustedProxyEnable", "false");
            this.extraConfigProperties.put("VHostMatchingCompat", "false");
            if (config.get("extraConfigProperties.0.config.referenceType") != null) {
                for (Map.Entry<String, Object> entry : config.entrySet()) {
                    if (!entry.getKey().startsWith("extraConfigProperties.0") || entry.getKey().equals("extraConfigProperties.0.config.referenceType")) continue;
                    String value = (String)config.get(entry.getKey());
                    String key = entry.getKey().substring(24);
                    this.extraConfigProperties.put(key, value);
                }
            }
        }

        protected ServerClusterData createServerCluster(String cName, boolean singleServerConfig) {
            ServerClusterData scd = new ServerClusterData(cName, singleServerConfig);
            scd.loadBalance = this.loadBalance;
            scd.retryInterval = this.retryInterval;
            scd.serverIOTimeoutRetry = this.serverIOTimeoutRetry;
            scd.removeSpecialHeaders = this.removeSpecialHeaders;
            scd.cloneSeparatorChange = this.cloneSeparatorChange;
            scd.postSizeLimit = this.postSizeLimit;
            scd.postBufferSize = this.postBufferSize;
            scd.GetDWLMTable = this.GetDWLMTable;
            return scd;
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"PluginConfigData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   PluginInstallRoot       : " + this.PluginInstallRoot), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   PluginConfigFileName    : " + this.PluginConfigFileName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   httpEndpointRef         : " + this.httpEndpointPid), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   webserver http port     : " + this.webServerHttpPort), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   webserver https port    : " + this.webServerHttpsPort), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   LogFile                 : " + this.LogFile), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   LogLevel                : " + this.LogLevel), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   LogDirLocation         : " + this.LogDirLocation), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   ESIEnable               : " + this.ESIEnable), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   ESIMaxCacheSize         : " + this.ESIMaxCacheSize), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   ESIInvalidationMonitor  : " + this.ESIInvalidationMonitor), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   ESIEnableToPassCookies  : " + this.ESIEnableToPassCookies), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   loadBalance             : " + this.loadBalance), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   IgnoreAffinityRequests  : " + this.ignoreAffinityRequests), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   retryInterval           : " + this.retryInterval), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverIOTimeoutRetry    : " + this.serverIOTimeoutRetry), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   removeSpecialHeaders    : " + this.removeSpecialHeaders), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cloneSeparatorChange    : " + this.cloneSeparatorChange), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   postSizeLimit           : " + this.postSizeLimit), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   postBufferSize          : " + this.postBufferSize), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverIOTimeout         : " + this.serverIOTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   wsServerIOTimeout       : " + this.wsServerIOTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   wsServerIdleTimeout     : " + this.wsServerIdleTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   GetDWLMTable            : " + this.GetDWLMTable), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   HTTPMaxHeaders          : " + this.HTTPMaxHeaders), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   CertLabel               : " + this.CertLabel), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   KeyringLocation         : " + this.KeyringLocation), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   StashfileLocation       : " + this.StashfileLocation), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   TrustedProxyEnable      : " + this.TrustedProxyEnable), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   TrustedProxyGroup       : " + this.traceList(this.TrustedProxyGroup)), (Object[])new Object[0]);
                if (!this.extraConfigProperties.isEmpty()) {
                    Tr.debug((TraceComponent)trace, (String)("   AdditionalConfigProps   : " + this.extraConfigProperties.toString()), (Object[])new Object[0]);
                }
            }
        }

        private String traceList(String[] list) {
            if (list == null || list.length == 0) {
                return "none";
            }
            StringBuilder sb = new StringBuilder();
            for (String element : list) {
                sb.append("\n\t").append(element);
            }
            return sb.toString();
        }
    }

    protected class PluginConfigQuickPeek {
        private static final int UNSET = -2;
        private static final int UNKNOWN = -1;
        private XMLRootHandler handler = null;
        private int hash = -2;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PluginConfigQuickPeek(InputStream in) {
            if (in != null) {
                try {
                    InputSource inputSource = new InputSource(in);
                    this.handler = new XMLRootHandler();
                    this.handler.parseContents(inputSource);
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        in.reset();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                this.hash = -1;
            }
        }

        public int getHashValue() {
            if (this.hash == -2) {
                this.hash = this.handler.getHashValue();
                if (this.hash == -2) {
                    this.hash = -1;
                }
            }
            return this.hash;
        }

        public void setHashValue(int hashValue) {
            this.hash = hashValue;
        }
    }

    protected static class HttpEndpointInfo {
        private final String httpEndpointId;
        private final ServiceReference<?> httpEndpointRef;

        HttpEndpointInfo(BundleContext context, Document doc, String pid) {
            ServiceReference<?> serviceRef = null;
            String idFilter = "(service.pid=" + pid + ")";
            if (pid == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"HttpEndpointInfo -- no endpoint specified in config", (Object[])new Object[0]);
                }
                idFilter = "(id=defaultHttpEndpoint)";
            }
            String filter = "(&(enabled=true)(|(httpPort>=1)(httpsPort>=1))" + idFilter + ")";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("HttpEndpointInfo -- looking for configured endpoints matching " + filter), (Object[])new Object[0]);
            }
            if ((serviceRef = this.getService(context, filter)) == null) {
                ServiceReference<?> ref;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"HttpEndpointInfo -- no enabled/listening endpoints found", (Object[])new Object[0]);
                }
                if ((ref = this.getService(context, idFilter)) != null) {
                    String id = (String)ref.getProperty("id");
                    Comment comment = doc.createComment(String.format(" The endpoint %s was not found or is not enabled", id));
                    doc.getDocumentElement().appendChild(comment);
                } else {
                    Comment comment = doc.createComment(String.format(" No endpoint could be found with pid %s.", pid));
                    doc.getDocumentElement().appendChild(comment);
                }
            }
            if (serviceRef == null && (serviceRef = this.getService(context, "(&(enabled=true)(httpPort>=1)(httpsPort>=1))")) == null) {
                serviceRef = this.getService(context, "(&(enabled=true)(|(httpPort>=1)(httpsPort>=1)))");
            }
            if (serviceRef != null) {
                this.httpEndpointRef = serviceRef;
                this.httpEndpointId = (String)serviceRef.getProperty("id");
                Comment comment = doc.createComment(" Configuration generated using httpEndpointRef=" + this.httpEndpointId);
                doc.getDocumentElement().appendChild(comment);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"HttpEndpointInfo -- could not find a valid endpoint", (Object[])new Object[0]);
                }
                this.httpEndpointRef = null;
                this.httpEndpointId = "defaultHttpEndpoint";
            }
        }

        public Object getProperty(String key) {
            if (this.httpEndpointRef != null) {
                return this.httpEndpointRef.getProperty(key);
            }
            return null;
        }

        public boolean isValid() {
            return this.httpEndpointRef != null;
        }

        public Object getEndpointId() {
            return this.httpEndpointId;
        }

        @FFDCIgnore(value={InvalidSyntaxException.class})
        ServiceReference<?> getService(BundleContext context, String filter) {
            ServiceReference[] refs = null;
            try {
                refs = context.getAllServiceReferences(null, filter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            if (refs == null || refs.length == 0) {
                return null;
            }
            return refs[0];
        }
    }

    protected static class VHostData {
        protected final String host;
        protected final int port;

        protected VHostData(String inHost, int inPort) throws UnknownHostException {
            this.host = inHost;
            this.port = inPort;
        }

        protected VHostData(String alias) throws UnknownHostException {
            int lastIndex = alias.lastIndexOf(58);
            this.host = alias.substring(0, lastIndex);
            this.port = Integer.valueOf(alias.substring(lastIndex + 1));
        }

        public String toString() {
            return "vhost(http=" + this.host + ':' + this.port + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VHostData other = (VHostData)obj;
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            return this.port == other.port;
        }
    }

    protected static class ServerClusterData {
        protected String clusterName;
        protected String loadBalance;
        protected Integer retryInterval;
        protected Integer serverIOTimeoutRetry;
        protected Boolean removeSpecialHeaders;
        protected Boolean cloneSeparatorChange;
        protected Boolean GetDWLMTable;
        protected Integer postSizeLimit;
        protected Integer postBufferSize;
        protected List<ServerData> clusterServers = new LinkedList<ServerData>();
        protected List<DeployedModuleData> deployedModules = new ArrayList<DeployedModuleData>();
        protected String fileServingEnabled = "NOT_DEFINED";
        protected String serveServletsByClassnameEnabled = "NOT_DEFINED";
        protected Boolean singleServerConfig;

        public ServerClusterData(String cName, boolean singleServerConfig) {
            this.clusterName = cName;
            this.singleServerConfig = singleServerConfig;
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"ServerClusterData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   clusterName                     : " + this.clusterName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   loadBalance                     : " + this.loadBalance), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   retryInterval                   : " + this.retryInterval), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverIOTimeoutRetry            : " + this.serverIOTimeoutRetry), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   removeSpecialHeaders            : " + this.removeSpecialHeaders), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cloneSeparatorChange            : " + this.cloneSeparatorChange), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   postSizeLimit                   : " + this.postSizeLimit), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   postBufferSize                  : " + this.postBufferSize), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   clusterServers                  : " + this.clusterServers), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   deployedModules                 : " + this.deployedModules), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   fileServingEnabled              : " + this.fileServingEnabled), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serveServletsByClassnameEnabled : " + this.serveServletsByClassnameEnabled), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   singleServerConfig              : " + this.singleServerConfig), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   getDWLMTable                    : " + this.GetDWLMTable), (Object[])new Object[0]);
            }
        }
    }

    protected static class ServerData {
        protected String serverName = null;
        protected String serverID = "";
        protected String cellName = null;
        protected String nodeName = null;
        protected String hostName = null;
        protected List<TransportData> transports = new LinkedList<TransportData>();
        protected Long connectTimeout = 5L;
        protected Long serverIOTimeout = 0L;
        protected Long wsServerIOTimeout = null;
        protected Long wsServerIdleTimeout = null;
        protected Boolean waitForContinue = Boolean.FALSE;
        protected Integer maxConnections = -1;
        protected Role roleKind = Role.PRIMARY;
        protected String sessionManagerCookieName = "JSESSIONID";
        protected String sessionURLIdentifier = "jsessionid";
        protected String cloneSeparator = null;
        protected String fileServingEnabled = "NOT_DEFINED";
        protected String serveServletsByClassnameEnabled = "NOT_DEFINED";
        protected Integer loadBalanceWeight = 20;

        public ServerData(String name, String serverID, PluginConfigData pcd) {
            this.serverName = name;
            if (serverID != null) {
                this.serverID = serverID;
            }
            this.nodeName = null;
            this.serverIOTimeout = pcd.serverIOTimeout;
            this.wsServerIOTimeout = pcd.wsServerIOTimeout;
            this.wsServerIdleTimeout = pcd.wsServerIdleTimeout;
            this.connectTimeout = pcd.connectTimeout;
            this.waitForContinue = pcd.waitForContinue;
            this.maxConnections = pcd.maxConnections;
            this.loadBalanceWeight = pcd.loadBalanceWeight;
            this.roleKind = pcd.roleKind;
        }

        protected TransportData addTransportData(String hostName, int port, boolean isSecurity) {
            TransportData td = new TransportData(hostName, port, isSecurity);
            this.transports.add(td);
            return td;
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"ServerData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cellName                        : " + this.cellName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   nodeName                        : " + this.nodeName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverName                      : " + this.serverName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverID                        : " + this.serverID), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   hostName                        : " + this.hostName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   transports                      : " + this.transports), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   connectTimeout                  : " + this.connectTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverIOTimeout                 : " + this.serverIOTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   wsServerIOTimeout               : " + this.wsServerIOTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   wsServerIdleTimeout             : " + this.wsServerIdleTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   waitForContinue                 : " + this.waitForContinue), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   maxConnections                  : " + this.maxConnections), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   roleKind                        : " + (Object)((Object)this.roleKind)), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   sessionManagerCookieName        : " + this.sessionManagerCookieName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   sessionURLIdentifier            : " + this.sessionURLIdentifier), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cloneSeparator                  : " + this.cloneSeparator), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   fileServingEnabled              : " + this.fileServingEnabled), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serveServletsByClassnameEnabled : " + this.serveServletsByClassnameEnabled), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   loadBalanceWeight               : " + this.loadBalanceWeight), (Object[])new Object[0]);
            }
        }
    }

    protected static class TransportData {
        protected String host;
        protected int port;
        protected boolean isSslEnabled;

        public TransportData(String hostName, int portNumber, boolean sslEnabled) {
            this.host = hostName;
            this.port = portNumber;
            this.isSslEnabled = sslEnabled;
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"TransportData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   host        : " + this.host), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   port        : " + this.port), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   sslEnabled  : " + this.isSslEnabled), (Object[])new Object[0]);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (null == o || !(o instanceof TransportData)) {
                return false;
            }
            TransportData td = (TransportData)o;
            return td.host.equals(this.host) && td.port == this.port && td.isSslEnabled == this.isSslEnabled;
        }

        public int hashCode() {
            return this.host.hashCode() + this.port;
        }

        public String toString() {
            return "transportData(host=" + this.host + ", port=" + this.port + ", isSSL=" + this.isSslEnabled + ")";
        }
    }

    protected static enum Role {
        PRIMARY,
        SECONDARY;

    }

    protected static class DeployedModuleData {
        protected WebApp app = null;
        protected WebAppConfiguration moduleConfig;
        protected String cookieName = "JSESSIONID";
        protected String urlCookieName = "jsessionid";
        protected List<String> additionalPatterns = null;

        protected DeployedModuleData(WebApp application, String defaultAffinityCookie, String affinityUrlIdentifier) {
            this.app = application;
            this.moduleConfig = application.getConfiguration();
            SessionCookieConfig cookieConfig = null;
            try {
                cookieConfig = application.getSessionCookieConfig();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (cookieConfig == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The application named " + application.getName() + " has not been initialized yet, so the plugin configuration will use the default (server-level) affinity cookie. If this application programmatically modifies the affinity cookie's name during initialization, that change will not be reflected in the plugin configuration unless the plugin configuration is regenerated after application initialization."), (Object[])new Object[0]);
                }
                if (defaultAffinityCookie != null) {
                    this.cookieName = defaultAffinityCookie;
                }
            } else {
                String cookieName = cookieConfig.getName();
                if (cookieName != null) {
                    this.cookieName = cookieName;
                }
            }
            if (affinityUrlIdentifier != null) {
                this.urlCookieName = affinityUrlIdentifier;
            }
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"DeploymentModuleData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   moduleConfig         : " + this.moduleConfig), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cookieName           : " + this.cookieName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   urlCookieName        : " + this.urlCookieName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   additionalPatterns   : " + this.additionalPatterns), (Object[])new Object[0]);
            }
        }
    }

    protected static class URIData {
        protected String uriName;
        protected String cookieName;
        protected String urlCookieName;

        public URIData(String uName, String cName, String urlName) {
            this.uriName = uName;
            this.cookieName = cName;
            this.urlCookieName = urlName;
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"URIData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   uriName       : " + this.uriName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cookieName    : " + this.cookieName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   urlCookieName : " + this.urlCookieName), (Object[])new Object[0]);
            }
        }

        public int hashCode() {
            int result = this.uriName.hashCode();
            result = 31 * result + this.cookieName.hashCode();
            result = 31 * result + this.urlCookieName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj || !(obj instanceof URIData)) {
                return false;
            }
            URIData that = (URIData)obj;
            return this.uriName.equals(that.uriName);
        }
    }

    protected static class ClusterUriGroup {
        protected String clusterName;
        protected String uriGroupName;
        protected String vhostName;

        protected ClusterUriGroup(String vhostName, String clusterName, String uriGroupName) {
            this.vhostName = vhostName;
            this.clusterName = clusterName;
            this.uriGroupName = uriGroupName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clusterName == null ? 0 : this.clusterName.hashCode());
            result = 31 * result + (this.uriGroupName == null ? 0 : this.uriGroupName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClusterUriGroup other = (ClusterUriGroup)obj;
            if (this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName)) {
                return false;
            }
            return !(this.uriGroupName == null ? other.uriGroupName != null : !this.uriGroupName.equals(other.uriGroupName));
        }
    }

    protected class XMLRootHandler
    extends DefaultHandler
    implements LexicalHandler {
        private String elementFound = null;
        private Attributes attributesFound = null;

        public String getRootName() {
            return this.elementFound;
        }

        public Attributes getRootAttributes() {
            return this.attributesFound;
        }

        @Override
        public final void comment(char[] ch, int start, int length) {
        }

        private final SAXParser createParser(SAXParserFactory parserFactory) throws ParserConfigurationException, SAXException, SAXNotRecognizedException, SAXNotSupportedException {
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            try {
                reader.setFeature("http://xml.org/sax/features/validation", false);
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            return parser;
        }

        @Override
        public final void endCDATA() {
        }

        @Override
        public final void endDTD() {
        }

        @Override
        public final void endEntity(String name) {
        }

        public boolean parseContents(InputSource contents) throws IOException, ParserConfigurationException, SAXException {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                if (factory == null) {
                    return false;
                }
                SAXParser parser = this.createParser(factory);
                contents.setSystemId("/");
                parser.parse(contents, (DefaultHandler)this);
            }
            catch (StopParsingException stopParsingException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new StringReader(""));
        }

        @Override
        public final void startCDATA() {
        }

        @Override
        public final void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public final void startElement(String uri, String elementName, String qualifiedName, Attributes attributes) throws SAXException {
            String string = this.elementFound = elementName == null || elementName.length() == 0 ? qualifiedName : elementName;
            if (this.elementFound.indexOf(58) != -1) {
                this.elementFound = this.elementFound.substring(this.elementFound.indexOf(58) + 1);
            }
            this.attributesFound = attributes;
            throw new StopParsingException();
        }

        @Override
        public final void startEntity(String name) {
        }

        public int getHashValue() {
            String hash = this.attributesFound.getValue("ConfigHash");
            if (hash != null) {
                return new Integer(hash);
            }
            return 0;
        }

        private class StopParsingException
        extends SAXException {
            private static final long serialVersionUID = 1L;

            public StopParsingException() {
                super((String)null);
            }
        }
    }
}

