/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.util._ValidationUtils;

public final class ExternalSpecifications {
    private static final Logger log = Logger.getLogger(ExternalSpecifications.class.getName());
    private static volatile Boolean beanValidationAvailable;
    private static volatile Boolean unifiedELAvailable;
    private static volatile Boolean cdiAvailable;
    private static volatile Boolean el3Available;

    public static boolean isBeanValidationAvailable() {
        if (beanValidationAvailable == null) {
            try {
                try {
                    beanValidationAvailable = Class.forName("javax.validation.Validation") != null;
                }
                catch (ClassNotFoundException e) {
                    beanValidationAvailable = Boolean.FALSE;
                }
                if (beanValidationAvailable.booleanValue()) {
                    try {
                        _ValidationUtils.tryBuildDefaultValidatorFactory();
                    }
                    catch (Throwable t) {
                        beanValidationAvailable = false;
                    }
                }
            }
            catch (Throwable t) {
                log.log(Level.FINE, "Error loading class (could be normal)", t);
                beanValidationAvailable = false;
            }
            log.info("MyFaces Bean Validation support " + (beanValidationAvailable != false ? "enabled" : "disabled"));
        }
        return beanValidationAvailable;
    }

    public static boolean isUnifiedELAvailable() {
        if (unifiedELAvailable == null) {
            try {
                unifiedELAvailable = Class.forName("javax.el.ValueReference") != null && Class.forName("javax.el.ValueExpression").getMethod("getValueReference", ELContext.class) != null;
            }
            catch (Throwable t) {
                unifiedELAvailable = false;
            }
            log.info("MyFaces Unified EL support " + (unifiedELAvailable != false ? "enabled" : "disabled"));
        }
        return unifiedELAvailable;
    }

    public static boolean isCDIAvailable(ExternalContext externalContext) {
        if (cdiAvailable == null) {
            try {
                cdiAvailable = Class.forName("javax.enterprise.inject.spi.BeanManager") != null;
            }
            catch (Throwable t) {
                cdiAvailable = false;
            }
            log.info("MyFaces CDI support " + (cdiAvailable != false ? "enabled" : "disabled"));
        }
        return cdiAvailable != false && externalContext.getApplicationMap().containsKey("oam.cdi.BEAN_MANAGER_INSTANCE");
    }

    public static boolean isEL3Available() {
        if (el3Available == null) {
            try {
                el3Available = Class.forName("javax.el.StaticFieldELResolver") != null;
            }
            catch (Throwable t) {
                el3Available = false;
            }
            log.info("MyFaces EL 3.0 support " + (el3Available != false ? "enabled" : "disabled"));
        }
        return el3Available;
    }

    private ExternalSpecifications() {
    }
}

