/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.monitor;

import com.ibm.websphere.ras.annotation.Trivial;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@Trivial
public class RestMonitorKeyCache {
    private final ConcurrentHashMap<RestResourceMethodKey, MonitorKey> routes = new ConcurrentHashMap();
    private final ReferenceQueue<Class<?>> referenceQueue = new ReferenceQueue();

    public MonitorKey getMonitorKey(Class<?> restClass, Method restMethod) {
        this.evictGarbageCollectedEntries();
        return this.routes.get(new RestResourceMethodKey(restClass, restMethod));
    }

    public void putMonitorKey(Class<?> restClass, Method restMethod, MonitorKey monitorKey) {
        this.evictGarbageCollectedEntries();
        this.routes.put(new RestResourceMethodKey(this.referenceQueue, restClass, restMethod), monitorKey);
    }

    private void evictGarbageCollectedEntries() {
        RestMonitorKeyWeakReference key;
        while ((key = (RestMonitorKeyWeakReference)this.referenceQueue.poll()) != null) {
            this.routes.remove(key.getOwningKey());
        }
    }

    @Trivial
    private static class RestResourceMethodKey {
        private final RestMonitorKeyWeakReference<Class<?>> restClassRef;
        private final RestMonitorKeyWeakReference<Method> restMethodRef;
        private final int hash;

        RestResourceMethodKey(Class<?> restClass, Method restMethod) {
            this.restClassRef = new RestMonitorKeyWeakReference(restClass, this);
            this.restMethodRef = new RestMonitorKeyWeakReference<Method>(restMethod, this);
            this.hash = Objects.hash(restClass, restMethod);
        }

        RestResourceMethodKey(ReferenceQueue<Class<?>> referenceQueue, Class<?> restClass, Method restMethod) {
            this.restClassRef = new RestMonitorKeyWeakReference(restClass, this, referenceQueue);
            this.restMethodRef = new RestMonitorKeyWeakReference<Method>(restMethod, this);
            this.hash = Objects.hash(restClass, restMethod);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RestResourceMethodKey other = (RestResourceMethodKey)obj;
            if (!this.restClassRef.equals(other.restClassRef)) {
                return false;
            }
            return this.restMethodRef.equals(other.restMethodRef);
        }
    }

    @Trivial
    static class MonitorKey {
        final String statsKey;
        final String statsKeyPrefix;
        final String statsMethodName;

        MonitorKey(String statsKey, String statsKeyPrefix, String statsMethodName) {
            this.statsKey = statsKey;
            this.statsKeyPrefix = statsKeyPrefix;
            this.statsMethodName = statsMethodName;
        }

        public String toString() {
            return "MonitorKey [statsKey=" + this.statsKey + ", statsKeyPrefix=" + this.statsKeyPrefix + ", statsMethodName=" + this.statsMethodName + "]";
        }
    }

    @Trivial
    private static class RestMonitorKeyWeakReference<T>
    extends WeakReference<T> {
        private final RestResourceMethodKey owningKey;

        RestMonitorKeyWeakReference(T referent, RestResourceMethodKey owningKey) {
            super(referent);
            this.owningKey = owningKey;
        }

        RestMonitorKeyWeakReference(T referent, RestResourceMethodKey owningKey, ReferenceQueue<T> referenceQueue) {
            super(referent, referenceQueue);
            this.owningKey = owningKey;
        }

        RestResourceMethodKey getOwningKey() {
            return this.owningKey;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof RestMonitorKeyWeakReference) {
                return this.get() == ((RestMonitorKeyWeakReference)obj).get();
            }
            return false;
        }

        public String toString() {
            Object referent = this.get();
            return "RestMonitorKeyWeakReference: " + referent;
        }
    }
}

