/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.utils;

import com.ibm.tx.util.LongObjectHashMap;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class RecoverableUnitIdTable {
    private static final TraceComponent tc = Tr.register(RecoverableUnitIdTable.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private long _idCount = 1L;
    private final LongObjectHashMap _idMap = new LongObjectHashMap(256);
    static final long serialVersionUID = -7090473416127697936L;

    @ManualTrace
    public final synchronized long nextId(Object obj) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nextId", (Object[])new Object[]{obj});
        }
        long id = this._idCount++;
        while (this._idMap.get(id) != null) {
            ++this._idCount;
        }
        this._idMap.put(id, obj);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"nextId", (Object)id);
        }
        return id;
    }

    @ManualTrace
    public final synchronized void removeId(long id) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeId", (Object[])new Object[]{id});
        }
        this._idMap.remove(id);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeId");
        }
    }

    @ManualTrace
    public final synchronized boolean reserveId(long id, Object obj) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reserveId", (Object[])new Object[]{id, obj});
        }
        boolean reserved = false;
        if (this._idMap.get(id) == null) {
            this._idMap.put(id, obj);
            reserved = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reserveId", (Object)reserved);
        }
        return reserved;
    }

    @ManualTrace
    public final synchronized Object[] getAllObjects() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAllObjects", (Object[])new Object[0]);
        }
        Object[] values = this._idMap.values();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAllObjects", (Object)values);
        }
        return values;
    }
}

