/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi;

import com.ibm.ws.jndi.WSName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public enum WSNameUtil {


    public static WSName normalize(Name name) throws InvalidNameException {
        if (name == null || name.isEmpty()) {
            return WSName.EMPTY_NAME;
        }
        return name instanceof WSName ? (WSName)name : new WSName(name);
    }

    public static WSName normalize(String name) throws InvalidNameException {
        if (name == null || name.isEmpty()) {
            return WSName.EMPTY_NAME;
        }
        return new WSName(name);
    }

    public static WSName copy(Name n) throws InvalidNameException {
        return n instanceof WSName ? (WSName)n.clone() : new WSName(n);
    }

    public static WSName copy(String s) throws InvalidNameException {
        return WSNameUtil.normalize(s);
    }

    public static WSName compose(Name prefix, Name suffix) throws InvalidNameException {
        return WSNameUtil.copy(prefix).addAll(suffix);
    }

    public static String compose(String prefix, String suffix) throws InvalidNameException {
        return WSNameUtil.copy(prefix).addAll(WSNameUtil.normalize(suffix)).toString();
    }
}

