/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.spi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;

public abstract class ConfigProviderResolver {
    private static volatile ConfigProviderResolver instance = null;

    protected ConfigProviderResolver() {
    }

    public abstract Config getConfig();

    public abstract Config getConfig(ClassLoader var1);

    public abstract ConfigBuilder getBuilder();

    public abstract void registerConfig(Config var1, ClassLoader var2);

    public abstract void releaseConfig(Config var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigProviderResolver instance() {
        if (instance != null) return instance;
        Class<ConfigProviderResolver> clazz = ConfigProviderResolver.class;
        synchronized (ConfigProviderResolver.class) {
            ConfigProviderResolver newInstance;
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            if (cl == null) {
                cl = ConfigProviderResolver.class.getClassLoader();
            }
            if ((newInstance = ConfigProviderResolver.loadSpi(cl)) == null) {
                throw new IllegalStateException("No ConfigProviderResolver implementation found!");
            }
            instance = newInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static ConfigProviderResolver loadSpi(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        ConfigProviderResolver instance = ConfigProviderResolver.loadSpi(cl.getParent());
        if (instance == null) {
            ServiceLoader<ConfigProviderResolver> sl = ServiceLoader.load(ConfigProviderResolver.class, cl);
            for (ConfigProviderResolver spi : sl) {
                if (instance != null) {
                    throw new IllegalStateException("Multiple ConfigResolverProvider implementations found: " + spi.getClass().getName() + " and " + instance.getClass().getName());
                }
                instance = spi;
            }
        }
        return instance;
    }

    public static void setInstance(ConfigProviderResolver resolver) {
        instance = resolver;
    }
}

