/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;

public class ServerValidator
extends TypeValidator<Server> {
    private static final TraceComponent tc = Tr.register(ServerValidator.class);
    private static final ServerValidator INSTANCE = new ServerValidator();

    public static ServerValidator getInstance() {
        return INSTANCE;
    }

    private ServerValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Server t) {
        String url = t.getUrl();
        if (url != null) {
            Set<String> variables = this.validateURL(helper, context, url);
            this.validateServerVariables(helper, context, variables, t);
        } else {
            ValidatorUtils.validateRequiredField(url, context, "url").ifPresent(helper::addValidationEvent);
        }
    }

    private void validateServerVariables(ValidationHelper helper, OpenAPIModelWalker.Context context, Set<String> variables, Server t) {
        ServerVariables serverVariables = t.getVariables();
        for (String variable : variables) {
            if (serverVariables != null && serverVariables.containsKey((Object)variable)) continue;
            String message = Tr.formatMessage((TraceComponent)tc, (String)"serverVariableNotDefined", (Object[])new Object[]{variable});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("variables"), message));
        }
    }

    private Set<String> validateURL(ValidationHelper helper, OpenAPIModelWalker.Context context, String url) {
        String pathToCheck = url;
        HashSet<String> serverVariables = new HashSet<String>();
        while (pathToCheck.contains("{")) {
            int lastIndex;
            if (!pathToCheck.contains("}")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"serverInvalidURL", (Object[])new Object[]{pathToCheck});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("url"), message));
                return serverVariables;
            }
            int firstIndex = pathToCheck.indexOf("{");
            if (firstIndex > (lastIndex = pathToCheck.indexOf("}"))) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"serverInvalidURL", (Object[])new Object[]{pathToCheck});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("url"), message));
                return serverVariables;
            }
            String variable = pathToCheck.substring(firstIndex + 1, lastIndex);
            if (variable.isEmpty() || variable.contains("{") || variable.contains("/")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"serverInvalidURL", (Object[])new Object[]{pathToCheck});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("url"), message));
                return serverVariables;
            }
            serverVariables.add(variable);
            pathToCheck = pathToCheck.substring(lastIndex + 1);
        }
        if (pathToCheck.contains("}")) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"serverInvalidURL", (Object[])new Object[]{pathToCheck});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("url"), message));
            return serverVariables;
        }
        return serverVariables;
    }
}

